/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.cli.api.IConvertLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.IExportTranslationStatisticsApi;
import com.e1c.langtool.v8.dt.cli.api.IGenerateTranslationStringsApi;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.IProjectInformationApi;
import com.e1c.langtool.v8.dt.cli.api.ISynchronizeProjectApi;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliApiModule;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class CliPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.cli.api.impl";
    private static CliPlugin plugin;
    private static BundleContext context;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static CliPlugin getDefault() {
        return plugin;
    }

    static BundleContext getContext() {
        return context;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logDebug(String message) {
        if (CliPlugin.getDefault().isDebugging()) {
            CliPlugin.log(CliPlugin.createInfoStatus(message));
        }
    }

    public static void logError(Throwable throwable) {
        CliPlugin.log(CliPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createInfoStatus(String message) {
        return new Status(1, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
        this.registrator = new InjectorAwareServiceRegistrator(bundleContext, this::getInjector);
        ServiceInitialization.schedule(() -> {
            this.registrator.service(IGenerateTranslationStringsApi.class).registerInjected();
            this.registrator.service(ISynchronizeProjectApi.class).registerInjected();
            this.registrator.service(IProjectInformationApi.class).registerInjected();
            this.registrator.service(IImportLanguageProjectApi.class).registerInjected();
            this.registrator.service(IExportTranslationStatisticsApi.class).registerInjected();
            this.registrator.service(IConvertLanguageProjectApi.class).registerInjected();
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registrator.unregisterServices();
        context = null;
        plugin = null;
        this.injector = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<CliPlugin> clazz = CliPlugin.class;
        synchronized (CliPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new CliApiModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            CliPlugin.log(CliPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

