/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.e1c.langtool.v8.dt.languageconverter.LanguageConverter;
import com.google.inject.Inject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class ConvertLanguageCommand
extends BaseCliCommand {
    private final IConfigurationProvider configurationProvider;
    private final LanguageConverter languageConverter;

    @Inject
    public ConvertLanguageCommand(IConfigurationProvider configurationProvider, LanguageConverter languageConverter) {
        this.configurationProvider = configurationProvider;
        this.languageConverter = languageConverter;
    }

    @CliCommand(command="convert-languages", value="ConvertLanguageCommand_Description")
    public IStatus c1_\u0441onvertLanguages(@Argument(value={"--project"}, descriptor="ConvertLanguageCommand_Param_project_location_description") java.nio.file.Path projectLocation, @Argument(value={"--languages"}, descriptor="ConvertLanguageCommand_Param_languages_description") String[] languages, @Argument(value={"--language-project"}, descriptor="ConvertLanguageCommand_Param_language_project_location_description") java.nio.file.Path languagesProjectLocation, @Argument(value={"--storage"}, defaultValue="edit:default", descriptor="ConvertLanguageCommand_Param_storage_description") String targetStorage, @Argument(value={"--save-interface-to-storage"}, defaultValue="true", descriptor="ConvertLanguageCommand_Param_save_interface_to_storage_description") boolean saveInterfaceToStorage) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project location: {}", (Object)projectLocation);
            logger.debug("Languages to convert: {}", (Object)String.join((CharSequence)", ", languages));
            logger.debug("Languages project location: {}", (Object)languagesProjectLocation);
            logger.debug("Languages interface translation storage: {}", (Object)targetStorage);
            logger.debug("Save interface to storage: {}", (Object)saveInterfaceToStorage);
        }
        try {
            StorageID targetStorageId = StorageID.create((String)targetStorage);
            IProject target = this.importOrCreateProject(languagesProjectLocation.toAbsolutePath());
            if (target != null && !target.getLocation().toFile().toPath().equals(languagesProjectLocation.toAbsolutePath())) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Other_project_exist_in_workspace_with_same_name__0, target.getName());
                return CliPlugin.createErrorStatus(message, null);
            }
            if (target == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Langauge_project_cannot_be_created_or_imported__0, languagesProjectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
            IDtProject dtProject = this.startDtProject(projectLocation.toAbsolutePath());
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Configuration_project_not_found__0, projectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            IProject project = dtProject.getWorkspaceProject();
            this.languageConverter.convertLanguages(project, selectedLanguages, target, saveInterfaceToStorage, targetStorageId, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.ConvertLanguageCommand_Language_conversion_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    @CliCommand(command="convert-languages", value="ConvertLanguageCommand_Description")
    public IStatus c2_\u0441onvertLanguages(@Argument(value={"--project-name"}, descriptor="ConvertLanguageCommand_Param_project_name_description") IProject project, @Argument(value={"--languages"}, descriptor="ConvertLanguageCommand_Param_languages_description") String[] languages, @Argument(value={"--language-project"}, descriptor="ConvertLanguageCommand_Param_language_project_location_description") java.nio.file.Path languagesProjectLocation, @Argument(value={"--storage"}, defaultValue="edit:default", descriptor="ConvertLanguageCommand_Param_storage_description") String targetStorage, @Argument(value={"--save-interface-to-storage"}, defaultValue="true", descriptor="ConvertLanguageCommand_Param_save_interface_to_storage_description") boolean saveInterfaceToStorage) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project: {}", (Object)project);
            logger.debug("Languages to convert: {}", (Object)String.join((CharSequence)", ", languages));
            logger.debug("Languages project location: {}", (Object)languagesProjectLocation);
            logger.debug("Languages interface translation storage: {}", (Object)targetStorage);
            logger.debug("Save interface to storage: {}", (Object)saveInterfaceToStorage);
        }
        try {
            StorageID targetStorageId = StorageID.create((String)targetStorage);
            IProject target = this.importOrCreateProject(languagesProjectLocation.toAbsolutePath());
            if (target != null && !target.getLocation().toFile().toPath().equals(languagesProjectLocation.toAbsolutePath())) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Other_project_exist_in_workspace_with_same_name__0, target.getName());
                return CliPlugin.createErrorStatus(message, null);
            }
            if (target == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Langauge_project_cannot_be_created_or_imported__0, languagesProjectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            IDtProject dtProject = this.getContext().getDtProjectManager().getDtProject(project);
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Configuration_project_not_found__0, project);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.ConvertLanguageCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            this.languageConverter.convertLanguages(project, selectedLanguages, target, saveInterfaceToStorage, targetStorageId, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.ConvertLanguageCommand_Language_conversion_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    private Set<Language> getSelectedLanguages(IDtProject dtProject, String[] languages) {
        return (Set)this.exclusiveOperation("LT-convert-languages-get-languages", dtProject, ProjectPipelineJob.BEFORE_BUILD_DD, () -> {
            Configuration configuration = this.configurationProvider.getConfiguration(dtProject);
            if (configuration == null) {
                return null;
            }
            TreeSet<String> languageNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            languageNames.addAll(List.of(languages));
            Language defaultLang = configuration.getDefaultLanguage();
            if (defaultLang != null) {
                languageNames.remove(defaultLang.getName());
            }
            return configuration.getLanguages().stream().filter(l -> languageNames.contains(l.getName())).collect(Collectors.toSet());
        });
    }

    private IProject importOrCreateProject(java.nio.file.Path projectDir) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File projectFile = projectDir.resolve(".project").toFile();
        if (projectFile.exists()) {
            IProjectDescription description = workspace.loadProjectDescription((IPath)new Path(projectFile.toString()));
            String projectName = description.getName();
            IProject project = workspace.getRoot().getProject(projectName);
            if (project.exists()) {
                return project;
            }
            this.getContext().getLogger().info("Importing project: {}", (Object)projectName);
            return this.getContext().getWorkspaceSupport().setUpProject(projectName, projectDir);
        }
        String projectName = projectDir.getFileName().toString();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return project;
        }
        this.getContext().getLogger().info("Creating project: {}", (Object)projectName);
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocation((IPath)new Path(projectDir.toString()));
        workspace.run(monitor -> {
            project.create(description, monitor);
            project.open(monitor);
            project.setDefaultCharset(StandardCharsets.UTF_8.name(), monitor);
        }, (IProgressMonitor)new NullProgressMonitor());
        return project;
    }
}

