/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.platform.IDtProject;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.CliCommandException;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.cli.api.IConvertLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;

public class ConvertLanguageProjectCommand
extends BaseCliCommand {
    private final IConvertLanguageProjectApi convertLanguageProjectApi;
    private final IImportLanguageProjectApi importLanguageProjectApi;

    @Inject
    public ConvertLanguageProjectCommand(IConvertLanguageProjectApi convertLanguageProjectApi, IImportLanguageProjectApi importLanguageProjectApi) {
        this.convertLanguageProjectApi = convertLanguageProjectApi;
        this.importLanguageProjectApi = importLanguageProjectApi;
    }

    @CliCommand(command="convert-language-project", value="ConvertLanguageProjectCommand_Description")
    public IStatus convertLanguageProject(@Argument(value={"--project"}, descriptor="ConvertLanguageProjectCommand_Param_Project_location_description") java.nio.file.Path projectLocation, @Argument(value={"--language-project"}, descriptor="ConvertLanguageProjectCommand_Param_source_language_project_location_description") java.nio.file.Path sourceProjectLocation, @Argument(value={"--target-language-project"}, descriptor="ConvertLanguageProjectCommand_Param_target_language_project_location_description") java.nio.file.Path targetProjectLocation) {
        IProject targetProject;
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(Messages.ConvertLanguageProjectCommand_Project__0, (Object)projectLocation);
            logger.debug(Messages.ConvertLanguageProjectCommand_Source_project__0, (Object)sourceProjectLocation);
            logger.debug(Messages.ConvertLanguageProjectCommand_Target_project__0, (Object)targetProjectLocation);
        }
        IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation).toAbsolutePath());
        java.nio.file.Path sourcePath = this.getCurrentWorkDir().resolve(sourceProjectLocation).toAbsolutePath();
        IProject sourceProject = this.importLanguageProjectApi.importLanguageProject(sourcePath);
        try {
            if (sourceProject != null && !Files.isSameFile(sourceProject.getLocation().toFile().toPath(), sourcePath)) {
                String message = MessageFormat.format(Messages.ConvertLanguageProjectCommand_Other_project_exists_in_workspace_with_the_same_name__0, sourceProject.getName());
                return CliPlugin.createErrorStatus(message, null);
            }
            if (sourceProject == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageProjectCommand_Language_project_cannot_be_created_or_imported__0, sourceProjectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
        }
        catch (IOException e) {
            throw new CliCommandException(Messages.ConvertLanguageProjectCommand_The_language_project_convert_failed, (Throwable)e);
        }
        java.nio.file.Path targetPath = this.getCurrentWorkDir().resolve(targetProjectLocation).toAbsolutePath();
        try {
            targetProject = this.importOrCreateProject(targetPath);
            if (targetProject != null && !Files.isSameFile(targetProject.getLocation().toFile().toPath(), targetPath)) {
                String message = MessageFormat.format(Messages.ConvertLanguageProjectCommand_Other_project_exists_in_workspace_with_the_same_name__0, targetProject.getName());
                return CliPlugin.createErrorStatus(message, null);
            }
            if (targetProject == null) {
                String message = MessageFormat.format(Messages.ConvertLanguageProjectCommand_Language_project_cannot_be_created_or_imported__0, targetProjectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
        }
        catch (IOException | CoreException e) {
            throw new CliCommandException(Messages.ConvertLanguageProjectCommand_The_language_project_convert_failed, e);
        }
        IProject project = dtProject.getWorkspaceProject();
        this.convertLanguageProjectApi.convertLanguageProject(project, sourceProject, targetProject);
        ConvertLanguageProjectCommand.waitConvertFinished();
        String message = MessageFormat.format(Messages.ConvertLanguageProjectCommand_The_language_project__0__have_been_successfully_converted, targetProject.getName());
        CliPlugin.logDebug(message);
        return Status.OK_STATUS;
    }

    private static void waitConvertFinished() {
        while (Job.getJobManager().find((Object)"Converter").length > 0) {
            try {
                Job.getJobManager().join((Object)"Converter", null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                // empty catch block
            }
        }
    }

    private void addBuilderIfNotExist(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 0, commands.length);
        nc[commands.length] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }

    private void addNature(IProject project, String natureId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] prevNatures = desc.getNatureIds();
        boolean isExist = Arrays.stream(prevNatures).anyMatch(natureId::equals);
        if (isExist) {
            return;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        desc.setNatureIds(newNatures);
        project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    private IProject importOrCreateProject(java.nio.file.Path projectDir) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = projectDir.getFileName().toString();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return project;
        }
        Collection projects = this.importLanguageProjectApi.findProjectsRecursively(List.of(projectDir));
        this.getContext().getLogger().debug("Projects found: {}", (Object)projects);
        if (!projects.isEmpty()) {
            java.nio.file.Path projectFolder = ((File)projects.iterator().next()).getParentFile().toPath();
            return this.importLanguageProjectApi.importLanguageProject(projectFolder);
        }
        this.getContext().getLogger().info("Creating project: {}", (Object)projectName);
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocation((IPath)new Path(projectDir.toString()));
        workspace.run(monitor -> {
            project.create(description, monitor);
            project.open(monitor);
            project.setDefaultCharset(StandardCharsets.UTF_8.name(), monitor);
        }, (IProgressMonitor)new NullProgressMonitor());
        try {
            this.addNature(project, "com.e1c.langtool.v8.dt.resourcestorage.dependentProjectNature");
            this.addBuilderIfNotExist(project, "com.e1c.langtool.v8.dt.resourcestorage.dependentTranslationBuilder");
            this.addBuilderIfNotExist(project, "com.e1c.langtool.v8.dt.resourcestorage.dependentSynchronizationBuilder");
        }
        catch (CoreException e) {
            this.getContext().getLogger().error(e.getMessage(), (Throwable)e);
        }
        return project;
    }
}

