/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.cli.api.IWorkspaceSupport;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.cli.api.IExportTranslationStatisticsApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class ExportTranslationStatisticsCommand
extends BaseCliCommand {
    private final IExportTranslationStatisticsApi exportTranslationStatisticsApi;
    private final IWorkspaceSupport workspaceSupport;

    @Inject
    public ExportTranslationStatisticsCommand(IExportTranslationStatisticsApi exportTranslationStatisticsApi, IWorkspaceSupport workspaceSupport) {
        this.exportTranslationStatisticsApi = exportTranslationStatisticsApi;
        this.workspaceSupport = workspaceSupport;
    }

    @CliCommand(command="export-translation-statistic", value="ExportTranslationStatisticsCommand_Description")
    public IStatus c1_exportTranslationStatistics(@Argument(value={"--project"}, descriptor="ExportTranslationStatisticsCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--statistics-location"}, descriptor="ExportTranslationStatisticsCommand_Param_statistic_location_description") Path statisticLocation) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project: {}", (Object)projectLocation);
            logger.debug("Statistic: {}", (Object)statisticLocation);
        }
        try {
            IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation).toAbsolutePath());
            IProject project = dtProject.getWorkspaceProject();
            if (logger.isDebugEnabled()) {
                logger.debug("Waiting for project {} build...", (Object)project.getName());
            }
            this.workspaceSupport.waitForBuildCompletion(project);
            ExportTranslationStatisticsCommand.createDirectoriesIfNotExists(statisticLocation.getParent());
            this.exportTranslationStatisticsApi.exportTranslationStatistics(project, statisticLocation);
            System.out.println("Translation statistic have been successfully exported.");
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException | IOException | CoreException e) {
            logger.error(Messages.ExportTranslationStatisticsCommand_Export_operation_failed, e);
            return CliPlugin.createErrorStatus(Messages.ExportTranslationStatisticsCommand_Export_operation_failed, e);
        }
    }

    @CliCommand(command="export-translation-statistic", value="ExportTranslationStatisticsCommand_Description")
    public IStatus c2_exportTranslationStatistics(@Argument(value={"--project-name"}, descriptor="ExportTranslationStatisticsCommand_Param_project_description") IProject project, @Argument(value={"--statistics-location"}, descriptor="ExportTranslationStatisticsCommand_Param_statistic_location_description") Path statisticLocation) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project: {}", (Object)project);
            logger.debug("Statistic: {}", (Object)statisticLocation);
        }
        try {
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            this.workspaceSupport.waitForBuildCompletion(project);
            ExportTranslationStatisticsCommand.createDirectoriesIfNotExists(statisticLocation.getParent());
            this.exportTranslationStatisticsApi.exportTranslationStatistics(project, statisticLocation);
            System.out.println("Translation statistic have been successfully exported.");
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException | IOException | CoreException e) {
            logger.error(Messages.ExportTranslationStatisticsCommand_Export_operation_failed, e);
            return CliPlugin.createErrorStatus(Messages.ExportTranslationStatisticsCommand_Export_operation_failed, e);
        }
    }

    private static Path createDirectoriesIfNotExists(Path directoryPath) throws IOException {
        if (directoryPath != null && !Files.exists(directoryPath, new LinkOption[0])) {
            return Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        return directoryPath;
    }
}

