/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.platform.IDtProject;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.cli.api.IGenerateTranslationStringsApi;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class GenerateTranslationStringsCommand
extends BaseCliCommand {
    private static final Path DEFAULT_EMPTY_PATH = Path.of("", new String[0]);
    private final IGenerateTranslationStringsApi generateTranslationStringsApi;
    private final IImportLanguageProjectApi importLanguageProjectApi;

    @Inject
    public GenerateTranslationStringsCommand(IGenerateTranslationStringsApi generateTranslationStringsApi, IImportLanguageProjectApi importLanguageProjectApi) {
        this.generateTranslationStringsApi = generateTranslationStringsApi;
        this.importLanguageProjectApi = importLanguageProjectApi;
    }

    @CliCommand(command="generate-strings", value="GenerateTranslationStringsCommand_Description")
    public IStatus c1_generateStrings(@Argument(value={"--project"}, descriptor="GenerateTranslationStringsCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--language-project-list"}, defaultValue="", elementType=Path.class, descriptor="GenerateTranslationStringsCommand_Param_language_project_location_description") Path[] languageProjects, @Argument(value={"--languages"}, elementType=String.class, descriptor="GenerateTranslationStringsCommand_Param_languages_description") String[] languages, @Argument(value={"--storage"}, defaultValue="edit:default", descriptor="GenerateTranslationStringsCommand_Param_storage_description") String storageId, @Argument(value={"--fillup"}, defaultValue="DontFillUp", descriptor="GenerateTranslationStringsCommand_Param_fillup_description") String fillUpStrategy, @Argument(value={"--file-list"}, defaultValue="", descriptor="GenerateTranslationStringsCommand_Param_file_list_description") Path fileListPath, @Argument(value={"--collect-model"}, defaultValue="true", descriptor="GenerateTranslationStringsCommand_Param_collect_model_description") boolean collectModel, @Argument(value={"--collect-interface"}, defaultValue="true", descriptor="GenerateTranslationStringsCommand_Param_collect_interface_description") boolean collectInterface, @Argument(value={"--collect-computed"}, defaultValue="none", descriptor="GenerateTranslationStringsCommand_Param_collect_computed_description") String collectModelType, @Argument(value={"--check-translations-in-any-available-storage"}, defaultValue="", descriptor="GenerateTranslationStringsCommand_Param_check_in_any_available_description") boolean checkTranslationsInAnyAvailableStorage, @Argument(value={"--filter"}, defaultValue="", elementType=String.class, descriptor="GenerateTranslationStringsCommand_Param_filter_description") String[] filter) {
        try {
            List<Object> languageProjectsList;
            Map<String, String> filterParameters = this.getFilterParameters(filter);
            List<Object> list = languageProjectsList = languageProjects == null ? Collections.emptyList() : Arrays.asList(languageProjects);
            if (languageProjectsList.size() == 1 && (languageProjectsList.get(0) == null || DEFAULT_EMPTY_PATH.equals(languageProjectsList.get(0)))) {
                languageProjectsList = Collections.emptyList();
            }
            List<String> languageList = Arrays.asList(languages);
            Logger logger = this.getContext().getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("Language projects: {}", languageProjectsList);
                logger.debug("Languages: {}", languageList);
                logger.debug("Project location: {}", (Object)projectLocation);
                logger.debug("Storage ID: {}", (Object)storageId);
                logger.debug("Fill-up strategy: {}", (Object)fillUpStrategy);
                logger.debug("Path to file-list: {}", (Object)fileListPath);
                logger.debug("Collect interface features: {}", (Object)collectInterface);
                logger.debug("Collect model features: {}", (Object)collectModel);
                logger.debug("Collect model computed features: {}", (Object)collectModelType);
                logger.debug("Check translations in any available storage: {}", (Object)checkTranslationsInAnyAvailableStorage);
                logger.debug("Filter parameters: {}", filterParameters);
            }
            this.importLanguageProjectApi.importLanguageProjects(languageProjectsList);
            IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation));
            this.generateTranslationStringsApi.generateTranslationStrings(dtProject, languageList, storageId, fillUpStrategy, fileListPath, collectModel, collectInterface, collectModelType, checkTranslationsInAnyAvailableStorage, filterParameters);
            System.out.println(Messages.GenerateTranslationStringsCommand_Translation_strings_are_successfully_generated);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.GenerateTranslationStringsCommand_Translation_strings_generation_operation_failed, e);
        }
    }

    @CliCommand(command="generate-strings", value="GenerateTranslationStringsCommand_Description")
    public IStatus c2_generateStrings(@Argument(value={"--project-name"}, descriptor="GenerateTranslationStringsCommand_Param_project_name_description") IProject project, @Argument(value={"--languages"}, elementType=String.class, descriptor="GenerateTranslationStringsCommand_Param_languages_description") String[] languages, @Argument(value={"--storage"}, defaultValue="edit:default", descriptor="GenerateTranslationStringsCommand_Param_storage_description") String storageId, @Argument(value={"--fillup"}, defaultValue="DontFillUp", descriptor="GenerateTranslationStringsCommand_Param_fillup_description") String fillUpStrategy, @Argument(value={"--file-list"}, defaultValue="", descriptor="GenerateTranslationStringsCommand_Param_file_list_description") Path fileListPath, @Argument(value={"--collect-model"}, defaultValue="true", descriptor="GenerateTranslationStringsCommand_Param_collect_model_description") boolean collectModel, @Argument(value={"--collect-interface"}, defaultValue="true", descriptor="GenerateTranslationStringsCommand_Param_collect_interface_description") boolean collectInterface, @Argument(value={"--collect-computed"}, defaultValue="none", descriptor="GenerateTranslationStringsCommand_Param_collect_computed_description") String collectModelType, @Argument(value={"--check-translations-in-any-available-storage"}, defaultValue="", descriptor="GenerateTranslationStringsCommand_Param_check_in_any_available_description") boolean checkTranslationsInAnyAvailableStorage, @Argument(value={"--filter"}, defaultValue="", elementType=String.class, descriptor="GenerateTranslationStringsCommand_Param_filter_description") String[] filter) {
        try {
            Map<String, String> filterParameters = this.getFilterParameters(filter);
            List<String> languageList = Arrays.asList(languages);
            Logger logger = this.getContext().getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("Languages: {}", languageList);
                logger.debug("Existing project: {}", (Object)project);
                logger.debug("Storage ID: {}", (Object)storageId);
                logger.debug("Fill-up strategy: {}", (Object)fillUpStrategy);
                logger.debug("Path to file-list: {}", (Object)fileListPath);
                logger.debug("Collect interface features: {}", (Object)collectInterface);
                logger.debug("Collect model features: {}", (Object)collectModel);
                logger.debug("Collect model computed features: {}", (Object)collectModelType);
                logger.debug("Check translations in any available storage: {}", (Object)checkTranslationsInAnyAvailableStorage);
                logger.debug("Filter parameters: {}", filterParameters);
            }
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            IDtProject dtProject = this.getContext().getDtProjectManager().getDtProject(project);
            this.generateTranslationStringsApi.generateTranslationStrings(dtProject, languageList, storageId, fillUpStrategy, fileListPath, collectModel, collectInterface, collectModelType, checkTranslationsInAnyAvailableStorage, filterParameters);
            System.out.println(Messages.GenerateTranslationStringsCommand_Translation_strings_are_successfully_generated);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.GenerateTranslationStringsCommand_Translation_strings_generation_operation_failed, e);
        }
    }

    private Map<String, String> getFilterParameters(String[] filter) {
        if (filter == null || filter.length == 1 && StringUtils.isNullOrEmpty((String)filter[0])) {
            return Map.of();
        }
        HashMap<String, String> builder = new HashMap<String, String>();
        int i = 0;
        while (i < filter.length) {
            String key = filter[i];
            if (i + 1 >= filter.length) {
                String message = MessageFormat.format(Messages.GenerateTranslationStringsCommand_Filter_parameter_key__0__has_no_value_string, key);
                throw new RuntimeException(message);
            }
            String value = filter[++i];
            builder.put(key, value);
            ++i;
        }
        return Map.copyOf(builder);
    }
}

