/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.platform.IDtProject;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.IProjectInformationApi;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class ListStoragesCommand
extends BaseCliCommand {
    private final IProjectInformationApi projectInformationApi;
    private final IImportLanguageProjectApi importLanguageProjectApi;

    @Inject
    public ListStoragesCommand(IProjectInformationApi projectInformationApi, IImportLanguageProjectApi importLanguageProjectApi) {
        this.projectInformationApi = projectInformationApi;
        this.importLanguageProjectApi = importLanguageProjectApi;
    }

    @CliCommand(command="list-storages", value="ListStoragesCommand_Description")
    public IStatus c1_listStorages(@Argument(value={"--project"}, descriptor="ListStoragesCommand_Param_project_location_description") Path projectLocation) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project location: {}", (Object)projectLocation);
        }
        IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation));
        List availableStorages = this.projectInformationApi.getProjectStorages(dtProject);
        this.printResult(availableStorages);
        return Status.OK_STATUS;
    }

    @CliCommand(command="list-storages", value="ListStoragesCommand_Description")
    public IStatus c2_listStorages(@Argument(value={"--project"}, descriptor="ListStoragesCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--language-project-list"}, descriptor="ListStoragesCommand_Param_language_project_locations_description", elementType=Path.class) Path[] languageProjects) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Language projects: {}", (Object[])languageProjects);
            logger.debug("Project location: {}", (Object)projectLocation);
        }
        this.importLanguageProjectApi.importLanguageProjects(Arrays.asList(languageProjects));
        IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation));
        List availableStorages = this.projectInformationApi.getProjectStorages(dtProject);
        this.printResult(availableStorages);
        return Status.OK_STATUS;
    }

    @CliCommand(command="list-storages", value="ListStoragesCommand_Description")
    public IStatus c3_listStorages(@Argument(value={"--project-name"}, descriptor="ListStoragesCommand_Param_project_name_description") IProject project) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Existing project: {}", (Object)project);
        }
        this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
        IDtProject dtProject = this.getContext().getDtProjectManager().getDtProject(project);
        List availableStorages = this.projectInformationApi.getProjectStorages(dtProject);
        this.printResult(availableStorages);
        return Status.OK_STATUS;
    }

    private void printResult(List<String> result) {
        if (result.isEmpty()) {
            System.out.println(Messages.ListStoragesCommand_List_of_storage_ids_available_for_project_is_empty);
        } else {
            String info = MessageFormat.format(Messages.ListStoragesCommand_List_of_storage_ids_available_for_project__0, result.stream().collect(Collectors.joining(System.lineSeparator())));
            System.out.println(info);
        }
    }
}

