/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.cli.api.IProjectInformationApi;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListTranslationProvidersCommand
extends BaseCliCommand {
    private final IProjectInformationApi projectInformationApi;

    @Inject
    public ListTranslationProvidersCommand(IProjectInformationApi projectInformationApi) {
        this.projectInformationApi = projectInformationApi;
    }

    @CliCommand(command="list-translation-providers", value="ListTranslationProvidersCommand_Description")
    public IStatus execute() {
        List availableTranslationProviders = this.projectInformationApi.getTranslationProvidersIds();
        if (availableTranslationProviders.isEmpty()) {
            System.out.println(Messages.ListTranslationProvidersCommand_List_of_translation_provider_is_empty);
            return Status.CANCEL_STATUS;
        }
        String info = MessageFormat.format(Messages.ListTranslationProvidersCommand_List_of_translation_provider_ids__0, availableTranslationProviders.stream().collect(Collectors.joining(System.lineSeparator())));
        System.out.println(info);
        return Status.OK_STATUS;
    }
}

