/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.rights;

import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.rights.model.ObjectRight;
import com._1c.g5.v8.dt.rights.model.ObjectRights;
import com._1c.g5.v8.dt.rights.model.RestrictionTemplate;
import com._1c.g5.v8.dt.rights.model.RightsPackage;
import com._1c.g5.v8.dt.rights.model.Rls;
import com._1c.g5.v8.dt.rights.model.RoleDescription;
import com.e1c.langtool.IBasicProcessor;
import com.e1c.langtool.v8.dt.DerivedDataUtils;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class RightsProcessor
implements IBasicProcessor {
    private static final List<String> DD_SEGMENTS = ImmutableList.of((Object)"RIGHTS");
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    @Inject
    private IDerivedDataManagerProvider derivedDataManagerProvider;
    private boolean processChildObjects = true;
    @Inject
    private IResourceLookup resourceLookup;
    private boolean waitDerivedDataComputation = true;
    protected IProgressMonitor monitor;
    protected final EObject object;

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(RightsPackage.eINSTANCE);
    }

    public RightsProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (this.isWaitDerivedDataComputation()) {
            DerivedDataUtils.DerivedDataAttr attr = new DerivedDataUtils.DerivedDataAttr(this.object, 0x6DDD00L, DD_SEGMENTS);
            DerivedDataUtils.waitComputation((IDerivedDataManagerProvider)this.derivedDataManagerProvider, (IResourceLookup)this.resourceLookup, (DerivedDataUtils.IDerivedDataAttr)attr);
        }
        if (RightsProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof RoleDescription) {
            this.doProcessInternal((RoleDescription)obj);
        } else if (obj instanceof ObjectRights) {
            this.doProcessInternal((ObjectRights)obj);
        } else if (obj instanceof RestrictionTemplate) {
            this.doProcessInternal((RestrictionTemplate)obj);
        } else if (obj instanceof ObjectRight) {
            this.doProcessInternal((ObjectRight)obj);
        } else if (obj instanceof Rls) {
            this.doProcessInternal((Rls)obj);
        }
    }

    private void doProcessInternal(ObjectRight obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ObjectRight.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getRestrictionsByCondition());
    }

    private void doProcessInternal(ObjectRights obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ObjectRights.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getRights());
    }

    private void doProcessInternal(RestrictionTemplate obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, RestrictionTemplate.class);
    }

    private void doProcessInternal(Rls obj) {
        this.doProcess(obj, Rls.class);
    }

    private void doProcessInternal(RoleDescription obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, RoleDescription.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getRights());
        this.doProcessInternal((Collection<? extends EObject>)obj.getTemplates());
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    protected boolean isWaitDerivedDataComputation() {
        return this.waitDerivedDataComputation;
    }

    protected void setWaitDerivedDataComputation(boolean waitDerivedDataComputation) {
        this.waitDerivedDataComputation = waitDerivedDataComputation;
    }
}

