/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.rights.naming;

import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldDef;
import com._1c.g5.v8.dt.rights.model.ObjectRight;
import com._1c.g5.v8.dt.rights.model.ObjectRights;
import com._1c.g5.v8.dt.rights.model.RestrictionTemplate;
import com._1c.g5.v8.dt.rights.model.Right;
import com._1c.g5.v8.dt.rights.model.RightsPackage;
import com._1c.g5.v8.dt.rights.model.Rls;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.rights.RightsPlugin;
import com.e1c.langtool.v8.dt.naming.AbstractFeatureKeyComputer;
import com.e1c.langtool.v8.dt.right.ql.translator.TemplateUtil;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class RightsFeatureKeyComputer
extends AbstractFeatureKeyComputer {
    @Inject
    private IQualifiedNameProvider fqnProvider;

    public static RightsFeatureKeyComputer create() {
        RightsFeatureKeyComputer provider = new RightsFeatureKeyComputer();
        RightsPlugin.getDefault().getInjector().injectMembers((Object)provider);
        return provider;
    }

    public boolean isSupported(EObject object) {
        EPackage objectPackage = object.eClass().getEPackage();
        return objectPackage.equals(RightsPackage.eINSTANCE);
    }

    public FeatureKey computeFqn(EObject obj) {
        if (obj instanceof RestrictionTemplate) {
            return this._computeFqn((RestrictionTemplate)obj);
        }
        if (obj instanceof ObjectRights) {
            return this._computeFqn((ObjectRights)obj);
        }
        if (obj instanceof Rls) {
            return this._computeFqn((Rls)obj);
        }
        RightsPlugin.log(RightsPlugin.createWarningStatus(MessageFormat.format("Rights: Unhandled Feature Key parameter type: {0}", obj)));
        return this.computeListOrParent(obj);
    }

    protected FeatureKey _computeFqn(RestrictionTemplate obj) {
        FeatureKey _xifexpression = null;
        String _name = obj.getName();
        if (!StringUtils.isNullOrEmpty((String)_name)) {
            Pair extractedName = TemplateUtil.getName((String)_name);
            if (!_name.equals(extractedName.getKey())) {
                _name = (String)extractedName.getKey();
            }
            _xifexpression = this.toFeatureKey("Template");
            _xifexpression = _xifexpression.append(this.toFeatureKey(_name));
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(ObjectRights obj) {
        QualifiedName objectFqn;
        FeatureKey _xifexpression = null;
        EObject _object = obj.getObject();
        if (_object != null && (objectFqn = this.fqnProvider.getFullyQualifiedName(_object)) != null) {
            _xifexpression = SegmentFeatureKey.create((List)objectFqn.getSegments());
        }
        if (_xifexpression == null) {
            _xifexpression = this.toFeatureKey("Unknown");
        }
        return _xifexpression;
    }

    protected FeatureKey _computeFqn(Rls obj) {
        String _rightName;
        Right right;
        ObjectRight objectRight;
        FeatureKey _xifexpression = null;
        String condion = obj.getCondition();
        if (!(StringUtils.isNullOrEmpty((String)condion) || Objects.equal((Object)(objectRight = (ObjectRight)EcoreUtil2.getContainerOfType((EObject)obj, ObjectRight.class)), null) || (right = objectRight.getRight()) == null || StringUtils.isNullOrEmpty((String)(_rightName = right.getName())))) {
            ObjectRights _containerOfType2 = (ObjectRights)EcoreUtil2.getContainerOfType((EObject)obj, ObjectRights.class);
            _xifexpression = this._computeFqn(_containerOfType2);
            _xifexpression = _xifexpression.append(this.toFeatureKey(_rightName));
            _xifexpression = _xifexpression.append(this.toFeatureKey("Rls"));
            if (obj.getFields().isEmpty()) {
                _xifexpression = _xifexpression.append(this.toFeatureKey("<OtherFields>"));
            } else {
                String fieldsNames = "";
                for (DbViewFieldDef field : obj.getFields()) {
                    if (field.getName() == null) continue;
                    if (!StringUtils.isNullOrEmpty((String)fieldsNames)) {
                        fieldsNames = fieldsNames.concat(",");
                    }
                    fieldsNames = fieldsNames.concat(field.getName());
                }
                _xifexpression = _xifexpression.append(this.toFeatureKey(fieldsNames));
            }
        }
        return _xifexpression;
    }
}

