/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslMultiLineCommentDocumentationProvider;
import com._1c.g5.v8.dt.bsl.model.Block;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.ExplicitVariable;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.ForToStatement;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.Label;
import com._1c.g5.v8.dt.bsl.model.Literal;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.Pragma;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.scoping.BslCachedScopeProvider;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.typesystem.util.TypeSystemUtil;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com.e1c.g5.dt.core.api.naming.INamingService;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.ModelValueProviderExtension;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.ModuleProcessor;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentCollector;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralCollector;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralFeatureValueCollector;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralRegistry;
import com.e1c.langtool.v8.dt.bsl.translator.BslDocCommentParser;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.settings.DtFeatureSettings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class BslFeaturesCollector
extends ModuleProcessor
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private BslMultiLineCommentDocumentationProvider commentProvider;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IStringLiteralTypeComputer stringLiteralTypeComputer;
    @Inject
    private TypedStringLiteralRegistry typedStringLiteralRegistry;
    @Inject
    private DefaultStringLiteralCollector defaultStringLiteralCollector;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private INamingService namingService;
    @Inject
    private IBmModelManager bmModelManager;
    @Inject
    private BslDocCommentParser bslDocCommentParser;
    @Inject
    private TypesComputer computerTypes;
    private final ICollectingParameters parameters;
    private final BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private CollectingContext context;
    private IFile resourceFile;
    private Boolean oldCommentFormat;
    private final Set<Integer> processedNode = new ConcurrentSkipListSet<Integer>();
    private BmOperationContext bmOperationContext;
    private final Map<Variable, Block> blockVariables = new HashMap<Variable, Block>();

    public static BslFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        BslFeaturesCollector collector = new BslFeaturesCollector(object, parameters, addAction);
        BslPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public BslFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        this.setDeepAnalysis(parameters.isCollectModelStrings());
        this.setWaitDerivedDataComputation(parameters.isCollectModelStrings());
        this.addAction = addAction;
    }

    @Override
    public void process(IProgressMonitor monitor) {
        IProject project = this.resourceLookup.getProject(this.rootObject);
        this.bmModelManager.executeReadOnlyTask(project, transaction -> {
            IFile file;
            this.bmOperationContext = new BmOperationContext(this.namingService, this.bmModelManager, transaction);
            super.process(monitor);
            if (this.rootObject instanceof Module) {
                IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
                BslCachedScopeProvider cache = (BslCachedScopeProvider)resourceServiceProvider.get(BslCachedScopeProvider.class);
                cache.clearScopes((Module)this.rootObject);
            }
            if ((file = this.getResourceFile()) != null) {
                try {
                    file.deleteMarkers(null, true, 2);
                }
                catch (CoreException e) {
                    BslPlugin.log(BslPlugin.createErrorStatus("Error while removing BSL markers.", e));
                }
            }
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        StringLiteral lines;
        List comments;
        if (object == null) {
            return;
        }
        if (!this.isSupported(object)) {
            return;
        }
        this.collectFeatureValue(object);
        T t = object;
        if (t instanceof StringLiteral) {
            void literal;
            StringLiteral stringLiteral = (StringLiteral)t;
            StringLiteral cfr_ignored_0 = (StringLiteral)t;
            this.doProcess((StringLiteral)literal);
        } else if (object instanceof Method && this.parameters.isCollectModelStrings() && !(comments = this.commentProvider.getDocumentationNodes(object)).isEmpty()) {
            lines = comments.stream().map(node -> node.getText().trim()).collect(Collectors.toList());
            if (BslCommentUtils.isDeprecated((Method)((Method)object))) {
                this.skipDeprecatedWord((List<String>)lines);
            }
            BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((List)lines, (Method)((Method)object), (boolean)this.isOldCommentFormat());
            FeatureKey featureKeyPreffix = this.featureKeyProvider.getKey(object);
            DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKeyPreffix, comment, this.parameters, this.addAction, object, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
        T t2 = object;
        if (t2 instanceof FormalParam) {
            void formalParam;
            comments = (FormalParam)t2;
            FormalParam cfr_ignored_1 = (FormalParam)t2;
            Literal literal = formalParam.getDefaultValue();
            if (literal instanceof StringLiteral) {
                void literal2;
                lines = (StringLiteral)literal;
                StringLiteral cfr_ignored_2 = (StringLiteral)literal;
                this.doProcess((StringLiteral)literal2);
            }
        }
        this.collectComments(object);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends EObject> void collectComments(T object) {
        if (this.needCollectComments(object) && this.parameters.isCollectModelStrings()) {
            T t = object;
            if (t instanceof Module) {
                void module;
                Module module2 = (Module)t;
                Module cfr_ignored_0 = (Module)t;
                this.collectComments((Module)module);
            } else {
                T t2 = object;
                if (t2 instanceof Method) {
                    void method;
                    Method method2 = (Method)t2;
                    Method cfr_ignored_1 = (Method)t2;
                    this.collectComments((Method)method);
                } else {
                    T t3 = object;
                    if (t3 instanceof RegionPreprocessor) {
                        void preprocessor;
                        RegionPreprocessor regionPreprocessor = (RegionPreprocessor)t3;
                        RegionPreprocessor cfr_ignored_2 = (RegionPreprocessor)t3;
                        this.collectComments((RegionPreprocessor)preprocessor);
                    } else {
                        T t4 = object;
                        if (t4 instanceof SimpleStatement) {
                            void statement;
                            SimpleStatement simpleStatement = (SimpleStatement)t4;
                            SimpleStatement cfr_ignored_3 = (SimpleStatement)t4;
                            this.collectComments((SimpleStatement)statement);
                        } else {
                            T t5 = object;
                            if (t5 instanceof ExplicitVariable) {
                                void explicitVariable;
                                ExplicitVariable explicitVariable2 = (ExplicitVariable)t5;
                                ExplicitVariable cfr_ignored_4 = (ExplicitVariable)t5;
                                this.collectComments((ExplicitVariable)explicitVariable);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends EObject> void collectFeatureValue(T object) {
        boolean unknownMethod = false;
        T t = object;
        if (t instanceof DynamicFeatureAccess) {
            void feature;
            DynamicFeatureAccess dynamicFeatureAccess = (DynamicFeatureAccess)t;
            DynamicFeatureAccess cfr_ignored_0 = (DynamicFeatureAccess)t;
            unknownMethod = this.isUnknownMethod((DynamicFeatureAccess)feature, this.getContext());
        }
        boolean unknownField = false;
        T t2 = object;
        if (t2 instanceof DynamicFeatureAccess) {
            void feature;
            DynamicFeatureAccess dynamicFeatureAccess = (DynamicFeatureAccess)t2;
            DynamicFeatureAccess cfr_ignored_1 = (DynamicFeatureAccess)t2;
            unknownField = this.isUnknownField((DynamicFeatureAccess)feature, this.getContext());
        }
        if (unknownMethod || unknownField) {
            this.collectUnknown((DynamicFeatureAccess)object);
        } else {
            FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)this.getMonitor());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectUnknown(DynamicFeatureAccess object) {
        List<EFeatureSettings> settings = this.getFeatureSettings(object);
        IFile file = this.getContext().getResourceFile();
        for (EFeatureSettings featureSettings : settings) {
            boolean isComputedValue;
            boolean hasValue;
            Map nls = FeaturesCollectorUtil.getLocalStrings((EObject)object, (EFeatureSettings)featureSettings, (String)this.getContext().getDefaultLanguageCode());
            String value = featureSettings.isModel() && featureSettings instanceof ModelValueProviderExtension ? ((ModelValueProviderExtension)featureSettings).getValue((Object)object) : (String)nls.get(this.getContext().getDefaultLanguageCode());
            nls.remove(this.getContext().getDefaultLanguageCode());
            boolean bl = hasValue = !StringUtils.isBlank((String)value) || !nls.isEmpty();
            if (!this.getContext().getParameters().isCollectEmptyValue() && !hasValue || !TranslationUtils.isValidValueForCollectModelType((boolean)(isComputedValue = false), (boolean)true, (boolean)false, (ICollectingParameters.CollectModelType)this.getContext().getParameters().getCollectModelType())) continue;
            EFeatureSettings currentSettings = featureSettings;
            EFeatureSettings eFeatureSettings = featureSettings;
            if (eFeatureSettings instanceof DtFeatureSettings) {
                void dtFeatureSettings;
                DtFeatureSettings cfr_ignored_0 = (DtFeatureSettings)eFeatureSettings;
                DtFeatureSettings cfr_ignored_1 = (DtFeatureSettings)eFeatureSettings;
                if (dtFeatureSettings.getCamelCaseByContent() instanceof EFeatureSettings && StringUtils.isCamelCase((String)value)) {
                    currentSettings = (EFeatureSettings)((DtFeatureSettings)featureSettings).getCamelCaseByContent();
                }
            }
            FeatureKey featureKey = this.getContext().getFeatureKeyProvider().getFeatureKey((EObject)object, (FeatureSettings)featureSettings);
            PersistableFeatureValue featureValue = new PersistableFeatureValue(file, featureKey, (FeatureSettings)currentSettings, value, isComputedValue, true, false);
            nls.put(this.getContext().getDefaultLanguageCode(), value);
            FeaturesCollectorUtil.fillLocalStrings((Map)featureValue.getLocalStrings(), (Map)nls, (Collection)this.getContext().getParameters().getLanguages());
            this.getContext().getAddAction().accept(object, featureValue);
        }
    }

    private List<EFeatureSettings> getFeatureSettings(DynamicFeatureAccess object) {
        List settings = Lists.newArrayList();
        if (this.getContext().getParameters().isCollectModelStrings() && this.getContext().getParameters().isCollectInterfaceStrings()) {
            settings = this.getContext().getSettingsService().allSettingsByObject((EObject)object);
        } else if (this.getContext().getParameters().isCollectModelStrings()) {
            settings = this.getContext().getSettingsService().getModelSettings((EObject)object);
        } else if (this.getContext().getParameters().isCollectInterfaceStrings()) {
            settings = this.getContext().getSettingsService().getInterfaceSettings((EObject)object);
        }
        return settings;
    }

    private void skipDeprecatedWord(List<String> lines) {
        int j = 0;
        while (j < lines.size()) {
            String text = lines.get(j).trim();
            if (text.startsWith("//")) {
                int start = "//".length();
                if (!(text = BslUtils.getTextWithoutSplashes(text)).isEmpty()) {
                    String subStart = lines.get(j).substring(0, start);
                    if (text.toLowerCase().startsWith("Deprecated.".toLowerCase())) {
                        String line = subStart + text.substring(text.toLowerCase().indexOf("Deprecated.".toLowerCase()) + "Deprecated.".length());
                        lines.set(j, line);
                        break;
                    }
                    if (!text.toLowerCase().startsWith("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".toLowerCase())) break;
                    String line = subStart + text.substring(text.toLowerCase().indexOf("\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".toLowerCase()) + "\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430.".length());
                    lines.set(j, line);
                    break;
                }
            }
            ++j;
        }
    }

    private boolean needCollectComments(EObject object) {
        return object instanceof Module || object instanceof Method || object instanceof Variable || object instanceof RegionPreprocessor || object instanceof SimpleStatement;
    }

    private void doProcess(StringLiteral literal) {
        Collection types;
        try {
            types = this.stringLiteralTypeComputer.computeTypes(literal);
        }
        catch (Exception e) {
            throw new CollectingException((Throwable)e);
        }
        Collection<TypedStringLiteralFeatureValueCollector> collectors = this.typedStringLiteralRegistry.getFeatureValueCollectors(literal, types);
        for (TypedStringLiteralFeatureValueCollector collector : collectors) {
            if (this.getMonitor().isCanceled()) {
                return;
            }
            collector.collect(literal, this.getContext(), this.getMonitor());
        }
        if (collectors.isEmpty() && this.defaultStringLiteralCollector.isSupport(literal, types)) {
            this.defaultStringLiteralCollector.collect(literal, this.getContext(), this.getMonitor());
        }
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(), this.addAction, this.getResourceFile());
        }
        return this.context;
    }

    private <T extends EObject> boolean isSupported(T object) {
        return this.parameters.isCollectInterfaceStrings() && object instanceof StringLiteral || this.parameters.isCollectModelStrings() && (object instanceof Module || object instanceof Method || object instanceof Variable || object instanceof RegionPreprocessor || object instanceof DynamicFeatureAccess || object instanceof Label || object instanceof StringLiteral || object instanceof SimpleStatement);
    }

    private String getDefaultLanguageCode() {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)this.rootObject, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor == null ? new NullProgressMonitor() : this.monitor;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            this.resourceFile = this.resourceLookup.getPlatformResource(this.rootObject);
        }
        return this.resourceFile;
    }

    private boolean isOldCommentFormat() {
        if (this.oldCommentFormat == null) {
            IProject project = this.resourceLookup.getProject(this.rootObject);
            this.oldCommentFormat = this.bslPreferences.getDocumentCommentProperties(project).oldCommentFormat();
        }
        return this.oldCommentFormat;
    }

    private void collectComments(Module object) {
        FeatureKey featureKeyPreffix = this.featureKeyProvider.getKey((EObject)object);
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        int skipBefore = node.getTotalOffset();
        if (node.hasChildren()) {
            ArrayList<INode> comments = new ArrayList<INode>();
            Iterator iterator = node.getLeafNodes().iterator();
            while (iterator.hasNext()) {
                if (this.getMonitor().isCanceled()) {
                    return;
                }
                ILeafNode child = (ILeafNode)iterator.next();
                if (child.isHidden()) {
                    if (BslCommentUtils.isCommentNode((ILeafNode)child)) {
                        comments.add((INode)child);
                        continue;
                    }
                    if (comments.isEmpty() || child.getText().indexOf(10) == -1) continue;
                    BslDocumentationComment bslDocumentationComment = this.bslDocCommentParser.parse(comments, this.isOldCommentFormat());
                    DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKeyPreffix, bslDocumentationComment, this.parameters, this.addAction, (EObject)object, this.bmOperationContext);
                    collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
                    skipBefore = child.getOffset();
                    break;
                }
                comments.clear();
                break;
            }
        }
        featureKeyPreffix = featureKeyPreffix.append("Comment");
        ArrayList allComments = new ArrayList();
        ArrayList<ILeafNode> found = new ArrayList<ILeafNode>();
        for (ILeafNode iLeafNode : node.getLeafNodes()) {
            if (iLeafNode.getOffset() < skipBefore) continue;
            if (iLeafNode.isHidden() && BslCommentUtils.isCommentNode((ILeafNode)iLeafNode)) {
                found.add(iLeafNode);
                continue;
            }
            if (!found.isEmpty() && iLeafNode.getText().indexOf(10) != -1) {
                allComments.add(found);
                found = new ArrayList();
                continue;
            }
            found = new ArrayList();
            if (iLeafNode.isHidden()) continue;
            EObject actualObject = NodeModelUtils.findActualSemanticObjectFor((INode)iLeafNode);
            if (actualObject instanceof Method || actualObject instanceof Variable) {
                ICompositeNode actualNode = NodeModelUtils.findActualNodeFor((EObject)actualObject);
                skipBefore = actualNode.getTotalEndOffset();
                this.processedNode.add(actualNode.getStartLine());
            }
            if (!(actualObject instanceof RegionPreprocessor)) continue;
            ICompositeNode nodeItem = NodeModelUtils.findActualNodeFor((EObject)((RegionPreprocessor)actualObject).getItemAfter());
            skipBefore = nodeItem != null ? nodeItem.getTotalOffset() : node.getTotalEndOffset();
        }
        if (!found.isEmpty()) {
            allComments.add(found);
        }
        for (List list : allComments) {
            if (list.isEmpty() || this.processedNode.containsAll(list.stream().map(INode::getStartLine).collect(Collectors.toList()))) continue;
            BslDocumentationComment comment = this.bslDocCommentParser.parse(list, this.isOldCommentFormat());
            FeatureKey featureKey = featureKeyPreffix.append(BslUtils.getFeatrueKeyPreffix(comment));
            DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKey, comment, this.parameters, this.addAction, (EObject)object, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
    }

    private void collectComments(ExplicitVariable object) {
        BslDocumentationComment comment;
        List<String> commentContent;
        EObject parent = this.getVariableParent((Variable)object);
        if (parent == null) {
            return;
        }
        Block block = (Block)EcoreUtil2.getContainerOfType((EObject)parent, Block.class);
        if (block == null) {
            return;
        }
        ICompositeNode blockNode = NodeModelUtils.findActualNodeFor((EObject)block);
        if (blockNode == null) {
            return;
        }
        FeatureKey featureKeyPreffix = this.featureKeyProvider.getKey((EObject)object);
        List comments = this.commentProvider.getDocumentationNodes(parent);
        if (!comments.isEmpty() && !this.processedNode.containsAll(comments.stream().map(INode::getStartLine).collect(Collectors.toList()))) {
            BslDocumentationComment comment2 = this.bslDocCommentParser.parse(comments, this.isOldCommentFormat());
            DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKeyPreffix, comment2, this.parameters, this.addAction, (EObject)object, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
        if ((commentContent = BslUtils.collectMultilineCommentAfterObject(parent, (INode)blockNode)).isEmpty()) {
            return;
        }
        if (this.bslDocCommentParser.isCommentStartsWithAtSymbol(commentContent, 1)) {
            this.bslDocCommentParser.removeReturnsStatement(commentContent);
        }
        if ((comment = BslCommentUtils.parseTemplateComment(commentContent, (boolean)this.isOldCommentFormat())) == null) {
            return;
        }
        if (this.bslDocCommentParser.isCommentHasIncorrectReturnTypes(comment, (EObject)object)) {
            this.bslDocCommentParser.restoreCommentDescription(comment, commentContent);
        }
        DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKeyPreffix, comment, this.parameters, this.addAction, (EObject)object, this.bmOperationContext);
        collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
    }

    private void collectComments(Method object) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            FeatureKey featureKeyPreffix = this.featureKeyProvider.getKey((EObject)object).append("Comment");
            ArrayList allComments = new ArrayList();
            ArrayList<ILeafNode> found = new ArrayList<ILeafNode>();
            int skipBefore = node.getOffset();
            int until = node.getEndOffset();
            for (ILeafNode iLeafNode : node.getLeafNodes()) {
                if (iLeafNode.getOffset() < skipBefore) continue;
                if (iLeafNode.getOffset() >= until) break;
                if (iLeafNode.isHidden() && BslCommentUtils.isCommentNode((ILeafNode)iLeafNode)) {
                    found.add(iLeafNode);
                    continue;
                }
                if (found.isEmpty() || iLeafNode.isHidden() && iLeafNode.getText().indexOf(10) == -1) continue;
                allComments.add(found);
                found = new ArrayList();
            }
            if (!found.isEmpty()) {
                allComments.add(found);
            }
            for (List list : allComments) {
                if (this.variableHasCommentContent(list)) continue;
                list.forEach(n -> {
                    boolean bl = this.processedNode.add(n.getStartLine());
                });
                BslDocumentationComment comment = this.bslDocCommentParser.parse(list, this.isOldCommentFormat());
                String keyPreffix = BslUtils.getFeatrueKeyPreffix(comment);
                FeatureKey featureKey = keyPreffix.isEmpty() ? featureKeyPreffix : featureKeyPreffix.append(keyPreffix);
                DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKey, comment, this.parameters, this.addAction, (EObject)object, this.bmOperationContext);
                collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
            }
        }
    }

    private boolean variableHasCommentContent(List<INode> comments) {
        ILeafNode leafNode = (ILeafNode)comments.get(0);
        Variable variable = BslUtils.getCommentNodeVariable(leafNode);
        String originalComment = comments.get(0).getText();
        if (!comments.isEmpty() && variable != null) {
            ICompositeNode blockNode;
            Block block;
            List<String> content = this.findVariableCommentContent(comments, variable);
            EObject parent = this.getVariableParent(variable);
            if (content != null && !content.isEmpty() && (block = (Block)EcoreUtil2.getContainerOfType((EObject)parent, Block.class)) != null && (blockNode = NodeModelUtils.findActualNodeFor((EObject)block)) != null) {
                List commentContent = TypeSystemUtil.getCommentAfterObject((EObject)parent.eContainer(), (INode)blockNode, (boolean)this.isOldCommentFormat());
                boolean sameComment = this.isSameComment(originalComment, commentContent);
                if (sameComment) {
                    return true;
                }
                this.processedNode.add(comments.get(0).getStartLine());
            }
        }
        return false;
    }

    private boolean isSameComment(String originalComment, List<String> commentContent) {
        boolean sameComment = false;
        String dashSymbol = "-";
        if (commentContent != null && commentContent.size() > 1) {
            String variableComment = commentContent.get(1);
            int dashIndex = variableComment.trim().lastIndexOf(dashSymbol);
            if (this.isOldCommentFormat() && variableComment.trim().endsWith(dashSymbol) && dashIndex != -1) {
                variableComment = variableComment.substring(0, dashIndex).trim();
            }
            sameComment = variableComment.equals(originalComment.trim());
        }
        return sameComment;
    }

    private void collectComments(SimpleStatement statement) {
        DocCommentCollector collector;
        FeatureKey featureKey;
        String keyPreffix;
        BslDocumentationComment comment;
        ImplicitVariable variable = this.getStatementVariable(statement);
        if (variable == null) {
            return;
        }
        EObject parent = this.getVariableParent((Variable)variable);
        Block block = (Block)EcoreUtil2.getContainerOfType((EObject)parent, Block.class);
        if (block == null) {
            return;
        }
        ICompositeNode blockNode = NodeModelUtils.findActualNodeFor((EObject)block);
        if (blockNode == null) {
            return;
        }
        List<String> commentContent = BslUtils.collectMultilineCommentAfterObject((EObject)statement, (INode)blockNode);
        if (commentContent.isEmpty()) {
            return;
        }
        List comments = this.commentProvider.getDocumentationNodes((EObject)statement);
        EObject owner = BslUtils.getOwnerDocNode(comments);
        if (!comments.isEmpty() && owner != null && !this.processedNode.containsAll(comments.stream().map(INode::getStartLine).toList())) {
            comment = this.bslDocCommentParser.parse(comments, this.isOldCommentFormat());
            keyPreffix = BslUtils.getFeatrueKeyPreffix(comment);
            featureKey = this.bslDocCommentParser.getVariableFeatureKey((EObject)statement, (EObject)variable, this.blockVariables, keyPreffix);
            collector = DocCommentCollector.create(this.getResourceFile(), featureKey, comment, this.parameters, this.addAction, (EObject)statement, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
        if ((commentContent = BslUtils.collectMultilineCommentAfterObject((EObject)statement, (INode)blockNode)).isEmpty()) {
            return;
        }
        if (this.bslDocCommentParser.isCommentStartsWithAtSymbol(commentContent, 1)) {
            this.bslDocCommentParser.removeReturnsStatement(commentContent);
        }
        if ((comment = BslCommentUtils.parseTemplateComment(commentContent, (boolean)this.isOldCommentFormat())) == null) {
            return;
        }
        if (this.bslDocCommentParser.isCommentHasIncorrectReturnTypes(comment, (EObject)statement)) {
            this.bslDocCommentParser.restoreCommentDescription(comment, commentContent);
        }
        keyPreffix = BslUtils.getFeatrueKeyPreffix(comment);
        featureKey = this.bslDocCommentParser.getVariableFeatureKey((EObject)statement, (EObject)variable, this.blockVariables, keyPreffix);
        collector = DocCommentCollector.create(this.getResourceFile(), featureKey, comment, this.parameters, this.addAction, (EObject)statement, this.bmOperationContext);
        collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitVariable getStatementVariable(SimpleStatement statement) {
        Expression source;
        Expression expression;
        DynamicFeatureAccess featureAccess;
        Invocation invocation;
        EObject parent;
        ImplicitVariable variable = null;
        Expression left = statement.getLeft();
        if (left instanceof Invocation && (parent = (invocation = (Invocation)left).eContainer()) instanceof SimpleStatement && (featureAccess = invocation.getMethodAccess()) instanceof DynamicFeatureAccess) {
            left = this.getStaticFeatureAccess(featureAccess);
        }
        if ((expression = (source = left)) instanceof DynamicFeatureAccess) {
            void dfa;
            featureAccess = (DynamicFeatureAccess)expression;
            DynamicFeatureAccess cfr_ignored_0 = (DynamicFeatureAccess)expression;
            source = this.getStaticFeatureAccess((DynamicFeatureAccess)dfa);
        }
        if (!(source instanceof StaticFeatureAccess)) {
            return variable;
        }
        StaticFeatureAccess feature = (StaticFeatureAccess)source;
        variable = feature.getImplicitVariable();
        if (variable == null) {
            variable = feature.getFeatureEntries().stream().filter(e -> e.getFeature() instanceof ImplicitVariable).map(f -> (ImplicitVariable)f.getFeature()).findFirst().orElse(null);
        }
        return variable;
    }

    private StaticFeatureAccess getStaticFeatureAccess(DynamicFeatureAccess dfa) {
        Expression source = dfa.getSource();
        if (source instanceof DynamicFeatureAccess) {
            return this.getStaticFeatureAccess((DynamicFeatureAccess)source);
        }
        if (source instanceof StaticFeatureAccess) {
            return (StaticFeatureAccess)source;
        }
        return null;
    }

    private EObject getVariableParent(Variable object) {
        Variable e = object;
        while (e != null) {
            if (e instanceof ForEachStatement || e instanceof DeclareStatement || e instanceof ForToStatement || e instanceof StaticFeatureAccess || e instanceof SimpleStatement) {
                return e;
            }
            if (e instanceof Method) {
                return null;
            }
            e = e.eContainer();
        }
        return null;
    }

    private void collectComments(RegionPreprocessor region) {
        if (EcoreUtil2.getContainerOfType((EObject)region, Method.class) != null) {
            return;
        }
        FeatureKey featureKeyPreffix = this.featureKeyProvider.getKey((EObject)region);
        this.processRegionPreprocessorDocumentationNodes(region, featureKeyPreffix);
        featureKeyPreffix = featureKeyPreffix.append("Comment");
        ICompositeNode fullRegionNode = NodeModelUtils.getNode((EObject)region);
        if (fullRegionNode != null) {
            int skipBefore = fullRegionNode.getOffset();
            ICompositeNode nodeItem = NodeModelUtils.findActualNodeFor((EObject)region.getItemAfter());
            int until = nodeItem != null ? nodeItem.getTotalOffset() : fullRegionNode.getTotalEndOffset();
            ArrayList<List<INode>> allComments = new ArrayList<List<INode>>();
            ArrayList<ILeafNode> found = new ArrayList<ILeafNode>();
            for (ILeafNode currentLeafNode : fullRegionNode.getLeafNodes()) {
                if (currentLeafNode.getOffset() < skipBefore) continue;
                if (currentLeafNode.getOffset() >= until) break;
                if (currentLeafNode.isHidden() && BslCommentUtils.isCommentNode((ILeafNode)currentLeafNode)) {
                    EObject parentSemantic = currentLeafNode.getParent().getSemanticElement();
                    Method method = (Method)EcoreUtil2.getContainerOfType((EObject)parentSemantic, Method.class);
                    if (parentSemantic instanceof Method || parentSemantic instanceof Pragma || method == null) {
                        found.add(currentLeafNode);
                        continue;
                    }
                    ICompositeNode methodNode = NodeModelUtils.findActualNodeFor((EObject)method);
                    skipBefore = methodNode.getEndOffset();
                    continue;
                }
                if (!(found.isEmpty() || currentLeafNode.isHidden() && currentLeafNode.getText().indexOf(10) == -1)) {
                    EObject child = currentLeafNode.getSemanticElement();
                    ICompositeNode childNode = NodeModelUtils.findActualNodeFor((EObject)child);
                    if (this.isMethodNext(currentLeafNode, child)) {
                        skipBefore = childNode.getEndOffset();
                    }
                    allComments.add(found);
                    found = new ArrayList();
                    continue;
                }
                if (!this.isChildPreprocessorNext(region, (INode)currentLeafNode)) continue;
                skipBefore = this.findChildPreprocessorEndOffset(currentLeafNode);
            }
            if (!found.isEmpty()) {
                allComments.add(found);
            }
            this.processCollectedRegionPreprocessorComments(region, featureKeyPreffix, allComments);
        }
    }

    private int findChildPreprocessorEndOffset(ILeafNode currentLeafNode) {
        EObject child = currentLeafNode.getSemanticElement();
        ICompositeNode childNode = NodeModelUtils.findActualNodeFor((EObject)child);
        int skipBefore = childNode.getEndOffset();
        INode next = currentLeafNode.getNextSibling();
        while (next != null) {
            if (next.getText().equalsIgnoreCase("#EndRegion") || next.getText().equalsIgnoreCase("#\u041a\u043e\u043d\u0435\u0446\u041e\u0431\u043b\u0430\u0441\u0442\u0438")) {
                skipBefore = next.getEndOffset();
                break;
            }
            next = next.getNextSibling();
        }
        return skipBefore;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isChildPreprocessorNext(RegionPreprocessor region, INode currentLeafNode) {
        EObject eObject;
        if (currentLeafNode.getGrammarElement() instanceof RuleCall && (eObject = currentLeafNode.getSemanticElement()) instanceof RegionPreprocessor) {
            void preprocessor;
            RegionPreprocessor regionPreprocessor = (RegionPreprocessor)eObject;
            RegionPreprocessor cfr_ignored_0 = (RegionPreprocessor)eObject;
            if (!preprocessor.equals(region)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethodNext(ILeafNode currentLeafNode, EObject child) {
        return child instanceof Method && (currentLeafNode.hasNextSibling() && currentLeafNode.getNextSibling().getGrammarElement() instanceof Keyword || currentLeafNode.getGrammarElement() instanceof Keyword);
    }

    private void processRegionPreprocessorDocumentationNodes(RegionPreprocessor region, FeatureKey featureKeyPreffix) {
        List nodes = this.commentProvider.getDocumentationNodes((EObject)region);
        if (!nodes.isEmpty() && !this.processedNode.containsAll(nodes.stream().map(INode::getStartLine).toList())) {
            BslDocumentationComment comment = this.bslDocCommentParser.parse(nodes, this.isOldCommentFormat());
            DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKeyPreffix, comment, this.parameters, this.addAction, (EObject)region, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
    }

    private void processCollectedRegionPreprocessorComments(RegionPreprocessor region, FeatureKey featureKeyPreffix, List<List<INode>> allComments) {
        for (List<INode> comments : allComments) {
            FeatureKey featureKey;
            ILeafNode leafNode = (ILeafNode)comments.get(0);
            Variable variable = BslUtils.getCommentNodeVariable(leafNode);
            if (this.isMethodOwner(comments)) continue;
            List<String> variableCommentContent = this.findVariableCommentContent(comments, variable);
            comments.forEach(n -> {
                boolean bl = this.processedNode.add(n.getStartLine());
            });
            BslDocumentationComment comment = this.bslDocCommentParser.parse(comments, this.isOldCommentFormat());
            String keyPreffix = BslUtils.getFeatrueKeyPreffix(comment);
            FeatureKey featureKey2 = featureKey = keyPreffix.isEmpty() ? featureKeyPreffix : featureKeyPreffix.append(keyPreffix);
            if (variable != null && variableCommentContent != null && !variableCommentContent.isEmpty()) {
                featureKey = this.featureKeyProvider.getKey((EObject)variable);
            }
            DocCommentCollector collector = DocCommentCollector.create(this.getResourceFile(), featureKey, comment, this.parameters, this.addAction, (EObject)region, this.bmOperationContext);
            collector.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
    }

    private boolean isMethodOwner(List<INode> comments) {
        INode lastNode = comments.get(comments.size() - 1);
        INode next = lastNode.getNextSibling();
        if (next.getText().isBlank()) {
            return false;
        }
        EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)lastNode);
        Method method = (Method)EcoreUtil2.getContainerOfType((EObject)object, Method.class);
        return method != null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUnknownDFA(DynamicFeatureAccess dfa) {
        EObject eObject;
        if (dfa.getFeatureEntries().size() == 1 && (eObject = ((FeatureEntry)dfa.getFeatureEntries().get(0)).getFeature()) instanceof DerivedProperty) {
            void derivedProperty;
            DerivedProperty derivedProperty2 = (DerivedProperty)eObject;
            DerivedProperty cfr_ignored_0 = (DerivedProperty)eObject;
            if (derivedProperty.getSource() == null) {
                return true;
            }
        }
        return false;
    }

    private boolean isUnknownMethod(DynamicFeatureAccess object, CollectingContext context) {
        boolean isMethod;
        boolean bl = isMethod = BslUtil.getInvocation((FeatureAccess)object) != null;
        if (!isMethod) {
            return false;
        }
        boolean isUnknown = this.isUnknownDFA(object);
        if (isUnknown) {
            return true;
        }
        Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        if (envs == null) {
            return false;
        }
        Environments actualEnvs = this.bslPreferences.getLoadEnvs((EObject)object).intersect(envs.environments());
        if (actualEnvs.isEmpty()) {
            return false;
        }
        List objects = this.dynamicFeatureAccessComputer.getLastObject(object, actualEnvs, true);
        return objects.isEmpty();
    }

    private boolean isUnknownField(DynamicFeatureAccess object, CollectingContext context) {
        boolean isField;
        boolean bl = isField = BslUtil.getInvocation((FeatureAccess)object) == null;
        if (!isField) {
            return false;
        }
        boolean isUnknown = this.isUnknownDFA(object);
        if (isUnknown) {
            return true;
        }
        Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        if (envs == null) {
            return false;
        }
        Environments actualEnvs = this.bslPreferences.getLoadEnvs((EObject)object).intersect(envs.environments());
        if (actualEnvs.isEmpty()) {
            return false;
        }
        List objects = this.dynamicFeatureAccessComputer.getLastObject(object, actualEnvs, true);
        List types = this.computerTypes.computeTypes((EObject)object, envs.environments());
        return objects.isEmpty() && types.isEmpty();
    }

    private List<String> findVariableCommentContent(List<INode> comments, Variable variable) {
        ICompositeNode blockNode;
        Block block;
        EObject parent;
        List<String> variableCommentContent = new ArrayList<String>();
        if (!comments.isEmpty() && variable != null && (parent = this.getVariableParent(variable)) != null && (block = (Block)EcoreUtil2.getContainerOfType((EObject)parent, Block.class)) != null && (blockNode = NodeModelUtils.findActualNodeFor((EObject)block)) != null) {
            variableCommentContent = TypeSystemUtil.getCommentAfterObject((EObject)parent, (INode)blockNode, (boolean)this.isOldCommentFormat());
        }
        return variableCommentContent;
    }
}

