/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.services.BslGrammarAccess;
import com.e1c.langtool.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;

@Singleton
public class BslGrammarTokens {
    @Inject
    private BslGrammarAccess grammar;
    private Map<String, String> keywords;
    private Map<String, String> keywordsRu;
    private Map<String, String> builtin;
    private Map<String, String> builtinRu;

    public String getKeyword(String token, boolean isRu) {
        if (StringUtils.isNullOrEmpty((String)token)) {
            return null;
        }
        if (this.keywords == null || this.keywordsRu == null) {
            this.load();
        }
        return isRu ? this.keywords.get(token.toLowerCase()) : this.keywordsRu.get(token.toLowerCase());
    }

    public String getBuiltInFunction(String token, boolean isRu) {
        if (StringUtils.isNullOrEmpty((String)token)) {
            return null;
        }
        if (this.builtin == null || this.builtinRu == null) {
            this.load();
        }
        return isRu ? this.builtin.get(token.toLowerCase()) : this.builtinRu.get(token.toLowerCase());
    }

    private synchronized void load() {
        if (this.keywords == null || this.keywordsRu == null || this.builtin == null || this.builtinRu == null) {
            EList contents = this.grammar.getExtNameRule().getAlternatives().eContents();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder builderRu = ImmutableMap.builder();
            int i = 0;
            while (i < contents.size()) {
                EObject element = (EObject)contents.get(i);
                if (element instanceof Keyword) {
                    Keyword keyword = (Keyword)element;
                    if (keyword.getValue().equalsIgnoreCase("Null")) {
                        builder.put((Object)keyword.getValue().toLowerCase(), (Object)keyword.getValue());
                        builderRu.put((Object)keyword.getValue().toLowerCase(), (Object)keyword.getValue());
                    } else if (i + 1 < contents.size() && contents.get(i + 1) instanceof Keyword) {
                        Keyword keyword2 = (Keyword)contents.get(++i);
                        builder.put((Object)keyword.getValue().toLowerCase(), (Object)keyword2.getValue());
                        builderRu.put((Object)keyword2.getValue().toLowerCase(), (Object)keyword.getValue());
                    }
                }
                ++i;
            }
            this.keywords = builder.build();
            this.keywordsRu = builderRu.build();
            contents = this.grammar.getBUILTINRule().getAlternatives().eContents();
            builder = ImmutableMap.builder();
            builderRu = ImmutableMap.builder();
            ImmutableSet mono = ImmutableSet.of((Object)"ACos", (Object)"ASin", (Object)"ATan", (Object)"Cos", (Object)"Exp", (Object)"Log", (Object[])new String[]{"Log10", "Pow", "Sin", "Sqrt", "Tan"});
            int i2 = 0;
            while (i2 < contents.size()) {
                EObject element = (EObject)contents.get(i2);
                if (element instanceof Keyword) {
                    Keyword keyword = (Keyword)element;
                    if (mono.contains(keyword.getValue())) {
                        builder.put((Object)keyword.getValue().toLowerCase(), (Object)keyword.getValue());
                        builderRu.put((Object)keyword.getValue().toLowerCase(), (Object)keyword.getValue());
                    } else if (i2 + 1 < contents.size() && contents.get(i2 + 1) instanceof Keyword) {
                        Keyword keyword2 = (Keyword)contents.get(++i2);
                        builder.put((Object)keyword.getValue().toLowerCase(), (Object)keyword2.getValue());
                        builderRu.put((Object)keyword2.getValue().toLowerCase(), (Object)keyword.getValue());
                    }
                }
                ++i2;
            }
            this.builtin = builder.build();
            this.builtinRu = builderRu.build();
        }
    }
}

