/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.typesystem.NamingCollectionServiceProvider;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedStringFeatureProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class FeatureAccessComputedNameProvider
implements IComputedStringFeatureProvider {
    private static final Set<String> DYNAMIC_PROPERTY_TYPES = ImmutableSet.builder().add((Object)"QueryResultSelection").add((Object)"Structure").add((Object)"SpreadsheetDocumentTemplateParameters").add((Object)"ValueTableRow").add((Object)"ValueTreeRow").add((Object)"FormDataCollectionItem").add((Object)"FormDataTreeItem").build();
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private TypesComputer typesComputer;
    @Inject
    private NamingCollectionServiceProvider namingCollectionServiceProvider;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;

    public boolean isSupported(EObject object) {
        return object instanceof FeatureAccess;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(BslFeatureSettings.Literals.FEATURE_ACCESS__NAME)) {
            return false;
        }
        String name = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)name)) {
            return false;
        }
        if (object instanceof DynamicFeatureAccess && BslUtil.getInvocation((FeatureAccess)((FeatureAccess)object)) == null) {
            Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
            ArrayList<FeatureEntry> features = new ArrayList();
            try {
                features = this.dynamicFeatureAccessComputer.resolveObject((FeatureAccess)object, environmental.environments());
            }
            catch (Exception e) {
                String message = MessageFormat.format("Error while resolve source object for DFA: {0}", EcoreUtil.getURI((EObject)object));
                IStatus status = BslPlugin.createErrorStatus(message, e);
                BslPlugin.log(status);
            }
            if (!BslUtils.isEmptySource(features)) {
                return true;
            }
            Version version = this.runtimeVersionSupport.getRuntimeVersionOrDefault(object, Version.LATEST);
            Expression source = ((DynamicFeatureAccess)object).getSource();
            List types = this.typesComputer.computeTypes((EObject)source, environmental.environments());
            HashSet typeNames = Sets.newHashSet();
            for (TypeItem type : types) {
                String typeName = McoreUtil.getTypeName((TypeItem)type);
                if (StringUtils.isNotEmpty((String)typeName) && this.namingCollectionServiceProvider.isNamingCollectionTypeName(typeName, version)) {
                    return false;
                }
                if (!StringUtils.isNotEmpty((String)typeName)) continue;
                typeNames.add(typeName);
            }
            typeNames.retainAll(DYNAMIC_PROPERTY_TYPES);
            return typeNames.isEmpty();
        }
        return true;
    }
}

