/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.contextdef.IBslModuleContextDefService;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleType;
import com._1c.g5.v8.dt.bsl.resource.BslEventsService;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.mcore.ParamSet;
import com._1c.g5.v8.dt.mcore.Parameter;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class FormalParamComputedNameProvider
implements IComputedStringFeatureTranslationProvider {
    private static final String BUSINESS_PRECESS = "BusinessProcess";
    private static final String BUSINESS_PRECESSES = "BusinessProcesses";
    @Inject
    private BslEventsService bslEventsService;
    @Inject
    private IBslModuleContextDefService contextDefService;

    public boolean isSupported(EObject object) {
        return object instanceof FormalParam;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        Parameter equaledParam = this.findEqualedParameter((FormalParam)object);
        return equaledParam != null;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!translationProvider.getProject().isChangeScriptVariant()) {
            return null;
        }
        Parameter equaledParam = this.findEqualedParameter((FormalParam)object);
        if (equaledParam == null) {
            return null;
        }
        if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
            return equaledParam.getNameRu();
        }
        return equaledParam.getName();
    }

    private ParamSet getParamSet(Method method, Module module) {
        ModuleType type = module.getModuleType();
        boolean isFormOrBpOrCommonModule = this.isFormOrCommonModule(type) || this.isBusinessProcess(module);
        int totalParams = method.getPragmas().size();
        if (isFormOrBpOrCommonModule || ModuleType.HTTP_SERVICE_MODULE.equals((Object)type) || ModuleType.WEB_SERVICE_MODULE.equals((Object)type) || ModuleType.INTEGRATION_SERVICE_MODULE.equals((Object)type)) {
            Map basisEventHandlers = this.bslEventsService.getEventHandlers(module);
            List handlers = (List)basisEventHandlers.get(new CaseInsensitiveString(method.getName()));
            if (handlers == null) {
                return null;
            }
            for (EObject handler : handlers) {
                if (!(handler instanceof Event) || ((Event)handler).getParamSet().isEmpty()) continue;
                if (isFormOrBpOrCommonModule && totalParams > 1 && ((Event)handler).actualParamSet(totalParams) == null) {
                    return ((Event)handler).actualParamSet(totalParams - 1);
                }
                return ((Event)handler).actualParamSet(totalParams);
            }
        } else {
            Map eventHandlers = BslUtil.transformToMapOfEvent((List)this.contextDefService.getModuleEvents(module));
            List events = (List)eventHandlers.get(new CaseInsensitiveString(method.getName()));
            if (events != null && !events.isEmpty()) {
                return ((Event)events.get(0)).actualParamSet(totalParams);
            }
        }
        return null;
    }

    private boolean isFormOrCommonModule(ModuleType type) {
        return ModuleType.FORM_MODULE.equals((Object)type) || ModuleType.COMMON_MODULE.equals((Object)type);
    }

    private boolean isBusinessProcess(Module module) {
        ModuleType moduleType = module.getModuleType();
        if (moduleType.equals((Object)ModuleType.OBJECT_MODULE)) {
            String uri = EcoreUtil.getURI((EObject)module).toPlatformString(true);
            return uri.contains(BUSINESS_PRECESS) || uri.contains(BUSINESS_PRECESSES);
        }
        return false;
    }

    private Parameter findEqualedParameter(FormalParam formalParam) {
        Parameter param;
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)formalParam, Module.class);
        if (module == null) {
            return null;
        }
        boolean isFormOrCommonModule = this.isFormOrCommonModule(module.getModuleType());
        Method method = (Method)EcoreUtil2.getContainerOfType((EObject)formalParam, Method.class);
        ParamSet paramSet = null;
        try {
            paramSet = this.getParamSet(method, module);
        }
        catch (Exception e) {
            String message = MessageFormat.format("Error while get Param set for method: {0}", EcoreUtil.getURI((EObject)method));
            IStatus status = BslPlugin.createErrorStatus(message, e);
            BslPlugin.log(status);
        }
        if (paramSet == null) {
            return null;
        }
        int index = method.getFormalParams().indexOf((Object)formalParam);
        EList params = paramSet.getParams();
        if (params != null && params.size() > index) {
            param = (Parameter)params.get(index);
            if (formalParam.getName().equals(param.getName()) || formalParam.getName().equals(param.getNameRu())) {
                return param;
            }
        }
        if (isFormOrCommonModule && params != null && params.size() >= index && index > 0) {
            param = (Parameter)params.get(index - 1);
            if (formalParam.getName().equals(param.getName()) || formalParam.getName().equals(param.getNameRu())) {
                return param;
            }
        }
        return null;
    }
}

