/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmExternalUriResolver;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bsl.bm.BslBmLinkProvider;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.resource.BslResolveCrossReferencesJob;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class ModuleCachedLoader {
    private static final long WAIT_RESOLVING = Duration.ofMinutes(5L).toMillis();
    private final IBmModelManager modelManager;
    private final Set<URI> currentResolving = ConcurrentHashMap.newKeySet();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Inject
    public ModuleCachedLoader(IBmModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public @Nullable Module getModule(@NonNull IFile file, @NonNull CancelIndicator cancelIndicator) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        IBmModel model = this.modelManager.getModel(file.getProject());
        if (model == null) {
            return null;
        }
        BslBmLinkProvider provider = this.getBslProvider(model);
        if (provider == null) {
            return null;
        }
        Resource resource = provider.getResource(uri);
        if (!(resource instanceof BslResource)) {
            return null;
        }
        this.resolveResource((BslResource)resource, cancelIndicator);
        EObject source = (EObject)resource.getContents().get(0);
        if (source instanceof Module) {
            return (Module)source;
        }
        return null;
    }

    public @Nullable Module getModule(@NonNull URI uri, @NonNull EObject context, @NonNull CancelIndicator cancelIndicator) {
        block13: {
            EObject source;
            IBmModel model = this.modelManager.getModel(uri);
            if (model == null) {
                return null;
            }
            if (BmUriUtil.isBmUri((URI)uri)) {
                IBmTransaction transaction = model.getEngine().getCurrentTransaction();
                boolean newTransaction = false;
                if (transaction == null) {
                    transaction = model.getEngine().beginReadOnlyTransaction(true);
                    newTransaction = true;
                }
                try {
                    IBmObject source2 = transaction.getObjectByUri(uri);
                    if (source2 instanceof Module) {
                        this.resolveModule((Module)source2, cancelIndicator);
                        Module module = (Module)source2;
                        return module;
                    }
                    break block13;
                }
                finally {
                    if (newTransaction) {
                        transaction.commit();
                    }
                }
            }
            BslBmLinkProvider provider = this.getBslProvider(model);
            if (provider != null) {
                Resource resource;
                source = provider.getObject(uri);
                if (source == null && (resource = provider.getResource(uri)) instanceof BslResource) {
                    this.resolveResource((BslResource)resource, cancelIndicator);
                    source = resource.getEObject(uri.fragment());
                }
                if (source instanceof Module) {
                    this.resolveModule((Module)source, cancelIndicator);
                    return (Module)source;
                }
            }
            if ((source = model.getEngine().resolve(uri, BslPackage.Literals.MODULE)) != null && source.eIsProxy()) {
                source = EcoreUtil.resolve((EObject)source, (EObject)context);
            }
            if (source instanceof Module) {
                this.resolveModule((Module)source, cancelIndicator);
                return (Module)source;
            }
        }
        return null;
    }

    public void cleanCached(URI uri) {
        IBmModel model = this.modelManager.getModel(uri);
        if (model == null) {
            return;
        }
        BslBmLinkProvider provider = this.getBslProvider(model);
        if (provider != null) {
            provider.remove(uri);
        }
    }

    private BslBmLinkProvider getBslProvider(IBmModel model) {
        for (IBmExternalUriResolver provider : model.getEngine().getExternalUriResolvers()) {
            if (!(provider instanceof BslBmLinkProvider)) continue;
            return (BslBmLinkProvider)provider;
        }
        return null;
    }

    private void resolveModule(Module module, CancelIndicator cancelIndicator) {
        BslResource resource = (BslResource)module.eResource();
        this.resolveResource(resource, cancelIndicator);
    }

    private void resolveResource(BslResource resource, CancelIndicator cancelIndicator) {
        URI uri = resource.getURI();
        long waitUntil = System.currentTimeMillis() + WAIT_RESOLVING;
        boolean timeOut = false;
        while (!((timeOut = waitUntil < System.currentTimeMillis()) || !this.isResolving(uri) && this.tryToStartResloving(uri))) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                BslPlugin.logError(e);
            }
        }
        if (timeOut && this.isResolving(uri)) {
            String message = MessageFormat.format("BSL resolve cross-reference incomplete in 5 min {0}", uri);
            IStatus status = BslPlugin.createWarningStatus(message);
            BslPlugin.log(status);
        }
        this.lock.writeLock().lock();
        this.currentResolving.add(uri);
        this.lock.writeLock().unlock();
        try {
            if (resource.isDeepAnalysing() && resource.isLinkedBatch()) {
                return;
            }
            try {
                BslResource.setSingleThreadMode();
                resource.setDeepAnalysis(true);
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
                Collection jobs = BslResolveCrossReferencesJob.findJobsByResource((LazyLinkingResource)resource);
                for (BslResolveCrossReferencesJob job : jobs) {
                    job.join();
                }
            }
            catch (Exception e) {
                BslPlugin.logError(e);
            }
        }
        finally {
            BslResource.resetSingleThreadMode();
            this.lock.writeLock().lock();
            this.currentResolving.remove(uri);
            this.lock.writeLock().unlock();
        }
    }

    private boolean isResolving(URI uri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.currentResolving.contains(uri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean tryToStartResloving(URI uri) {
        this.lock.writeLock().lock();
        try {
            if (this.currentResolving.contains(uri)) {
                return false;
            }
            this.currentResolving.add(uri);
            return true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

