/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl;

import com._1c.g5.v8.dt.bsl.contextdef.IBslModuleContextDefService;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleType;
import com._1c.g5.v8.dt.bsl.util.BslUtil;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class StandardEventNameTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private IBslModuleContextDefService contextDefService;

    public boolean isSupported(EObject object) {
        return object instanceof Method && ((Method)object).isEvent() && this.isSupportedModuleType(object);
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return false;
        }
        Method method = (Method)object;
        String handlerName = method.getName();
        List<Event> events = this.getEvents(method);
        if (events != null) {
            for (Event event : events) {
                if (!handlerName.equalsIgnoreCase(event.getName()) && !handlerName.equalsIgnoreCase(event.getNameRu())) continue;
                return true;
            }
        }
        return false;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return null;
        }
        Method method = (Method)object;
        String handlerName = method.getName();
        List<Event> events = this.getEvents(method);
        if (events != null) {
            for (Event event : events) {
                if (!handlerName.equalsIgnoreCase(event.getName()) && !handlerName.equalsIgnoreCase(event.getNameRu())) continue;
                if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
                    return event.getNameRu();
                }
                return event.getName();
            }
        }
        return null;
    }

    private List<Event> getEvents(Method method) {
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)method, Module.class);
        if (module == null) {
            return Lists.newArrayList();
        }
        String handlerName = method.getName();
        Map eventHandlers = BslUtil.transformToMapOfEvent((List)this.contextDefService.getModuleEvents(module));
        return (List)eventHandlers.get(new CaseInsensitiveString(handlerName));
    }

    private boolean isSupportedModuleType(EObject object) {
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        if (module == null) {
            return false;
        }
        ModuleType type = module.getModuleType();
        return type.equals((Object)ModuleType.COMMAND_MODULE) || type.equals((Object)ModuleType.OBJECT_MODULE) || type.equals((Object)ModuleType.MANAGER_MODULE) || type.equals((Object)ModuleType.RECORDSET_MODULE) || type.equals((Object)ModuleType.EXTERNAL_CONN_MODULE) || type.equals((Object)ModuleType.MANAGED_APP_MODULE) || type.equals((Object)ModuleType.ORDINARY_APP_MODULE) || type.equals((Object)ModuleType.SESSION_MODULE) || type.equals((Object)ModuleType.BOT_MODULE) || type.equals((Object)ModuleType.WEB_SOCKET_CLIENT_MODULE);
    }
}

