/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.naming;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.IfPreprocessor;
import com._1c.g5.v8.dt.bsl.model.ImplicitVariable;
import com._1c.g5.v8.dt.bsl.model.IndexAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.Label;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.PreprocessorItem;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessorDeclareStatement;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessorExpression;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessorStatement;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.NstrTypeComputer;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.Property;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.FeatureKeyMigrationnExtension;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.internal.naming.BslNstrKeyComputer;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.naming.AbstractFeatureKeyComputer;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.EcoreUtil2;

public class BslKeyComputer
extends AbstractFeatureKeyComputer
implements FeatureKeyMigrationnExtension {
    public static final String FQN_REGION = "Region";
    public static final String FQN_NSTR = "NStr";
    public static final String FQN_STRING = "String";
    public static final String FQN_FEATURE_ACCESS = "Unknown";
    public static final String FQN_FEATURE_ACCESS_OLD = "FeatureAccess";
    public static final String FQN_LABEL = "Label";
    public static final String FQN_METHOD = "Method";
    public static final String FQN_VAR = "Var";
    public static final String FQN_PARAM = "Param";
    public static final String NON_BREAKING_SPACE = "\u00a0";
    public static final String FQN_FUNC = "Func";
    public static final String FQN_RETURN = "Return";
    public static final String FQN_RAISE = "Raise";
    private static final String BSL_FILE_EXT = "bsl";
    @Inject
    protected IStringLiteralTypeComputer typeComputer;
    @Inject
    private IV8ProjectManager projectManager;
    @Inject
    private BslNstrKeyComputer nstrKeyComputer;
    @Inject
    private BslPreferences translationPreferences;

    public boolean isSupported(EObject object) {
        EPackage objectPackage = object.eClass().getEPackage();
        return objectPackage.equals(BslPackage.eINSTANCE) || object instanceof Method;
    }

    public FeatureKey computeFqn(EObject obj) {
        if (obj instanceof Module) {
            return SegmentFeatureKey.EMPTY;
        }
        if (obj instanceof com._1c.g5.v8.dt.bsl.model.Method) {
            return this._computeFqn((com._1c.g5.v8.dt.bsl.model.Method)obj);
        }
        if (obj instanceof Method) {
            return this._computeFqn((Method)obj);
        }
        if (obj instanceof Property) {
            return this._computeFqn((Property)obj);
        }
        if (obj instanceof FormalParam) {
            return this._computeFqn((FormalParam)obj);
        }
        if (obj instanceof Variable) {
            return this._computeFqn((Variable)obj);
        }
        if (obj instanceof StringLiteral) {
            return this._computeFqn((StringLiteral)obj);
        }
        if (obj instanceof Invocation) {
            return this._computeFqn((Invocation)obj);
        }
        if (obj instanceof RegionPreprocessor) {
            return this._computeFqn((RegionPreprocessor)obj);
        }
        if (obj instanceof DynamicFeatureAccess) {
            return this._computeFqn((DynamicFeatureAccess)obj);
        }
        if (obj instanceof StaticFeatureAccess) {
            return this._computeFqn((StaticFeatureAccess)obj);
        }
        if (obj instanceof FeatureAccess) {
            return this._computeFqn((FeatureAccess)obj);
        }
        if (obj instanceof Label) {
            return this._computeFqn((Label)obj);
        }
        if (obj instanceof PreprocessorItem) {
            return this._computeFqn((PreprocessorItem)obj);
        }
        if (obj instanceof IfPreprocessor) {
            return this._computeFqn((IfPreprocessor)obj);
        }
        BslPlugin.log(BslPlugin.createWarningStatus(MessageFormat.format("Bsl: Unhandled Feature Key parameter type: {0}", obj)));
        return this.computeListOrParent(obj);
    }

    protected FeatureKey _computeFqn(com._1c.g5.v8.dt.bsl.model.Method method) {
        FeatureKey _expression = null;
        String name = method.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        _expression = this.toFeatureKey(FQN_METHOD).append(this.toFeatureKey(name));
        return _expression;
    }

    protected FeatureKey _computeFqn(Method method) {
        FeatureKey _expression = null;
        String name = method.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        _expression = this.toFeatureKey(FQN_METHOD).append(this.toFeatureKey(name));
        return _expression;
    }

    protected FeatureKey _computeFqn(Property property) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = property.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = EcoreUtil2.getContainerOfType((EObject)property.eContainer(), Module.class);
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey(name);
            return fqn.append(_expression);
        }
        return null;
    }

    protected FeatureKey _computeFqn(FormalParam var) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = var.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = EcoreUtil2.getContainerOfType((EObject)var, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey(FQN_PARAM).append(this.toFeatureKey(name));
            return fqn.append(_expression);
        }
        return null;
    }

    protected FeatureKey _computeFqn(Variable var) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = var.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = EcoreUtil2.getContainerOfType((EObject)var, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)var, Module.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey(FQN_VAR).append(this.toFeatureKey(name));
            return fqn.append(_expression);
        }
        return null;
    }

    protected FeatureKey _computeFqn(StringLiteral literal) {
        FeatureKey _expression = null;
        if (BslUtils.isNStr(literal, this.typeComputer) && (_expression = this.nstrKeyComputer.compute(literal, this.getTranslationProperties(literal), null, null)) != null) {
            return _expression;
        }
        SimpleStatement statement = (SimpleStatement)EcoreUtil2.getContainerOfType((EObject)literal, SimpleStatement.class);
        if (statement != null) {
            Expression expr = statement.getLeft();
            if (expr instanceof DynamicFeatureAccess) {
                expr = ((DynamicFeatureAccess)expr).getSource();
            }
            if (expr instanceof Variable) {
                _expression = this.computeFqn((EObject)expr);
            } else if (expr instanceof StaticFeatureAccess) {
                ImplicitVariable var = ((StaticFeatureAccess)expr).getImplicitVariable();
                if (var != null) {
                    _expression = this.computeFqn((EObject)var);
                } else {
                    _expression = SegmentFeatureKey.EMPTY;
                    String variableName = ((StaticFeatureAccess)expr).getName();
                    com._1c.g5.v8.dt.bsl.model.Method method = (com._1c.g5.v8.dt.bsl.model.Method)EcoreUtil2.getContainerOfType((EObject)literal, com._1c.g5.v8.dt.bsl.model.Method.class);
                    if (method != null) {
                        _expression = this.computeFqn((EObject)method);
                    }
                    if (method != null && variableName != null && method.getFormalParams().stream().anyMatch(p -> variableName.equalsIgnoreCase(p.getName()))) {
                        _expression = _expression.append(FQN_PARAM).append(variableName);
                    } else if (variableName != null) {
                        _expression = _expression.append(FQN_VAR).append(variableName);
                    }
                }
            }
        }
        if (_expression == null) {
            EObject parent = EcoreUtil2.getContainerOfType((EObject)literal, com._1c.g5.v8.dt.bsl.model.Method.class);
            if (parent == null) {
                parent = EcoreUtil2.getContainerOfType((EObject)literal, Module.class);
            }
            if (parent != null) {
                _expression = this.computeFqn(parent);
            }
        }
        if (_expression == null) {
            _expression = SegmentFeatureKey.EMPTY;
        }
        if (this.typeComputer.containsAnyType(literal, new String[]{FQN_NSTR})) {
            String languageCode = this.getLanguageCode(literal);
            String literalKey = null;
            Map<String, String> nlsStrings = BslUtils.getNlsLocalStrings(literal);
            if (Strings.isNullOrEmpty((String)languageCode) && nlsStrings.size() == 1) {
                for (Map.Entry<String, String> entry : nlsStrings.entrySet()) {
                    literalKey = entry.getValue();
                }
            } else if (!Strings.isNullOrEmpty((String)languageCode)) {
                literalKey = this.replaceNonBreakingSpaces(nlsStrings.get(languageCode));
            }
            if (!Strings.isNullOrEmpty(literalKey)) {
                _expression = _expression.append(FQN_NSTR).append(literalKey);
            }
        } else if (!this.typeComputer.containsAnyType(literal, LangToolDefaults.QUERY)) {
            String literalKey = BslUtils.getString(literal);
            _expression = _expression.append(FQN_STRING).append(literalKey);
        }
        return _expression;
    }

    protected String replaceNonBreakingSpaces(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        if (!input.contains(NON_BREAKING_SPACE)) {
            return input;
        }
        return input.replace(NON_BREAKING_SPACE, " ");
    }

    protected String getLanguageCode(StringLiteral literal) {
        return FeaturesCollectorUtil.getDefaultLanguageCode((EObject)literal, (IV8ProjectManager)this.projectManager);
    }

    protected TranslatorProperties getTranslationProperties(StringLiteral literal) {
        IV8Project v8Project = this.projectManager.getProject((EObject)literal);
        if (v8Project == null) {
            return null;
        }
        return this.translationPreferences.getTranslatorProperties(v8Project.getProject());
    }

    protected FeatureKey _computeFqn(Invocation inv) {
        if (NstrTypeComputer.isNls((Invocation)inv) && !inv.getParams().isEmpty()) {
            return this.computeFqn((EObject)inv.getParams().get(0));
        }
        return null;
    }

    protected FeatureKey _computeFqn(RegionPreprocessor obj) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = obj.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            return null;
        }
        EObject parent = null;
        parent = obj instanceof RegionPreprocessorDeclareStatement ? EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), RegionPreprocessorDeclareStatement.class) : (obj instanceof RegionPreprocessorStatement ? EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), RegionPreprocessorStatement.class) : (obj instanceof RegionPreprocessorExpression ? EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), RegionPreprocessorExpression.class) : EcoreUtil2.getContainerOfType((EObject)obj.eContainer(), RegionPreprocessor.class)));
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            _expression = this.toFeatureKey(name);
            return fqn.append(_expression);
        }
        _expression = this.toFeatureKey(FQN_REGION);
        _expression = _expression.append(name);
        parent = EcoreUtil2.getContainerOfType((EObject)obj, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)obj, Module.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            return fqn.append(_expression);
        }
        return null;
    }

    protected FeatureKey _computeFqn(DynamicFeatureAccess fa) {
        FeatureKey _expression = null;
        String name = fa.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return _expression;
        }
        Expression parent = fa.getSource();
        if (parent instanceof Invocation) {
            parent = ((Invocation)parent).getMethodAccess();
        } else if (parent instanceof IndexAccess) {
            parent = ((IndexAccess)parent).getSource();
        }
        if (!(parent instanceof FeatureAccess)) {
            parent = (Expression)EcoreUtil2.getContainerOfType((EObject)parent, FeatureAccess.class);
        }
        if (parent != null && !fa.equals(parent)) {
            _expression = this.computeFqn((EObject)parent);
        }
        _expression = _expression != null ? _expression.append(name) : this._computeFqn((FeatureAccess)fa);
        return _expression;
    }

    protected FeatureKey _computeFqn(StaticFeatureAccess fa) {
        ImplicitVariable var = fa.getImplicitVariable();
        if (var != null) {
            FeatureKey _expression = this.computeFqn((EObject)var);
            String name = fa.getName();
            if (name == null || Strings.isNullOrEmpty((String)name)) {
                return _expression;
            }
            if (_expression != null) {
                _expression = _expression.append(FQN_FEATURE_ACCESS);
                _expression = _expression.append(name);
                return _expression;
            }
        }
        return this._computeFqn((FeatureAccess)fa);
    }

    protected FeatureKey _computeFqn(FeatureAccess fa) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = fa.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return _expression;
        }
        _expression = this.toFeatureKey(FQN_FEATURE_ACCESS);
        _expression = _expression.append(name);
        EObject parent = EcoreUtil2.getContainerOfType((EObject)fa, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)fa, Module.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            return fqn.append(_expression);
        }
        return _expression;
    }

    protected FeatureKey _computeFqn(Label label) {
        FeatureKey fqn;
        FeatureKey _expression = null;
        String name = label.getName();
        if (name == null || Strings.isNullOrEmpty((String)name)) {
            return _expression;
        }
        if (name.trim().startsWith("~")) {
            name = name.trim().substring(1);
        }
        _expression = this.toFeatureKey(FQN_LABEL);
        _expression = _expression.append(name);
        EObject parent = EcoreUtil2.getContainerOfType((EObject)label, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (parent == null) {
            parent = EcoreUtil2.getContainerOfType((EObject)label, Module.class);
        }
        if (parent != null && (fqn = this.computeFqn(parent)) != null) {
            return fqn.append(_expression);
        }
        return _expression;
    }

    protected FeatureKey _computeFqn(PreprocessorItem obj) {
        EObject parent = obj.eContainer();
        FeatureKey fqn = this.computeFqn(parent);
        if (fqn != null) {
            return fqn;
        }
        return SegmentFeatureKey.EMPTY;
    }

    protected FeatureKey _computeFqn(IfPreprocessor obj) {
        EObject parent = obj.eContainer();
        FeatureKey fqn = this.computeFqn(parent);
        if (fqn != null) {
            return fqn;
        }
        return SegmentFeatureKey.EMPTY;
    }

    public boolean isSupport(ContextTranslationKey contexTranslationKey) {
        return contexTranslationKey.getResourceId() != null && BSL_FILE_EXT.equalsIgnoreCase(contexTranslationKey.getResourceId().getFileExtension());
    }

    public Collection<FeatureKey> getOldFeatureKeys(FeatureKey key) {
        ArrayList<String> segments = new ArrayList<String>();
        boolean modified = false;
        int i = 0;
        while (i < key.getSegmentCount()) {
            String segment = key.getSegment(i);
            if (i + 2 < key.getSegmentCount() && (FQN_METHOD.equalsIgnoreCase(segment) || FQN_VAR.equalsIgnoreCase(segment) || FQN_PARAM.equalsIgnoreCase(segment))) {
                modified = true;
            } else if (i + 2 < key.getSegmentCount() && FQN_FEATURE_ACCESS.equalsIgnoreCase(segment)) {
                segments.add(FQN_FEATURE_ACCESS_OLD);
                modified = true;
                i = key.getSegmentCount() - 3;
            } else {
                segments.add(segment);
            }
            ++i;
        }
        if (modified) {
            return Arrays.asList(SegmentFeatureKey.create(segments));
        }
        return Collections.emptyList();
    }
}

