/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.settings.impl;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.bsl.BslGrammarTokens;
import com.e1c.langtool.v8.dt.bsl.settings.impl.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BslKeywordNameValidator
implements FeatureValueValidator {
    private static final String BSL_SUFFIX = "bsl";
    @Inject
    private BslGrammarTokens grammarTokens;

    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        TranslationKey translationKey = context.getTranslationKey();
        if (translationKey instanceof ContextTranslationKey && translationKey.getFeatureSettings().equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME) && BSL_SUFFIX.equalsIgnoreCase(((ContextTranslationKey)translationKey).getResourceId().getFileExtension())) {
            if (this.grammarTokens.getKeyword(value, false) != null || this.grammarTokens.getKeyword(value, true) != null) {
                String message = MessageFormat.format(Messages.BslKeywordNameValidator_Value__V__equals_BSL_keyword, value);
                return BslPlugin.createErrorStatus(message, null);
            }
            FeatureKey key = ((ContextTranslationKey)translationKey).getFeatureKey();
            if (key.getSegmentCount() == 3 && key.getFirstSegment().equalsIgnoreCase("Method") && (this.grammarTokens.getBuiltInFunction(value, false) != null || this.grammarTokens.getBuiltInFunction(value, true) != null)) {
                String message = MessageFormat.format(Messages.BslKeywordNameValidator_Value__V__equals_BSL_built_in_function, value);
                return BslPlugin.createErrorStatus(message, null);
            }
        }
        return Status.OK_STATUS;
    }
}

