/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesCollector;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.ql.QlPartStringParser;
import com.e1c.langtool.v8.dt.ql.settings.QlFeatureSettings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.antlr.runtime.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractQueryPartProcessor
extends AbstractStringLiteralLinesCollector {
    @Inject
    protected Provider<QlPartStringParser> stringParserProvider;
    @Inject
    protected InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    protected IStringLiteralTypeComputer typeComputer;
    @Inject
    protected IV8ProjectManager v8ProjectManager;

    @Override
    protected void collectContent(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }

    protected QlPartStringParser getQlPartStringParser(String literalContent) {
        QlPartStringParser parser = (QlPartStringParser)this.stringParserProvider.get();
        int firstQuote = literalContent.indexOf(34);
        if (firstQuote > -1 && StringUtils.isBlank((String)literalContent.substring(0, firstQuote)) && literalContent.indexOf(34, firstQuote + 1) == -1) {
            parser.setString(literalContent.replace('\"', ' '));
        } else {
            parser.setString(literalContent);
        }
        return parser;
    }

    protected String getKey(Token token, QlPartStringParser parser) {
        String key = token.getText();
        if (key != null) {
            key = key.trim();
        }
        if (StringUtils.isNullOrEmpty((String)key) || StringUtils.isNotWord((String)key)) {
            return null;
        }
        return key;
    }

    protected String getStringLiteralContent(Token token, QlPartStringParser parser) {
        String name = parser.getTokenName(token);
        if (name == null) {
            String content = token.getText().trim();
            if (content.startsWith("\"") && content.endsWith("\"")) {
                content = content.substring(1);
                content = content.substring(0, content.length() - 1);
                content = content.replaceAll("\"\"", "\"");
            }
            return content;
        }
        return null;
    }

    protected String getCommentContent(Token token, QlPartStringParser parser) {
        String name = parser.getTokenName(token);
        if (name == null) {
            String content = token.getText().trim();
            if (content.startsWith("//")) {
                int substring = "//".length();
                int i = "//".length();
                while (i < content.length()) {
                    if (content.charAt(i) != '/') break;
                    substring = i + 1;
                    ++i;
                }
                content = content.substring(substring);
            }
            return content.trim();
        }
        return null;
    }

    protected ContextTranslationKey createKeyContextTranslationKey(IFile file, FeatureKey featureKey, String key) {
        return new ContextTranslationKeyImpl(file, featureKey.skipLast(1).append(key).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, key);
    }

    protected ContextTranslationKey createStringLiteralContextTranslationKey(IFile file, FeatureKey featureKey, String content) {
        FeatureKey literalKey = featureKey.skipLast(1).append(content).append(QlFeatureSettings.Literals.STRING_LITERAL_EXPRESSION__CONTENT.getName());
        return new ContextTranslationKeyImpl(file, literalKey, BslFeatureSettings.Literals.STRING_LITERAL__KEY, content);
    }

    protected ContextTranslationKey createCommentContextTranslationKey(IFile file, FeatureKey featureKey, String content) {
        FeatureKey literalKey = featureKey.skipLast(1).append(content).append(QlFeatureSettings.Literals.COMMENT__DESCRIPTION.getName());
        return new ContextTranslationKeyImpl(file, literalKey, QlFeatureSettings.Literals.COMMENT__DESCRIPTION, content);
    }
}

