/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralCollector;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;

public class FormatCollector
extends DefaultStringLiteralCollector {
    @Inject
    private FormatInternalizeTokenProvider formatInternalizeTokenProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Format"});
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }

    @Override
    protected boolean needToCollectByKeys() {
        return false;
    }

    @Override
    protected boolean isComputedValue(StringLiteral literal, String content, CollectingContext context) {
        V8ParametersStringParser parser = new V8ParametersStringParser(content);
        if (parser.getStatus().isOK()) {
            for (Map.Entry entry : parser.getParameters().entrySet()) {
                String token;
                StringTokenizer tokenizer;
                String key = (String)entry.getKey();
                if (this.formatInternalizeTokenProvider.getInternalizeEnumValue(key, false) == null && this.formatInternalizeTokenProvider.getInternalizeEnumValue(key, true) == null) {
                    return false;
                }
                String value = (String)entry.getValue();
                if (this.formatInternalizeTokenProvider.isDataFormat(key)) {
                    tokenizer = new StringTokenizer(value, " \t\n\r\f,|[].'\"(){}<>?!@=-;%/\\#&:\u2116$^*");
                    while (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (StringUtils.isNotWord((String)token) || this.formatInternalizeTokenProvider.getInternalizeDateFormatValue(token, false) != null || this.formatInternalizeTokenProvider.getInternalizeDateFormatValue(token, true) != null) continue;
                        return false;
                    }
                    continue;
                }
                if (this.formatInternalizeTokenProvider.isLocalDataFormat(key)) {
                    tokenizer = new StringTokenizer(value, " \t\n\r\f,|[].'\"(){}<>?!@=-;%/\\#&:\u2116$^*");
                    while (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (StringUtils.isNotWord((String)token) || this.formatInternalizeTokenProvider.getInternalizeLocalDateFormatValue(token, false) != null || this.formatInternalizeTokenProvider.getInternalizeLocalDateFormatValue(token, true) != null) continue;
                        return false;
                    }
                    continue;
                }
                if (value == null || value.trim().isBlank() || StringUtils.isNotWord((String)value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

