/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.format.FormatUtils;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;

public class FormatContentProcessor
extends DefaultStringLiteralContentProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private FormatInternalizeTokenProvider formatInternalizeTokenProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Format"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        String newContent;
        List<String> lines = super.process(literal, types, translationProvider, language, monitor);
        if (!this.isChangeScriptVariant(translationProvider)) {
            return lines;
        }
        String content = String.join((CharSequence)"\n", lines);
        ScriptVariant scriptVariant = translationProvider.getProject().getScriptVariant();
        try {
            newContent = FormatUtils.processFormatContent((String)content, (ScriptVariant)scriptVariant, (FormatInternalizeTokenProvider)this.formatInternalizeTokenProvider);
        }
        catch (Exception e) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)literal);
            Module module = (Module)EcoreUtil2.getContainerOfType((EObject)literal, Module.class);
            if (module != null) {
                BslPlugin.logError(String.format("Cannot translate Format literal string - %s in line %d into module %s", content, node.getStartLine(), module.getUniqueName()), e);
            }
            newContent = content;
        }
        return Arrays.asList(newContent.split("\n", -1));
    }

    @Override
    protected boolean needToTranslateByKeys() {
        return false;
    }
}

