/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.modeling.xtext.scoping.ISliceFilter;
import com._1c.g5.v8.dt.bm.index.emf.IBmEmfIndexManager;
import com._1c.g5.v8.dt.bm.index.emf.IBmEmfIndexProvider;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeyTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesProcessor;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.CancelIndicator;

public class FullNameContentProcessor
extends AbstractStringLiteralLinesProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IBmEmfIndexManager bmEmfIndexManager;
    @Inject
    private ITranslatedSymbolicNameService translatedSymbolicNameService;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Full-name"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList lines = literal.lines(false);
        boolean isChangeScriptVariant = translationProvider.getProject().isChangeScriptVariant();
        boolean isChangeDefaultLanguage = translationProvider.getProject().isChangeDefaultLanguage();
        if (!isChangeScriptVariant && !isChangeDefaultLanguage) {
            return lines;
        }
        String[] names = this.getNameSegments(literal);
        if (names.length < 2) {
            List<String> newLines;
            boolean priority = this.isStringLiteralLinesFullTranslationStoredPriority(literal);
            List<String> list = newLines = priority ? this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor) : this.getContextLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor);
            if (newLines.isEmpty()) {
                return lines;
            }
            return newLines;
        }
        String[] translated = new String[names.length];
        boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        IProject sourceProject = translationProvider.getProject().getSourceProject().getProject();
        IBmEmfIndexProvider imdexProvider = this.bmEmfIndexManager.getEmfIndexProvider(sourceProject);
        if (FullNameContentProcessor.isQualifiedName(names)) {
            QualifiedName fqn = QualifiedName.create((String[])names);
            Iterable result = imdexProvider.getEObjectIndexByType(DbViewPackage.Literals.DB_VIEW_ELEMENT, fqn, true);
            Iterator iterator = result.iterator();
            if (iterator.hasNext()) {
                IEObjectDescription desc = (IEObjectDescription)iterator.next();
                DbViewElement dbView = (DbViewElement)desc.getEObjectOrProxy();
                if (dbView.eIsProxy()) {
                    dbView = (DbViewElement)EcoreUtil.resolve((EObject)dbView, (EObject)literal);
                }
                String[] name = dbView.getName().split("\\.");
                String[] nameRu = dbView.getNameRu().split("\\.");
                String translation = this.translatedSymbolicNameService.generateSymbolicName((EObject)dbView, (EObject)literal, null, translationProvider);
                String[] translatedNames = translation.split("\\.");
                String[] stringArray = translated = isRussian ? nameRu : name;
                if (translated.length != names.length || translatedNames.length != names.length) {
                    return lines;
                }
                int i = 0;
                while (i < names.length) {
                    if (name[i].equalsIgnoreCase(nameRu[i]) && isChangeDefaultLanguage) {
                        translated[i] = this.fixKeyTranslationCase(names[i], translatedNames[i]);
                    } else if (!name[i].equalsIgnoreCase(nameRu[i]) && isChangeScriptVariant) {
                        translated[i] = this.fixKeyTranslationCase(names[i], translated[i]);
                    }
                    ++i;
                }
                return Arrays.asList(FullNameContentProcessor.formatStringLiteralTranslation(literal, names, translated));
            }
            result = imdexProvider.getEObjectIndexByType(MdClassPackage.Literals.MD_OBJECT, fqn, true);
            iterator = result.iterator();
            if (iterator.hasNext()) {
                IEObjectDescription desc = (IEObjectDescription)iterator.next();
                MdObject mdObject = (MdObject)desc.getEObjectOrProxy();
                if (mdObject.eIsProxy()) {
                    mdObject = (MdObject)EcoreUtil.resolve((EObject)mdObject, (EObject)literal);
                }
                String name = this.translatedSymbolicNameService.generateSymbolicName((EObject)mdObject, (EObject)literal, null, translationProvider);
                translated = name.split("\\.");
                int i = 0;
                while (i < translated.length && i < names.length) {
                    translated[i] = this.fixKeyTranslationCase(names[i], translated[i]);
                    ++i;
                }
                return Arrays.asList(FullNameContentProcessor.formatStringLiteralTranslation(literal, names, translated));
            }
        }
        boolean hasDbViewTerm = false;
        boolean hasTranslation = false;
        URI uri = EcoreUtil.getURI((EObject)literal);
        Path path = new Path(uri.trimFragment().toPlatformString(true));
        String fullPath = path.toString();
        FeatureKey objectKey = this.translationKeyProvider.getKey((EObject)literal);
        FeatureKey featureKey = objectKey.skipLast(1);
        String firstName = null;
        int i = 0;
        while (i < names.length) {
            String name;
            translated[i] = name = names[i];
            if (!StringUtils.isNullOrEmpty((String)name)) {
                ContextTranslationKeyImpl key;
                QualifiedName fqn;
                Iterator iterator;
                Iterable result;
                if (firstName == null) {
                    firstName = name;
                }
                String translation = null;
                if (isChangeScriptVariant) {
                    translation = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(name, isRussian);
                } else {
                    translation = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(name, !isRussian);
                    if (StringUtils.isNotEmpty((String)translation)) {
                        translation = name;
                    }
                }
                if (StringUtils.isNotEmpty((String)translation)) {
                    translated[i] = translation = this.fixKeyTranslationCase(name, translation);
                    hasDbViewTerm = true;
                    hasTranslation = true;
                } else if (firstName != null && firstName.equalsIgnoreCase(name)) {
                    ArrayList filter = Lists.newArrayList((Object[])new ISliceFilter[]{o -> name.equalsIgnoreCase(o.getName().getLastSegment())});
                    result = imdexProvider.getEObjectIndexByType(MdClassPackage.Literals.MD_OBJECT, (Collection)filter);
                    iterator = result.iterator();
                    if (iterator.hasNext()) {
                        desc = (IEObjectDescription)iterator.next();
                        MdObject mdObject = (MdObject)desc.getEObjectOrProxy();
                        if (mdObject.eIsProxy()) {
                            mdObject = (MdObject)EcoreUtil.resolve((EObject)mdObject, (EObject)literal);
                        }
                        if (StringUtils.isNotEmpty((String)(translation = this.getNameTranslation(mdObject, translationProvider, language)))) {
                            translated[i] = translation = this.fixKeyTranslationCase(name, translation);
                            hasTranslation = true;
                        }
                    }
                } else if (i == 1 && hasDbViewTerm && isChangeDefaultLanguage && (iterator = (result = imdexProvider.getEObjectIndexByType(DbViewPackage.Literals.DB_VIEW_ELEMENT, fqn = QualifiedName.create((String[])new String[]{names[0], names[1]}), true)).iterator()).hasNext()) {
                    EObject mdObject;
                    desc = (IEObjectDescription)iterator.next();
                    DbViewElement dbView = (DbViewElement)desc.getEObjectOrProxy();
                    if (dbView.eIsProxy()) {
                        dbView = (DbViewElement)EcoreUtil.resolve((EObject)dbView, (EObject)literal);
                    }
                    if ((mdObject = dbView.getMdObject()) instanceof MdObject) {
                        if (mdObject.eIsProxy()) {
                            mdObject = EcoreUtil.resolve((EObject)mdObject, (EObject)dbView);
                        }
                        if (StringUtils.isNotEmpty((String)(translation = this.getNameTranslation((MdObject)mdObject, translationProvider, language)))) {
                            translated[i] = translation = this.fixKeyTranslationCase(name, translation);
                            hasTranslation = true;
                        }
                    }
                }
                if (StringUtils.isNullOrEmpty((String)translation) && isChangeDefaultLanguage && StringUtils.isNotEmpty((String)(translation = translationProvider.getStoredTranslation((ContextTranslationKey)(key = new ContextTranslationKeyImpl(fullPath, featureKey.append(name).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, name)), language, new ITranslationStorageProvider.Storage.Type[0])))) {
                    translated[i] = translation = this.fixKeyTranslationCase(name, translation);
                    hasTranslation = true;
                }
            }
            ++i;
        }
        if (hasTranslation) {
            return Arrays.asList(FullNameContentProcessor.formatStringLiteralTranslation(literal, names, translated));
        }
        List<String> newLines = this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor);
        if (newLines.isEmpty()) {
            return lines;
        }
        return newLines;
    }

    private static String formatStringLiteralTranslation(StringLiteral literal, String[] names, String[] translated) {
        String content = (String)literal.lines(false).get(0);
        String name = String.join((CharSequence)".", names);
        String translatedName = String.join((CharSequence)".", translated);
        return content.replaceAll(name, translatedName);
    }

    private String getNameTranslation(MdObject mdObject, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (mdObject.eIsProxy()) {
            return null;
        }
        Pair names = this.namedEObjectNameProvider.getTranslatedName((EObject)mdObject, translationProvider);
        if (names != null && mdObject.getName().equalsIgnoreCase((String)names.getKey())) {
            return (String)names.getValue();
        }
        return null;
    }

    private String[] getNameSegments(StringLiteral literal) {
        String content = (String)literal.lines(true).get(0);
        if (StringUtils.isBlank((String)content)) {
            return new String[0];
        }
        String[] names = content.split("\\.");
        int i = 0;
        while (i < names.length) {
            if (StringUtils.isNotEmpty((String)names[i]) && !KeyTypeComputer.isKey((String)names[i])) {
                return new String[0];
            }
            ++i;
        }
        return names;
    }

    private static boolean isQualifiedName(String[] names) {
        if (names.length == 0) {
            return false;
        }
        int i = 0;
        while (i < names.length) {
            if (StringUtils.isBlank((String)names[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

