/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.KeyTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesCollector;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class KeysCollector
extends AbstractStringLiteralLinesCollector {
    public static final String[] SUPPORTED_TYPES = new String[]{"Key", "Keys", "FQN", "Area"};
    public static final String[] SKIP_TYPES = new String[]{"Standard", "Event", "Type", "Types", "Query", "Query-DCS", "Sort-Columns", "Full-name", "Method", "Query-param", "Replace-param", "Query-part", "Package-Query", "Union-Query", "QL-Union", "QL-Union-all"};
    public static final String KEYS_DELIM = " \t\n\r\f,|[].'\"(){}<>?!@=-;%/\\#&:\u2116$^*";
    @Inject
    protected IStringLiteralTypeComputer typeComputer;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, SUPPORTED_TYPES) && !this.typeComputer.containsAnyType(types, SKIP_TYPES);
    }

    @Override
    protected void collectContent(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        if (!context.getParameters().isCollectModelStrings()) {
            return;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return;
        }
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        if (project == null) {
            return;
        }
        List<String> keysList = this.getKeys(literal, true);
        if (keysList.isEmpty()) {
            return;
        }
        FeatureKey featureKey = context.getFeatureKeyProvider().getKey((EObject)literal);
        boolean isRussian = project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
        ContextDefCache contextDefCache = this.getContextDefCache(project, (EObject)literal);
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)literal, Environmental.class);
        Environments actualEnvs = this.bslPreferences.getLoadEnvs(project.getProject()).intersect(environmental.environments());
        for (String key : keysList) {
            boolean isKeyComputed = this.isKeyComputed(literal, key, keysList, contextDefCache, actualEnvs, isRussian);
            FeatureValue keyValue = this.createFeatureValue(literal, featureKey, file, key, isKeyComputed);
            HashMap nls = Maps.newHashMap();
            if (StringUtils.isNotEmpty((String)keyValue.getContextKey().getValue())) {
                nls.put(context.getDefaultLanguageCode(), keyValue.getContextKey().getValue());
            }
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)keyValue, (Map)nls, (Collection)context.getParameters().getLanguages());
            if (!TranslationUtils.isValidValueForCollectModelType((boolean)keyValue.isComputedValue(), (boolean)keyValue.isUnknown(), (boolean)keyValue.isTag(), (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) continue;
            context.getAddAction().accept(literal, keyValue);
        }
    }

    protected boolean isKeyComputed(StringLiteral literal, String key, List<String> keysList, ContextDefCache contextDefCache, Environments actualEnvs, boolean isRussian) {
        boolean isKeyComputed = false;
        if (StringUtils.isNotEmpty((String)this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isRussian))) {
            isKeyComputed = true;
        }
        if (!isKeyComputed && StringUtils.isNotEmpty((String)contextDefCache.getPropertyName(key, actualEnvs, keysList))) {
            isKeyComputed = true;
        }
        return isKeyComputed;
    }

    protected ContextDefCache getContextDefCache(IV8Project project, EObject context) {
        boolean isRussian = project.getScriptVariant().equals((Object)ScriptVariant.ENGLISH);
        return this.contextDefCacheProvider.getContextDefCache(context, isRussian);
    }

    protected List<String> getKeys(StringLiteral literal, boolean checkValidKey) {
        String literalContent = BslUtils.getString(literal);
        StringTokenizer tokenizer = new StringTokenizer(literalContent, KEYS_DELIM);
        if (!tokenizer.hasMoreTokens()) {
            return Collections.emptyList();
        }
        ArrayList<String> keysList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            if (StringUtils.isNotWord((String)key) || checkValidKey && !KeyTypeComputer.isKey((String)key)) continue;
            keysList.add(key);
        }
        return keysList;
    }

    protected FeatureValue createFeatureValue(StringLiteral literal, FeatureKey literalFeatureKey, IFile file, String key, boolean isKeyComputed) {
        return new PersistableFeatureValue(file, literalFeatureKey.skipLast(1).append(key).append("Key"), BslFeatureSettings.Literals.STRING_LITERAL__KEY, key, isKeyComputed);
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }
}

