/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.CollectorProperties;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralFeatureValueCollector;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class NstrCollector
implements TypedStringLiteralFeatureValueCollector {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private BslPreferences preferences;
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"NStr"});
    }

    @Override
    public void collect(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        boolean hasValue;
        if (!context.getParameters().isCollectInterfaceStrings()) {
            return;
        }
        Map<String, String> nls = BslUtils.getNlsLocalStrings(literal);
        if (nls.isEmpty() || StringUtils.isNullOrEmpty((String)nls.get(context.getDefaultLanguageCode()))) {
            return;
        }
        String nlsString = nls.get(context.getDefaultLanguageCode()).trim();
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        FeatureKey featureKey = context.getFeatureKeyProvider().getFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES, nlsString);
        PersistableFeatureValue featureValue = new PersistableFeatureValue((ContextTranslationKey)contextKey, false, this.getCodeContext((EObject)literal));
        FeaturesCollectorUtil.fillLocalStrings((Map)featureValue.getLocalStrings(), nls, (Collection)context.getParameters().getLanguages());
        if (context.getParameters().isKeepLanguagesMode()) {
            featureValue.getLocalStrings().clear();
            for (Map.Entry<String, String> entry : nls.entrySet()) {
                featureValue.getLocalStrings().putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        boolean bl = hasValue = StringUtils.isNotEmpty((String)nlsString) || !featureValue.getLocalStrings().isEmpty();
        if (!context.getParameters().isCollectEmptyValue() && !hasValue) {
            return;
        }
        if (!TranslationUtils.isValidValueForCollectModelType((boolean)featureValue.isComputedValue(), (boolean)featureValue.isUnknown(), (boolean)featureValue.isTag(), (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) {
            return;
        }
        context.getAddAction().accept(literal, featureValue);
    }

    private String getCodeContext(EObject object) {
        CollectorProperties prop = this.getCollectorProperties(object);
        if (prop == null || !prop.collectNstrCodeContext()) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
        int start = node.getStartLine() - prop.collectNstrCodeContextLinesBefore();
        if (start < 1) {
            start = 1;
        }
        int end = node.getEndLine() + prop.collectNstrCodeContextLinesAfter();
        INode contextNode = this.getContextNode((INode)node, start, end);
        String[] lines = contextNode.getText().split("\n", -1);
        if (end > contextNode.getTotalEndLine()) {
            end = contextNode.getTotalEndLine();
        }
        StringBuilder sb = new StringBuilder(MessageFormat.format("@{0}, {1}-{2}", String.valueOf(node.getStartLine()), String.valueOf(start), String.valueOf(end)));
        int shift = contextNode.getTotalStartLine() - 1;
        end -= shift;
        int i = (start -= shift) - 1;
        while (i >= 0 && i < lines.length && i < end) {
            sb.append(System.lineSeparator());
            String line = lines[i];
            if (!"\n".equals(BslUtils.SYSTEM_LINE_SEPARATOR) && line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            sb.append(lines[i]);
            ++i;
        }
        return sb.toString();
    }

    private INode getContextNode(INode node, int start, int end) {
        INode context = node;
        while (context.getParent() != null && (context.getTotalStartLine() >= start || context.getTotalEndLine() <= end)) {
            context = context.getParent();
        }
        return context;
    }

    private CollectorProperties getCollectorProperties(EObject context) {
        IProject project = this.resourceLookup.getProject(context);
        if (project != null) {
            return this.preferences.getCollectorProperties(project);
        }
        return null;
    }
}

