/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralFeatureValueCollector;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class NstrParamCollector
implements TypedStringLiteralFeatureValueCollector {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IResourceLookup resourceLookup;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"NStr"}) && this.typeComputer.containsAnyType(types, new String[]{"Replace-params"});
    }

    @Override
    public void collect(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        if (!context.getParameters().isCollectModelStrings()) {
            return;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return;
        }
        String fullPath = file.getFullPath().toString();
        Map<String, String> nls = BslUtils.getNlsLocalStrings(literal);
        String nlsString = nls.get(context.getDefaultLanguageCode());
        if (StringUtils.isNullOrEmpty((String)nlsString)) {
            return;
        }
        String[] params = Utils.getParamsFromNls((String)nlsString);
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            if (!StringUtils.isNullOrEmpty((String)param)) {
                this.collectStringSingleParam(literal, fullPath, context, param);
            }
            ++i;
        }
    }

    private void collectStringSingleParam(StringLiteral literal, String fullPath, CollectingContext context, String param) {
        if (StringUtils.isNotEmpty((String)param)) {
            HashMap nls = Maps.newHashMap();
            FeatureKey featureKey = context.getFeatureKeyProvider().getKey((EObject)literal).skipLast(1);
            PersistableFeatureValue paramValue = new PersistableFeatureValue(fullPath, featureKey.append(param).append("Param"), BslFeatureSettings.Literals.STRING_LITERAL__PARAM, param, false);
            nls.put(context.getDefaultLanguageCode(), param);
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)paramValue, (Map)nls, (Collection)context.getParameters().getLanguages());
            if (TranslationUtils.isValidValueForCollectModelType((boolean)paramValue.isComputedValue(), (boolean)false, (boolean)paramValue.isTag(), (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) {
                context.getAddAction().accept(literal, paramValue);
            }
        }
    }
}

