/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.NstrContentProcessor;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NstrParamContentProcessor
extends NstrContentProcessor {
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    private IConverterService converterService;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"NStr"}) && this.typeComputer.containsAnyType(types, new String[]{"Replace-params"});
    }

    @Override
    protected String formatNstrContent(Map<String, String> nstrContent, StringLiteral literal, String sourceString, ContextTranslationKey contextKey, IProjectTranslationProvider translationProvider, TranslateLanguage defaultLanguage) {
        Map params;
        if (this.isChangeDefaultLanguage(translationProvider) && !(params = Utils.getParamsMapFromNls((String)sourceString)).isEmpty()) {
            FeatureKey featureKeyPreffix = contextKey.getFeatureKey().skipLast(2);
            HashMap paramTranslations = Maps.newHashMap();
            String fullPath = contextKey.getFullPath();
            boolean isRussian = this.getScriptVariant(translationProvider).equals((Object)ScriptVariant.RUSSIAN);
            IProject project = translationProvider.getProject().getSourceProject().getProject();
            for (Map.Entry entry : params.entrySet()) {
                IConverterManager manager;
                TranslateLanguage language;
                String param = (String)entry.getKey();
                if (StringUtils.isNullOrEmpty((String)param)) continue;
                ContextTranslationKeyImpl paramContextKey = new ContextTranslationKeyImpl(fullPath, featureKeyPreffix.append(param).append("Param"), BslFeatureSettings.Literals.STRING_LITERAL__PARAM, param);
                String translation = translationProvider.getTranslation((EObject)literal, (ContextTranslationKey)paramContextKey, defaultLanguage);
                if (StringUtils.isNotEmpty((String)translation)) {
                    paramTranslations.put(param, ((String)entry.getValue()).replace((CharSequence)entry.getKey(), translation));
                } else if (this.isChangeScriptVariant(translationProvider) && StringUtils.isNotEmpty((String)(translation = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(param, isRussian)))) {
                    paramTranslations.put(param, ((String)entry.getValue()).replace((CharSequence)entry.getKey(), translation));
                }
                if (!this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() || !(language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(defaultLanguage.getLanguageCode())) continue;
                Path path = new Path(EcoreUtil.getURI((EObject)literal).trimFragment().toPlatformString(true));
                manager.updateStringLiteralParams(path.makeRelativeTo(project.getFullPath()), param, translation);
            }
            for (Map.Entry<Object, Object> entry : nstrContent.entrySet()) {
                String nstrTranslation = (String)entry.getValue();
                for (Map.Entry translationEntry : paramTranslations.entrySet()) {
                    String source = (String)params.get(translationEntry.getKey());
                    nstrTranslation = nstrTranslation.replace(source, (CharSequence)translationEntry.getValue());
                }
                entry.setValue(nstrTranslation);
            }
        }
        return super.formatNstrContent(nstrContent, literal, sourceString, contextKey, translationProvider, defaultLanguage);
    }

    private ScriptVariant getScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getScriptVariant();
    }

    private boolean isChangeDefaultLanguage(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeDefaultLanguage();
    }

    private boolean isChangeScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeScriptVariant();
    }
}

