/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class QlUnionContentProcessor
implements TypedStringLiteralContentProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"QL-Union", "QL-Union-all"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList lines = literal.lines(false);
        if (lines.isEmpty()) {
            return lines;
        }
        ScriptVariant sv = translationProvider.getProject().getScriptVariant();
        return QlUnionContentProcessor.replaceLines((List<String>)lines, sv);
    }

    public static List<String> replaceLines(List<String> lines, ScriptVariant sv) {
        ArrayList<String> newLines = new ArrayList<String>(lines.size());
        for (String content : lines) {
            if (sv.equals((Object)ScriptVariant.RUSSIAN) && content.trim().equals("UNION ALL")) {
                newLines.add(content.replace("UNION ALL", "\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c \u0412\u0421\u0415"));
                continue;
            }
            if (sv.equals((Object)ScriptVariant.RUSSIAN) && content.trim().equals("UNION")) {
                newLines.add(content.replace("UNION", "\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c"));
                continue;
            }
            if (sv.equals((Object)ScriptVariant.ENGLISH) && content.trim().equals("\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c \u0412\u0421\u0415")) {
                newLines.add(content.replace("\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c \u0412\u0421\u0415", "UNION ALL"));
                continue;
            }
            if (sv.equals((Object)ScriptVariant.ENGLISH) && content.trim().equals("\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c")) {
                newLines.add(content.replace("\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c", "UNION"));
                continue;
            }
            newLines.add(content);
        }
        return newLines;
    }
}

