/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.ContentTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.TypeValidator;
import com.e1c.langtool.v8.dt.bsl.stringliteral.Messages;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.util.CancelIndicator;

public class QlUnionTypeComputer
implements ContentTypeComputer,
TypeValidator {
    public int order() {
        return 9000;
    }

    public IStatus validate(StringLiteral literal, List<String> content, CancelIndicator monitor) {
        if (!this.containsOnlyUnion(content)) {
            return new Status(4, "com.e1c.langtool.v8.dt.bsl", Messages.QlUnionTypeComputer_Literal_contains_not_only_UNION_keyword);
        }
        return Status.OK_STATUS;
    }

    public String getSupportedType() {
        return "QL-Union";
    }

    public boolean computeIsValidForSupportedType(@NonNull StringLiteral literal, @NonNull List<String> content, Collection<LiteralType> contextTypes) {
        return this.containsOnlyUnion(content);
    }

    private boolean containsOnlyUnion(List<String> content) {
        boolean found = false;
        for (String line : content) {
            if ((line = line.trim()).startsWith("//") || line.isBlank() || line.equals(";")) continue;
            if (line.startsWith("UNION") || line.startsWith("\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c")) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }
}

