/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralCollector;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.CancelIndicator;

public class QueryCollector
extends DefaultStringLiteralCollector {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, LangToolDefaults.QUERY);
    }

    @Override
    protected boolean isLinesComputedByDefault() {
        return true;
    }

    @Override
    protected void collectContent(StringLiteral literal, CollectingContext context, IProgressMonitor monitor) {
        if (!context.getParameters().isCollectModelStrings()) {
            return;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return;
        }
        QuerySchema query = this.dependentModelProvider.getQuerySchema((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, this::getQueryText, (CancelIndicator)new MonitorBasedCancelIndicator(monitor));
        TranslationSource source = TranslationUtils.getTranslationSource((Object)query);
        if (source != null) {
            try {
                try {
                    context.getCollectingService().forEachCollected(source, context.getParameters(), monitor, context.getAddAction());
                }
                catch (Throwable e) {
                    String literalContent = BslUtils.getString(literal);
                    String message = MessageFormat.format("Cannot collect QL: {0} with text:\n{1}", EcoreUtil.getURI((EObject)literal), literalContent);
                    CollectingException e2 = new CollectingException(message, e);
                    BslPlugin.logError((Throwable)e2);
                    context.getParameters().getErrors().add(e2);
                    QlUtil.cleanUpQueryCache((QuerySchema)query);
                }
            }
            finally {
                QlUtil.cleanUpQueryCache((QuerySchema)query);
            }
        } else if (!(query != null || literal.getLines().size() <= 1 && BslUtils.getString(literal).trim().isBlank())) {
            super.collectContent(literal, context, monitor);
        }
    }

    @Override
    protected boolean isComputedValue(StringLiteral literal, String content, CollectingContext context) {
        return false;
    }

    @Override
    protected boolean needToCollectByKeys() {
        return false;
    }

    @Override
    protected ContextTranslationKey createLiteralLinesContextTranslationKey(IFile file, FeatureKey featureKey, String content) {
        featureKey = featureKey.skipLast(1).append("String").append(content.trim()).append(featureKey.getLastSegment());
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES, content);
    }

    private String getQueryText(EObject object, EStructuralFeature feautre) {
        StringLiteral literal = (StringLiteral)object;
        return BslUtils.getQueryText(literal);
    }
}

