/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.stringliteral.QlUnionContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.ReplaceParamsContentProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.QueryFieldTranslationCache;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.ql.translator.QlTextEditor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ide.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.util.CancelIndicator;

public class QueryContentProcessor
extends DefaultStringLiteralContentProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private ReplaceParamsContentProcessor replaceParamsContentProcessor;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, LangToolDefaults.QUERY);
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList sourceLines;
        block16: {
            sourceLines = literal.lines(false);
            if (this.isChangeDefaultLanguage(translationProvider) || this.isChangeScriptVariant(translationProvider)) {
                List<String> newLines;
                boolean priority = this.isStringLiteralLinesFullTranslationStoredPriority(literal);
                List<String> list = newLines = priority ? this.getLineTranslation(literal, (List<String>)sourceLines, types, translationProvider, language, monitor) : this.getContextLineTranslation(literal, (List<String>)sourceLines, types, translationProvider, language, monitor);
                if (!newLines.isEmpty()) {
                    return newLines;
                }
                IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
                if (file == null) {
                    return sourceLines;
                }
                String sourceQueryText = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)sourceLines);
                String actualQueryText = BslUtils.getQueryText(literal);
                boolean processTrimed = actualQueryText.length() != sourceQueryText.length();
                QuerySchema query = this.dependentModelProvider.getQuerySchema((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, (s, f) -> actualQueryText, monitor);
                if (query == null) {
                    BslPlugin.log(BslPlugin.createWarningStatus("Can't create bls query object from text: \n\n" + sourceQueryText));
                    return super.process(literal, types, translationProvider, language, monitor);
                }
                QlTextEditor qlProcessor = QlTextEditor.create((IProjectTranslationProvider)translationProvider, (QuerySchema)query, (boolean)true);
                try {
                    qlProcessor.process((IProgressMonitor)new CancelIndicatorProgressMonitor(monitor));
                    String queryText = qlProcessor.getProcessedText();
                    if (monitor.isCanceled() || queryText == null) break block16;
                    if (processTrimed) {
                        queryText = sourceQueryText.replace(actualQueryText, queryText);
                    }
                    List<String> lines = Arrays.asList(queryText.split("\n", -1));
                    if (this.typeComputer.containsAnyType(types, new String[]{"Union-Query"})) {
                        lines = this.replaceQlKeywordUnion(lines, translationProvider);
                    }
                    if (this.typeComputer.containsAnyType(types, new String[]{"Replace-params"})) {
                        lines = this.replaceReplaceParams(literal, types, lines, translationProvider, monitor);
                    }
                    if (sourceLines.size() == lines.size()) {
                        if (!qlProcessor.getFieldMaps().isEmpty()) {
                            QueryFieldTranslationCache cache = (QueryFieldTranslationCache)translationProvider.getCache(QueryFieldTranslationCache.class);
                            Environmental env = (Environmental)EcoreUtil2.getContainerOfType((EObject)literal, Environmental.class);
                            cache.put(literal.eResource(), env, (List<Map<String, String>>)qlProcessor.getFieldMaps());
                        }
                        List<String> list2 = lines;
                        return list2;
                    }
                    try {
                        throw new RuntimeException(MessageFormat.format("Query source lines: {0} and traslated into {1} lines", sourceLines.size(), lines.size()));
                    }
                    catch (Throwable e) {
                        Object message = e.getMessage();
                        if (StringUtils.isNullOrEmpty((String)message)) {
                            message = "";
                        }
                        URI uri = EcoreUtil.getURI((EObject)literal);
                        message = "Cannot translate QL String literal: " + String.valueOf(uri) + "\n\n" + (String)message;
                        IStatus status = BslPlugin.createErrorStatus((String)message, e);
                        BslPlugin.log(status);
                    }
                }
                finally {
                    QlUtil.cleanUpQueryCache((QuerySchema)query);
                    this.dependentModelProvider.unload(query);
                }
            }
        }
        return sourceLines;
    }

    @Override
    protected boolean needToTranslateByKeys() {
        return false;
    }

    @Override
    protected ContextTranslationKey createLinesTranslationKey(StringLiteral literal, String sourceString) {
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES);
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        featureKey = featureKey.skipLast(1).append("String").append(sourceString.trim()).append(featureKey.getLastSegment());
        return new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES, sourceString.trim());
    }

    private List<String> replaceQlKeywordUnion(List<String> lines, IProjectTranslationProvider translationProvider) {
        if (!this.isChangeScriptVariant(translationProvider)) {
            return lines;
        }
        return QlUnionContentProcessor.replaceLines(lines, this.getScriptVariant(translationProvider));
    }

    private List<String> replaceReplaceParams(StringLiteral literal, Collection<LiteralType> types, List<String> lines, IProjectTranslationProvider translationProvider, CancelIndicator monitor) {
        if (!this.isChangeDefaultLanguage(translationProvider)) {
            return lines;
        }
        TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
        return this.replaceParamsContentProcessor.process(literal, types, lines, translationProvider, language, monitor);
    }

    private ScriptVariant getScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getScriptVariant();
    }
}

