/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ql.model.FunctionExpression;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractQueryPartProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.ql.QlPartStringParser;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.util.CancelIndicator;

public class QueryPartContentProcessor
extends AbstractQueryPartProcessor
implements TypedStringLiteralContentProcessor {
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Query-part"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        String translation;
        FeatureKey featureKey;
        ContextTranslationKey contextKey;
        EList lines = literal.lines(false);
        if (!this.isChangeDefaultLanguage(translationProvider) || !this.isChangeScriptVariant(translationProvider)) {
            return lines;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return lines;
        }
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        if (project == null) {
            return lines;
        }
        String literalContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)lines);
        List<String> newLines = this.getLineContextTranslation(literal, literalContent, contextKey = this.createLiteralLinesContextTranslationKey(file, featureKey = this.translationKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES), literalContent), translationProvider, language, monitor);
        if (!newLines.isEmpty()) {
            return newLines;
        }
        if (monitor.isCanceled()) {
            return lines;
        }
        featureKey = featureKey.skipLast(1);
        boolean isRussian = this.getScriptVariant(translationProvider).equals((Object)ScriptVariant.RUSSIAN);
        Document document = new Document(literalContent);
        MultiTextEdit edit = new MultiTextEdit();
        int total = 0;
        QlPartStringParser parser = this.getQlPartStringParser(literalContent);
        Iterator iterator = parser.iterator();
        while (iterator.hasNext()) {
            ContextTranslationKey keyValue;
            String translation2;
            if (monitor.isCanceled()) {
                return lines;
            }
            Token token = (Token)iterator.next();
            ++total;
            if (parser.isSkipToken(token)) continue;
            if (parser.isKeyword(token)) {
                List keywords = parser.getKeyword(token);
                this.replaceKeyword((IDocument)document, edit, token, keywords, translationProvider);
                continue;
            }
            if (parser.isStringLiteral(token)) {
                String literalText = this.getStringLiteralContent(token, parser).trim();
                if (StringUtils.isBlank((String)literalText) || StringUtils.isNotWord((String)literalText) || !StringUtils.isNotEmpty((String)(translation2 = translationProvider.getStoredTranslation(keyValue = this.createStringLiteralContextTranslationKey(file, featureKey, literalText), language, new ITranslationStorageProvider.Storage.Type[0])))) continue;
                translation2 = translation2.replaceAll("\"", "\"\"");
                if (!literalText.equals(token.getText())) {
                    translation2 = token.getText().replace(literalText, translation2);
                }
                this.addReplace((IDocument)document, edit, token, translation2);
                continue;
            }
            if (parser.isComment(token)) {
                String comment = this.getCommentContent(token, parser).trim();
                if (StringUtils.isBlank((String)comment) || StringUtils.isNotWord((String)comment) || !StringUtils.isNotEmpty((String)(translation2 = translationProvider.getStoredTranslation(keyValue = this.createCommentContextTranslationKey(file, featureKey, comment), language, new ITranslationStorageProvider.Storage.Type[0])))) continue;
                translation2 = token.getText().replace(comment, translation2);
                this.addReplace((IDocument)document, edit, token, translation2);
                continue;
            }
            if (parser.isFunction(token) && parser.getFunction(token, (EObject)literal) != null) {
                FunctionExpression func = parser.getFunction(token, (EObject)literal);
                String funcName = isRussian ? func.getNameRu() : func.getName();
                this.addReplace((IDocument)document, edit, token, funcName);
                continue;
            }
            String key = this.getKey(token, parser);
            if (key == null) continue;
            keyValue = this.createKeyContextTranslationKey(file, featureKey, key);
            translation2 = translationProvider.getStoredTranslation(keyValue, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
            if (StringUtils.isNullOrEmpty((String)translation2)) {
                translation2 = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(key, isRussian);
            }
            if (StringUtils.isNullOrEmpty((String)translation2)) {
                translation2 = translationProvider.getStoredTranslation(keyValue, language, new ITranslationStorageProvider.Storage.Type[0]);
            }
            if (!StringUtils.isNotEmpty((String)translation2)) continue;
            if (!key.equals(token.getText())) {
                translation2 = token.getText().replace(key, translation2);
            }
            this.addReplace((IDocument)document, edit, token, translation2);
        }
        if (!edit.hasChildren() && total > 1 && StringUtils.isNotEmpty((String)(translation = translationProvider.getTranslation((EObject)literal, contextKey, language)))) {
            translation = this.formatTranslationBySource(literal, literalContent, translation);
            return Lists.newArrayList((Object[])translation.replace("\r", "").split("\n", -1));
        }
        try {
            edit.apply((IDocument)document);
            if (monitor.isCanceled()) {
                return lines;
            }
            return Arrays.asList(document.get().split("\n", -1));
        }
        catch (BadLocationException | MalformedTreeException e) {
            String message = MessageFormat.format("Cannot translate string literal: {0}", EcoreUtil.getURI((EObject)literal));
            BslPlugin.log(BslPlugin.createErrorStatus(message, e));
            return lines;
        }
    }

    private void replaceKeyword(IDocument document, MultiTextEdit edit, Token token, List<Keyword> keywords, IProjectTranslationProvider translationProvider) {
        if (!this.isChangeScriptVariant(translationProvider)) {
            return;
        }
        if (document.getNumberOfLines() < token.getLine()) {
            return;
        }
        if ("null".equalsIgnoreCase(token.getText())) {
            return;
        }
        int i = 0;
        while (i < keywords.size()) {
            String newKeword;
            EObject parent;
            Keyword keyword = keywords.get(i);
            if ((i >= keywords.size() - 1 || (parent = keyword.eContainer()) instanceof Alternatives && (parent.eContents().indexOf((Object)keyword) <= 0 || parent.eContents().get(0) instanceof Keyword)) && (newKeword = QueryPartContentProcessor.getReplaceText(keyword, this.getScriptVariant(translationProvider))) != null) {
                this.addReplace(document, edit, token, newKeword);
                return;
            }
            ++i;
        }
    }

    public static String getReplaceText(Keyword keyword, ScriptVariant sv) {
        EObject container = keyword.eContainer();
        if (container != null && container instanceof Alternatives && !container.eContents().isEmpty()) {
            EObject replaceObject;
            EList eContents = container.eContents();
            int index = -1;
            int shift = 0;
            if (eContents.size() > 2) {
                index = eContents.indexOf((Object)keyword);
                if (eContents.get(0) instanceof RuleCall && index > 0) {
                    for (EObject item : eContents) {
                        if (item instanceof Keyword) break;
                        ++shift;
                    }
                }
                if (shift > 0) {
                    int i = index;
                    while (i > 0) {
                        EObject item = (EObject)eContents.get(i);
                        if (item instanceof Keyword && "NULL".equals(((Keyword)item).getValue())) {
                            --shift;
                        }
                        --i;
                    }
                }
                index -= shift;
            }
            if (index <= 1) {
                index = 0;
            } else if (index % 2 > 0) {
                --index;
            }
            if (sv == ScriptVariant.RUSSIAN && eContents.size() > 1) {
                ++index;
            }
            if ((replaceObject = (EObject)eContents.get(index + shift)) instanceof Keyword) {
                return ((Keyword)replaceObject).getValue();
            }
        }
        return null;
    }

    protected void addReplace(IDocument document, MultiTextEdit edit, Token token, String newKeword) {
        int lineOffset;
        if (newKeword == null) {
            return;
        }
        try {
            lineOffset = document.getLineOffset(token.getLine() - 1);
        }
        catch (BadLocationException e) {
            return;
        }
        int offset = lineOffset + token.getCharPositionInLine();
        int length = token.getText().length();
        edit.addChild((TextEdit)new ReplaceEdit(offset, length, newKeword));
    }

    private List<String> getLineContextTranslation(StringLiteral literal, String sourceString, ContextTranslationKey key, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        String translation = translationProvider.getStoredTranslation(key, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotEmpty((String)translation)) {
            translation = this.formatTranslationBySource(literal, sourceString, translation);
            Object[] lines = translation.replace("\r", "").split("\n", -1);
            return Lists.newArrayList((Object[])lines);
        }
        return Collections.emptyList();
    }

    private String formatTranslationBySource(StringLiteral literal, String sourceString, String translation) {
        String sourceTrimed = sourceString.trim();
        if (translation.split("\n", -1).length < literal.getLines().size() && sourceTrimed.split("\n", -1).length < literal.getLines().size() || sourceString.length() != sourceTrimed.length() && translation.trim().length() == translation.length()) {
            return sourceString.replace(sourceTrimed, translation);
        }
        return translation;
    }

    private ScriptVariant getScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getScriptVariant();
    }

    private boolean isChangeDefaultLanguage(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeDefaultLanguage();
    }

    private boolean isChangeScriptVariant(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().isChangeScriptVariant();
    }
}

