/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.AbstractStringLiteralLinesProcessor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class ReplaceParamsContentProcessor
extends AbstractStringLiteralLinesProcessor {
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return types.size() == 1 && this.typeComputer.containsAnyType(types, new String[]{"Replace-params"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        List<String> newLines;
        EList lines = literal.lines(false);
        boolean priority = this.isStringLiteralLinesFullTranslationStoredPriority(literal);
        List<String> list = newLines = priority ? this.getLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor) : this.getContextLineTranslation(literal, (List<String>)lines, types, translationProvider, language, monitor);
        if (!newLines.isEmpty()) {
            return newLines;
        }
        return this.process(literal, types, (List<String>)lines, translationProvider, language, monitor);
    }

    public List<String> process(StringLiteral literal, Collection<LiteralType> types, List<String> lines, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        List<String> newLines2;
        if (!this.isChangeDefaultLanguage(translationProvider)) {
            return lines;
        }
        ArrayList<String> newLines = new ArrayList<String>(lines.size());
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return lines;
        }
        String fullPath = file.getFullPath().toString();
        FeatureKey featureKey = this.translationKeyProvider.getKey((EObject)literal).skipLast(1);
        boolean hasTranslation = false;
        for (String line : lines) {
            if (monitor.isCanceled()) {
                return lines;
            }
            Map params = Utils.getParamsMapFromNls((String)line);
            if (!params.isEmpty()) {
                String newLine = line;
                for (Map.Entry entry : params.entrySet()) {
                    ContextTranslationKey paramKey = this.createStringSingleParam(literal, featureKey, fullPath, (String)entry.getKey());
                    String translation = translationProvider.getStoredTranslation(paramKey, language, new ITranslationStorageProvider.Storage.Type[0]);
                    if (StringUtils.isNotEmpty((String)translation)) {
                        hasTranslation = true;
                    }
                    newLine = this.getReplacedParameter(newLine, (String)entry.getKey(), (String)entry.getValue(), translation);
                }
                newLines.add(newLine);
                continue;
            }
            newLines.add(line);
        }
        if (!hasTranslation && !(newLines2 = this.getLineTranslation(literal, lines, types, translationProvider, language, monitor)).isEmpty()) {
            return newLines2;
        }
        return newLines;
    }

    private String getReplacedParameter(String sourceLine, String param, String paramPattern, String translation) {
        if (StringUtils.isNullOrEmpty((String)translation)) {
            return sourceLine;
        }
        String newPattern = paramPattern.replace(param, translation);
        return sourceLine.replace(paramPattern, newPattern);
    }

    private ContextTranslationKey createStringSingleParam(StringLiteral literal, FeatureKey featureKey, String fullPath, String param) {
        return new ContextTranslationKeyImpl(fullPath, featureKey.append(param).append("Param"), BslFeatureSettings.Literals.STRING_LITERAL__PARAM, param);
    }
}

