/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FunctionStyleCreator;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.OperatorStyleCreator;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.validation.stringliterals.IAvailableStringLiteralServiceProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.TypeDescription;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.md.MdUtil;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultFormsNameProvider;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.MethodNameContentProcessor;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public class StandardContentProcessor
extends DefaultStringLiteralContentProcessor {
    private static final String EMPTY_REF = "EmptyRef";
    private static final String EMPTY_REF_RU = "\u041f\u0443\u0441\u0442\u0430\u044f\u0421\u0441\u044b\u043b\u043a\u0430";
    private static final Collection<String> FORM_METHOD_NAMES = Set.of("getform", "\u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u0444\u043e\u0440\u043c\u0443", "openform", "\u043e\u0442\u043a\u0440\u044b\u0442\u044c\u0444\u043e\u0440\u043c\u0443", "openformmodal", "\u043e\u0442\u043a\u0440\u044b\u0442\u044c\u0444\u043e\u0440\u043c\u0443\u043c\u043e\u0434\u0430\u043b\u044c\u043d\u043e");
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private IAvailableStringLiteralServiceProvider stringLiteralsService;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Standard", "Form", "Template", "Predefined", "Object-attribute", "Form-attribute"}) && !this.typeComputer.containsAnyType(types, new String[]{"Non-word"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        if (!this.isChangeDefaultLanguage(translationProvider) && !this.isChangeScriptVariant(translationProvider)) {
            return literal.lines(false);
        }
        String translation = this.computeTranslatedString(literal, BslFeatureSettings.Literals.STRING_LITERAL__LINES, translationProvider, language);
        if (StringUtils.isNotEmpty((String)translation)) {
            String[] lines = translation.replace("\r", "").split("\n", -1);
            return Arrays.asList(lines);
        }
        return super.process(literal, types, translationProvider, language, monitor);
    }

    private Triple<EObject, List<Expression>, Integer> getContextData(StringLiteral literal) {
        Invocation inv = (Invocation)EcoreUtil2.getContainerOfType((EObject)literal, Invocation.class);
        if (inv != null) {
            return Tuples.create((Object)inv, (Object)inv.getParams(), (Object)inv.getParams().indexOf((Object)literal));
        }
        OperatorStyleCreator osc = (OperatorStyleCreator)EcoreUtil2.getContainerOfType((EObject)literal, OperatorStyleCreator.class);
        if (osc != null && osc.getType() != null) {
            return Tuples.create((Object)osc, (Object)osc.getParams(), (Object)osc.getParams().indexOf((Object)literal));
        }
        if (osc != null && osc.getType() == null) {
            return Tuples.create((Object)osc, (Object)osc.getParams(), (Object)-1);
        }
        FunctionStyleCreator fsc = (FunctionStyleCreator)EcoreUtil2.getContainerOfType((EObject)literal, FunctionStyleCreator.class);
        if (fsc != null && fsc.getTypes() != null && !fsc.getTypes().isEmpty()) {
            return Tuples.create((Object)fsc, Arrays.asList(fsc.getTypeNameExpression()), (Object)0);
        }
        if (fsc != null && (fsc.getTypes() == null || fsc.getTypes().isEmpty())) {
            return Tuples.create((Object)fsc, Arrays.asList(fsc.getTypeNameExpression()), (Object)-1);
        }
        return null;
    }

    private String computeTranslatedString(StringLiteral object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        List referenceDescriptions;
        if (!stringFeature.equals(BslFeatureSettings.Literals.STRING_LITERAL__LINES)) {
            return null;
        }
        boolean isChangeScriptVariant = this.isChangeScriptVariant(translationProvider);
        boolean isChangeDefaultLanguage = this.isChangeDefaultLanguage(translationProvider);
        if (!isChangeScriptVariant && !isChangeDefaultLanguage) {
            return null;
        }
        Triple<EObject, List<Expression>, Integer> data = this.getContextData(object);
        if (data == null || (Integer)data.getThird() == -1) {
            return null;
        }
        String literalString = BslUtils.getString(object);
        String[] parts = literalString.split("\\.");
        CharSequence[] translationParts = new String[parts.length];
        System.arraycopy(parts, 0, translationParts, 0, parts.length);
        boolean isRussian = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        String methodName = null;
        if (data.getFirst() instanceof Invocation) {
            Invocation inv = (Invocation)data.getFirst();
            methodName = inv.getMethodAccess().getName().toLowerCase();
        }
        if ((referenceDescriptions = this.stringLiteralsService.getReferenceDescriptions(data, this.scopeProvider)) != null && !referenceDescriptions.isEmpty()) {
            Object translation;
            boolean[] transladedParts = new boolean[parts.length];
            for (IReferenceDescription descr : referenceDescriptions) {
                Optional<EObject> option;
                String name;
                int i;
                URI uri;
                IBmModel model;
                if (parts.length <= descr.getIndexInList() || (model = this.modelManager.getModel(uri = descr.getTargetEObjectUri())) == null) continue;
                EObject targetObject = EcoreUtil.resolve((EObject)model.getEngine().resolve(uri, EcorePackage.Literals.EOBJECT), (EObject)object);
                if (targetObject instanceof MdObject) {
                    this.computeDefaultNamesTranslation(translationProvider, (MdObject)targetObject, parts, (String[])translationParts, transladedParts, descr.getIndexInList());
                }
                if ((translation = this.namedEObjectNameProvider.getTranslatedName(targetObject, translationProvider)) != null && parts.length == 1 && ((String)translation.getKey()).equalsIgnoreCase(parts[0])) {
                    return (String)translation.getValue();
                }
                if (translation != null && parts[descr.getIndexInList()].equalsIgnoreCase((String)translation.getKey())) {
                    translationParts[descr.getIndexInList()] = (String)translation.getValue();
                    transladedParts[descr.getIndexInList()] = true;
                }
                if (targetObject instanceof MdObject) {
                    if (parts.length == 3 && (EMPTY_REF_RU.equalsIgnoreCase(parts[2]) || EMPTY_REF.equalsIgnoreCase(parts[2])) && translationProvider.getProject().isChangeScriptVariant()) {
                        translationParts[2] = isRussian ? EMPTY_REF_RU : EMPTY_REF;
                        transladedParts[2] = true;
                    }
                    if (FORM_METHOD_NAMES.contains(methodName) && translationProvider.getProject().isChangeScriptVariant()) {
                        boolean isSourceRussian;
                        boolean bl = isSourceRussian = !isRussian;
                        if (parts.length == 3) {
                            lastSegment = parts[2];
                            formNamesSource = DefaultFormsNameProvider.getDefaultMdObjectFormNames(targetObject.eClass(), isSourceRussian);
                            formNamesDest = DefaultFormsNameProvider.getDefaultMdObjectFormNames(targetObject.eClass(), isRussian);
                            i = 0;
                            while (i < formNamesSource.length) {
                                name = formNamesSource[i];
                                if (lastSegment.equalsIgnoreCase(name)) {
                                    translationParts[2] = formNamesDest[i];
                                    transladedParts[2] = true;
                                    break;
                                }
                                ++i;
                            }
                        } else if (parts.length == 1) {
                            lastSegment = parts[0];
                            formNamesSource = DefaultFormsNameProvider.getDefaultFormNames(isSourceRussian);
                            formNamesDest = DefaultFormsNameProvider.getDefaultFormNames(isRussian);
                            i = 0;
                            while (i < formNamesSource.length) {
                                name = formNamesSource[i];
                                if (lastSegment.equalsIgnoreCase(name)) {
                                    translationParts[0] = formNamesDest[i];
                                    transladedParts[0] = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                }
                if (descr.getIndexInList() != referenceDescriptions.size() - 1 || referenceDescriptions.size() >= parts.length || !(option = this.getDescription(targetObject)).isPresent()) continue;
                TypeDescription typeDescription = (TypeDescription)option.get();
                EList types = typeDescription.getTypes();
                Property property = null;
                i = descr.getIndexInList() + 1;
                while (i < parts.length) {
                    com.e1c.langtool.common.Pair translationPair;
                    if (property != null) {
                        types = property.getTypes();
                    }
                    if (!types.isEmpty() && StringUtils.isNotEmpty((String)parts[i]) && (property = this.getProperty((List<TypeItem>)types, name = parts[i], (EObject)object)) != null && (translationPair = this.namedEObjectNameProvider.getTranslatedName((EObject)property, translationProvider)) != null && name.equalsIgnoreCase((String)translationPair.getKey())) {
                        translationParts[i] = (String)translationPair.getValue();
                        transladedParts[i] = true;
                    }
                    ++i;
                }
            }
            if (this.isNeedTranslateKeys(transladedParts)) {
                IFile file = this.resourceLookup.getPlatformResource((EObject)object);
                FeatureKey featureKey = this.translationKeyProvider.getKey((EObject)object);
                int i = 0;
                while (i < transladedParts.length) {
                    String key;
                    ContextTranslationKey contextKey;
                    if (!transladedParts[i] && StringUtils.isNotEmpty((String)(translation = translationProvider.getStoredTranslation(contextKey = this.createFeatureValue(object, featureKey, file, key = parts[i]), language, new ITranslationStorageProvider.Storage.Type[0])))) {
                        translationParts[i] = translation;
                    }
                    ++i;
                }
            }
        } else {
            return null;
        }
        return String.join((CharSequence)".", translationParts);
    }

    private boolean isNeedTranslateKeys(boolean[] transladedParts) {
        int i = 0;
        while (i < transladedParts.length) {
            if (transladedParts[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Optional<EObject> getDescription(EObject targetObject) {
        EList eContents = targetObject.eContents();
        if (!eContents.isEmpty()) {
            return eContents.stream().filter(t -> t instanceof TypeDescription).findFirst();
        }
        return Optional.empty();
    }

    private Property getProperty(List<TypeItem> types, String name, EObject object) {
        Pair properties;
        Collection allProperties = this.dynamicFeatureAccessComputer.getAllProperties(types, ((StringLiteral)object).eResource());
        if (!allProperties.isEmpty() && (properties = (Pair)allProperties.iterator().next()) != null) {
            for (Property p : (Collection)properties.getFirst()) {
                if (!name.equalsIgnoreCase(p.getNameRu()) && !name.equalsIgnoreCase(p.getName())) continue;
                return p;
            }
        }
        return null;
    }

    private void computeDefaultNamesTranslation(IProjectTranslationProvider translationProvider, MdObject targetObject, String[] parts, String[] translationParts, boolean[] transladedParts, int maxUpdateIndex) {
        if (parts.length < 2 || !translationProvider.getProject().isChangeScriptVariant()) {
            return;
        }
        QualifiedName fqn = MdUtil.getFullyQualifiedName((MdObject)targetObject);
        QualifiedName fqnRu = MdUtil.getFullyQualifiedNameRu((MdObject)targetObject);
        if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
            int i = 0;
            while (i <= maxUpdateIndex && i < fqn.getSegmentCount()) {
                transladedParts[i] = true;
                if (translationParts[i].equalsIgnoreCase(fqn.getSegment(i))) {
                    translationParts[i] = fqnRu.getSegment(i);
                } else if (i == 0 && maxUpdateIndex == 1 && parts.length > 1 && targetObject.getName().equalsIgnoreCase(parts[1]) && MethodNameContentProcessor.managerModuleTokensRu.inverse().containsKey((Object)parts[i])) {
                    translationParts[i] = (String)MethodNameContentProcessor.managerModuleTokensRu.inverse().get((Object)parts[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i <= maxUpdateIndex && i < fqnRu.getSegmentCount()) {
                if (translationParts[i].equalsIgnoreCase(fqnRu.getSegment(i))) {
                    translationParts[i] = fqn.getSegment(i);
                } else if (i == 0 && maxUpdateIndex == 1 && parts.length > 1 && targetObject.getName().equalsIgnoreCase(parts[1]) && MethodNameContentProcessor.managerModuleTokensRu.containsKey((Object)parts[i])) {
                    translationParts[i] = (String)MethodNameContentProcessor.managerModuleTokensRu.get((Object)parts[i]);
                }
                ++i;
            }
        }
    }
}

