/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralFeatureValueCollector;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

@Singleton
public final class TypedStringLiteralRegistry {
    private static final String EXTENSION_POINT_ID = "typedStringLiterals";
    private static final String ELEMENT_PROCESSOR_NAME = "processor";
    private static final String ELEMENT_COLLECTOR_NAME = "collector";
    private static final String ATT_CLASS = "class";
    private Collection<TypedStringLiteralContentProcessor> processors;
    private Collection<TypedStringLiteralFeatureValueCollector> collectors;

    public Collection<TypedStringLiteralContentProcessor> allContentProcessors() {
        if (this.processors == null) {
            this.loadRegistry();
        }
        return this.processors;
    }

    public List<TypedStringLiteralContentProcessor> getContentProcessors(StringLiteral literal, Collection<LiteralType> types) {
        return this.allContentProcessors().stream().filter(p -> p.isSupport(literal, types)).collect(Collectors.toList());
    }

    public Collection<TypedStringLiteralFeatureValueCollector> allFeatureValueCollectors() {
        if (this.collectors == null) {
            this.loadRegistry();
        }
        return this.collectors;
    }

    public Collection<TypedStringLiteralFeatureValueCollector> getFeatureValueCollectors(StringLiteral literal, Collection<LiteralType> types) {
        return this.allFeatureValueCollectors().stream().filter(p -> p.isSupport(literal, types)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegistry() {
        Class<TypedStringLiteralRegistry> clazz = TypedStringLiteralRegistry.class;
        synchronized (TypedStringLiteralRegistry.class) {
            if (this.processors != null && this.collectors != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ImmutableList.Builder collectorBuilder = ImmutableList.builder();
            ImmutableList.Builder processorBuilder = ImmutableList.builder();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.v8.dt.bsl", EXTENSION_POINT_ID);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configElement = elements[i];
                try {
                    if (ELEMENT_PROCESSOR_NAME.equals(configElement.getName())) {
                        TypedStringLiteralContentProcessor processor = (TypedStringLiteralContentProcessor)configElement.createExecutableExtension(ATT_CLASS);
                        processorBuilder.add((Object)processor);
                    } else if (ELEMENT_COLLECTOR_NAME.equals(configElement.getName())) {
                        TypedStringLiteralFeatureValueCollector collector = (TypedStringLiteralFeatureValueCollector)configElement.createExecutableExtension(ATT_CLASS);
                        collectorBuilder.add((Object)collector);
                    }
                }
                catch (CoreException e) {
                    BslPlugin.logError(e);
                }
                ++i;
            }
            this.collectors = collectorBuilder.build();
            this.processors = processorBuilder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

