/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.stringliteral;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypeContentProcessor;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.CancelIndicator;

public class TypesContentProcessor
extends TypeContentProcessor {
    @Inject
    public TypesContentProcessor(IStringLiteralTypeComputer typeComputer, IQualifiedNameConverter qualifiedNameConverter, ITranslatedSymbolicNameService translatedSymbolicNameService, IScopeProvider scopeProvider) {
        super(typeComputer, qualifiedNameConverter, translatedSymbolicNameService, scopeProvider);
    }

    @Override
    public boolean isSupport(StringLiteral literal, Collection<LiteralType> types) {
        return this.typeComputer.containsAnyType(types, new String[]{"Types"});
    }

    @Override
    public List<String> process(StringLiteral literal, Collection<LiteralType> types, IProjectTranslationProvider translationProvider, TranslateLanguage language, CancelIndicator monitor) {
        EList lines = literal.lines(false);
        if (lines.isEmpty()) {
            return lines;
        }
        ArrayList<String> newLines = new ArrayList<String>(lines.size());
        for (String literalString : lines) {
            StringBuilder sb = new StringBuilder();
            int position = 0;
            String[] typeNames = literalString.split(",");
            int i = 0;
            while (i < typeNames.length) {
                String typeName = typeNames[i].trim();
                String newTypeName = this.getTypeName(typeName, (EObject)literal, translationProvider);
                int found = literalString.indexOf(typeName, position);
                if (found > -1) {
                    if (found > position) {
                        sb.append(literalString.substring(position, found));
                    }
                    sb.append(newTypeName);
                    position = found + typeName.length();
                }
                ++i;
            }
            if (position < literalString.length()) {
                sb.append(literalString.substring(position));
            }
            newLines.add(sb.toString());
        }
        return newLines;
    }
}

