/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.translator.SessionCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Provider;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;

public class BslDerivedPropertyCache
implements SessionCache {
    private static final long THREAD_MAX_CACHE_SIZE = 50000L;
    private static final int TOTAL_SYNC_THREADS = 8;
    private Cache<CacheKey, String> cache = CacheBuilder.newBuilder().concurrencyLevel(8).maximumSize(400000L).build();

    public String getTranslation(URI moduleUri, String methodName, int localOffset) {
        if (moduleUri == null || !moduleUri.hasFragment() || moduleUri.fragment().endsWith("-1")) {
            return null;
        }
        return this.getTranslation(moduleUri.toString(), methodName, localOffset);
    }

    public String getTranslation(String moduleUri, String methodName, int localOffset) {
        if (moduleUri == null) {
            return null;
        }
        CacheKey key = this.getKey(moduleUri, methodName, localOffset);
        return (String)this.cache.getIfPresent((Object)key);
    }

    public String getTranslation(URI moduleUri, String methodName, int localOffset, Provider<String> provider) {
        if (moduleUri == null || !moduleUri.hasFragment() || moduleUri.fragment().endsWith("-1")) {
            return (String)provider.get();
        }
        return this.getTranslation(moduleUri.toString(), methodName, localOffset, provider);
    }

    public String getTranslation(String moduleUri, String methodName, int localOffset, Provider<String> provider) {
        String computed;
        if (moduleUri == null) {
            return (String)provider.get();
        }
        CacheKey key = this.getKey(moduleUri, methodName, localOffset);
        String translation = (String)this.cache.getIfPresent((Object)key);
        if (StringUtils.isNullOrEmpty((String)translation) && StringUtils.isNotEmpty((String)(computed = (String)provider.get()))) {
            try {
                translation = (String)this.cache.get((Object)key, () -> computed);
            }
            catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
                return computed;
            }
        }
        return translation;
    }

    public void putTranslation(String moduleUri, String methodName, int localOffset, String translation) {
        Assert.isNotNull((Object)moduleUri);
        Assert.isLegal((localOffset > 0 ? 1 : 0) != 0, (String)"Local offset must be bigger than 0.");
        CacheKey key = this.getKey(moduleUri, methodName, localOffset);
        this.cache.put((Object)key, (Object)translation);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    private CacheKey getKey(String moduleUri, String methodName, int localOffset) {
        return new CacheKey(moduleUri, methodName, localOffset);
    }

    private static final class CacheKey {
        private final String moduleUri;
        private final String methodName;
        private final int localOffset;

        public CacheKey(String moduleUri, String methodName, int localOffset) {
            this.moduleUri = moduleUri;
            this.methodName = methodName;
            this.localOffset = localOffset;
        }

        public String toString() {
            return "CacheKey [moduleUri=" + this.moduleUri + ", methodName=" + this.methodName + ", localOffset=" + this.localOffset + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.localOffset;
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + (this.moduleUri == null ? 0 : this.moduleUri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.localOffset != other.localOffset) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equalsIgnoreCase(other.methodName)) {
                return false;
            }
            return !(this.moduleUri == null ? other.moduleUri != null : !this.moduleUri.equalsIgnoreCase(other.moduleUri));
        }
    }
}

