/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.bsl.common.IModuleExtensionService;
import com._1c.g5.v8.dt.bsl.common.IModuleExtensionServiceProvider;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslCommentUtils;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslDocumentationComment;
import com._1c.g5.v8.dt.bsl.documentation.comment.BslMultiLineCommentDocumentationProvider;
import com._1c.g5.v8.dt.bsl.model.BinaryExpression;
import com._1c.g5.v8.dt.bsl.model.BinaryOperation;
import com._1c.g5.v8.dt.bsl.model.Block;
import com._1c.g5.v8.dt.bsl.model.BooleanLiteral;
import com._1c.g5.v8.dt.bsl.model.BslDerivedPropertySource;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DeclareStatement;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.ForToStatement;
import com._1c.g5.v8.dt.bsl.model.GotoStatement;
import com._1c.g5.v8.dt.bsl.model.IndexAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.Label;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.NumberLiteral;
import com._1c.g5.v8.dt.bsl.model.OperatorStyleCreator;
import com._1c.g5.v8.dt.bsl.model.Pragma;
import com._1c.g5.v8.dt.bsl.model.Preprocessor;
import com._1c.g5.v8.dt.bsl.model.PreprocessorConditional;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.SourceObjectLinkProvider;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.UnaryExpression;
import com._1c.g5.v8.dt.bsl.model.UnaryOperation;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.services.BslGrammarAccess;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.ContainingSourceDerivedProperty;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.ModuleCachedLoader;
import com.e1c.langtool.v8.dt.bsl.comment.DocCommentKeyComputer;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.ConstProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.DefaultStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.KeysContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralRegistry;
import com.e1c.langtool.v8.dt.bsl.translator.BslCommentClearableTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslCommentTextProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.BslDerivedPropertyCache;
import com.e1c.langtool.v8.dt.bsl.translator.BslDocCommentParser;
import com.e1c.langtool.v8.dt.bsl.translator.BslTranslationLogger;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefBslCacheProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.bsl.translator.ExtensionModulePragmaValueProvider;
import com.e1c.langtool.v8.dt.bsl.translator.ExternalDocCommentFieldProcessor;
import com.e1c.langtool.v8.dt.bsl.translator.QueryFieldTranslationCache;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.translator.BslTranslatorConstants;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.OnChangeEvictingCache;

public class BslTextProcessor
extends MultiTextEditParseTreeVisitor {
    @Inject
    private ITranslationFeatureKeyProvider translationKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private BslMultiLineCommentDocumentationProvider commentProvider;
    @Inject
    private com._1c.g5.v8.dt.bsl.validation.BslPreferences bslPreferences;
    @Inject
    private BslPreferences preferences;
    @Inject
    private InternalizeDbViewTermsProvider internalizeDbViewTermsProvider;
    @Inject
    private ContextDefBslCacheProvider contextDefCacheProvider;
    @Inject
    private IStringLiteralTypeComputer stringLiteralTypeComputer;
    @Inject
    private TypedStringLiteralRegistry typedStringLiteralRegistry;
    @Inject
    private DefaultStringLiteralContentProcessor defaultStringLiteralContentProcessor;
    @Inject
    private KeysContentProcessor keysContentProcessor;
    @Inject
    private ConstProcessor constContentProcessor;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    @Inject
    private ModuleCachedLoader moduleCachedLoader;
    @Inject
    private ExtensionModulePragmaValueProvider extensionModulePragmaValueProvider;
    @Inject
    private BslDocCommentParser bslDocCommentParser;
    @Inject
    private DocCommentKeyComputer keyComputer;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private EmfObjectProvider emfObjectProvider;
    private final IModuleExtensionService moduleExtensionService;
    private final boolean isExtensionModule;
    private Map<StringLiteral, String[]> stringLiteralCache = Maps.newHashMap();
    private Set<Method> completedDocComments = Sets.newHashSet();
    private StringLiteral currentStringLiteral;
    private int stringLiteralCacheIndex = 0;
    private Boolean oldCommentFormat;
    private IFile resourceFile;
    private CancelIndicator cancelIndicator;
    private final Map<Variable, Block> blockVariables = new HashMap<Variable, Block>();
    private final @NonNull IProjectTranslationProvider translationProvider;
    private Module module;
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    @Inject
    private TypesComputer typesComputer;
    @Inject
    private BslGrammarAccess bslGrammar;
    private ContextDefCache contextDefCache;
    private final Map<EObject, String> translationCache = new ConcurrentHashMap<EObject, String>(1000);
    private final Set<String> externalDocCommentRecursionStack = ConcurrentHashMap.newKeySet();
    private TranslatorProperties translatorProperties;
    private final BmOperationContext typeComputationContext;
    private Environments actualEnvironments;
    private final BslTranslationLogger problemLogger;
    private final Set<Integer> processedNode;
    private final boolean isChangeDefaultLanguage;
    private final boolean isChangeScriptVariant;

    public BslTextProcessor(MultiTextEdit multiTextEditor, CancelIndicator cancelIndicator, IProjectTranslationProvider translationProvider, Module module, BmOperationContext typeComputationContext) {
        super(multiTextEditor);
        this.cancelIndicator = cancelIndicator;
        this.translationProvider = translationProvider;
        this.module = module;
        this.typeComputationContext = typeComputationContext;
        this.moduleExtensionService = IModuleExtensionServiceProvider.INSTANCE.getModuleExtensionService();
        this.isExtensionModule = this.moduleExtensionService.isExtensionModule(module);
        this.processedNode = new HashSet<Integer>();
        this.problemLogger = BslTranslationLogger.needLogging() ? BslTranslationLogger.create(this.getResourceFile(), translationProvider) : null;
        this.isChangeDefaultLanguage = translationProvider.getProject().isChangeDefaultLanguage();
        this.isChangeScriptVariant = translationProvider.getProject().isChangeScriptVariant();
    }

    public void dispose() {
        if (this.problemLogger != null) {
            try {
                this.problemLogger.flush();
            }
            catch (Exception e) {
                BslPlugin.logError(e);
            }
        }
        super.dispose();
    }

    @Deprecated
    public boolean visit(ICompositeNode node) {
        return !this.cancelIndicator.isCanceled();
    }

    public boolean visit(ILeafNode node) {
        if (this.cancelIndicator.isCanceled()) {
            return false;
        }
        if (node.isHidden()) {
            this.processCodeComments(node);
            return true;
        }
        EObject grammarElement = node.getGrammarElement();
        EObject object2 = node.getSemanticElement();
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        String text = node.getText();
        String replace = null;
        if (grammarElement instanceof RuleCall && text.equals(";") || grammarElement instanceof Keyword && BslTranslatorConstants.PUNCTUATION.contains(text)) {
            return true;
        }
        if (grammarElement instanceof EnumLiteralDeclaration && semanticElement instanceof BinaryExpression && !((BinaryExpression)semanticElement).getOperation().equals((Object)BinaryOperation.AND) && !((BinaryExpression)semanticElement).getOperation().equals((Object)BinaryOperation.OR)) {
            return true;
        }
        if (grammarElement instanceof EnumLiteralDeclaration && semanticElement instanceof UnaryExpression && !((UnaryExpression)semanticElement).getOperation().equals((Object)UnaryOperation.NOT)) {
            return true;
        }
        if (semanticElement instanceof NumberLiteral) {
            return true;
        }
        if (!(!(grammarElement instanceof Keyword) || semanticElement instanceof FeatureAccess || semanticElement instanceof NamedElement && text.equalsIgnoreCase(((NamedElement)semanticElement).getName()))) {
            if (object2 instanceof FeatureAccess) {
                return true;
            }
            replace = object2 instanceof BooleanLiteral ? this.getReplaceText((BooleanLiteral)object2) : this.getReplaceText((Keyword)grammarElement);
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        if (grammarElement instanceof EnumLiteralDeclaration) {
            replace = this.getReplaceText((EnumLiteralDeclaration)grammarElement);
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        if (grammarElement instanceof RuleCall && semanticElement instanceof Pragma) {
            Pragma pragma = (Pragma)semanticElement;
            if (pragma.getSymbol().equals(text)) {
                replace = this.getReplaceText((Pragma)semanticElement);
                this.addReplaceIfNotEmpty(node, replace);
            } else if ((this.isChangeDefaultLanguage() || this.isChangeScriptVariant()) && this.isExtensionModule && text.contains(pragma.getValue()) && StringUtils.isNotEmpty((String)(replace = this.extensionModulePragmaValueProvider.getTranslation(pragma, this.translationProvider)))) {
                this.addReplaceIfNotEmpty(node, replace);
            }
            return true;
        }
        if ((semanticElement instanceof Preprocessor || semanticElement instanceof PreprocessorConditional) && grammarElement instanceof RuleCall) {
            AbstractRule rule = ((RuleCall)grammarElement).getRule();
            if (rule.getName().equals("IDENT") && semanticElement instanceof RegionPreprocessor) {
                replace = this.getReplaceText((RegionPreprocessor)semanticElement);
            } else if (!rule.getName().equals("IDENT") && rule instanceof TerminalRule) {
                replace = this.getReplaceText((TerminalRule)rule);
            }
            this.addReplaceIfNotEmpty(node, replace);
            return true;
        }
        replace = this.getReplaceText(semanticElement);
        this.addReplaceIfNotEmpty(node, replace);
        if (semanticElement instanceof Method && !this.processedNode.contains(node.getStartLine())) {
            this.processDocComment((Method)semanticElement);
        }
        return true;
    }

    protected void addReplaceIfNotEmpty(ILeafNode node, String replace) {
        super.addReplaceIfNotEmpty(node, replace);
        if (this.problemLogger != null) {
            this.problemLogger.log(node, replace);
        }
    }

    private boolean isChangeScriptVariant() {
        return this.isChangeScriptVariant;
    }

    private ScriptVariant getScriptVariant() {
        return this.translationProvider.getProject().getScriptVariant();
    }

    private boolean isChangeDefaultLanguage() {
        return this.isChangeDefaultLanguage;
    }

    private TranslateLanguage getDefaultLanguage() {
        return this.translationProvider.getProject().getDefaultLanguage();
    }

    protected List<TranslateLanguage> getInterfaceLanguages() {
        return this.translationProvider.getProject().getInterfaceLanguages();
    }

    private String getReplaceText(EObject obj) {
        if (obj == null) {
            return null;
        }
        if (this.cancelIndicator.isCanceled()) {
            return null;
        }
        if (obj instanceof StringLiteral) {
            return this.getReplaceText((StringLiteral)obj);
        }
        if (!this.isChangeDefaultLanguage() && !this.isChangeScriptVariant()) {
            return null;
        }
        if (this.translationCache.containsKey(obj)) {
            return this.translationCache.get(obj);
        }
        String translation = null;
        if (obj instanceof Keyword) {
            translation = this.getReplaceText((Keyword)obj);
        } else if (obj instanceof FeatureAccess) {
            translation = this.getReplaceText((FeatureAccess)obj);
        } else if (obj instanceof BooleanLiteral) {
            translation = this.getReplaceText((BooleanLiteral)obj);
        } else if (obj instanceof OperatorStyleCreator) {
            translation = this.getReplaceText((OperatorStyleCreator)obj);
        } else if (obj instanceof GotoStatement) {
            translation = this.getReplaceText((GotoStatement)obj);
        } else if (obj instanceof BslDerivedPropertySource) {
            translation = this.getReplaceText((BslDerivedPropertySource)obj, null);
        } else {
            Pair names = this.namedEObjectNameProvider.getTranslatedName(obj, this.translationProvider);
            if (names != null) {
                translation = (String)names.getValue();
            }
        }
        this.translationCache.put(obj, translation == null ? "" : translation);
        return translation;
    }

    private String getReplaceText(BooleanLiteral object) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        replace = object.isIsTrue() ? (this.getScriptVariant() == ScriptVariant.RUSSIAN ? "\u0418\u0441\u0442\u0438\u043d\u0430" : "True") : (this.getScriptVariant() == ScriptVariant.RUSSIAN ? "\u041b\u043e\u0436\u044c" : "False");
        return replace;
    }

    private String getReplaceText(GotoStatement object) {
        if (!this.isChangeDefaultLanguage()) {
            return null;
        }
        Label label = object.getLabel();
        if (label == null) {
            String message = MessageFormat.format("BSL translation incorrect: Goto label incorrect, uri: {0}", EcoreUtil.getURI((EObject)object));
            BslPlugin.log(BslPlugin.createErrorStatus(message, null));
            return null;
        }
        return this.getReplaceText((NamedElement)label);
    }

    private String getReplaceText(NamedElement object) {
        Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)object, this.translationProvider);
        if (translation != null && object.getName().equalsIgnoreCase((String)translation.getKey())) {
            return (String)translation.getValue();
        }
        return null;
    }

    private String getReplaceText(Keyword keyword) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String replace = BslTextProcessor.getReplaceText(keyword, this.getScriptVariant());
        if (replace != null && replace.equals(keyword.getValue()) && keyword.equals(this.bslGrammar.getAwaitExpressionAccess().getCyrillicCapitalLetterZheCyrillicSmallLetterDeCyrillicSmallLetterACyrillicSmallLetterTeCyrillicSmallLetterSoftSignKeyword_0_1())) {
            replace = this.bslGrammar.getAwaitExpressionAccess().getAwaitKeyword_0_0().getValue();
        } else if (replace != null && replace.equals(keyword.getValue())) {
            replace = null;
        }
        return replace;
    }

    public static String getReplaceText(Keyword keyword, ScriptVariant sv) {
        EObject container = keyword.eContainer();
        if (container != null && container instanceof Alternatives && !container.eContents().isEmpty()) {
            EObject replaceObject;
            EList eContents = container.eContents();
            int index = -1;
            int shift = 0;
            if (eContents.size() > 2) {
                index = eContents.indexOf((Object)keyword);
                if (eContents.get(0) instanceof RuleCall && eContents.get(1) instanceof Keyword) {
                    shift = 1;
                }
                index -= shift;
            }
            if (index <= 1) {
                index = 0;
            } else if (index % 2 > 0) {
                --index;
            }
            if (sv == ScriptVariant.RUSSIAN && eContents.size() > 1) {
                ++index;
            }
            if ((replaceObject = (EObject)eContents.get(index + shift)) instanceof Keyword) {
                return ((Keyword)replaceObject).getValue();
            }
        }
        return null;
    }

    private String getReplaceText(EnumLiteralDeclaration object) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        EObject container = object.eContainer();
        if (container != null && container instanceof Alternatives && !container.eContents().isEmpty()) {
            Keyword literal;
            EObject replaceObject;
            EList eContents = container.eContents();
            int index = -1;
            if (eContents.size() > 2) {
                index = eContents.indexOf((Object)object);
            }
            if (index <= 1) {
                index = 0;
            } else if (index % 2 > 0) {
                --index;
            }
            if (this.getScriptVariant() == ScriptVariant.RUSSIAN && eContents.size() > 1) {
                ++index;
            }
            if ((replaceObject = (EObject)eContents.get(index)) instanceof EnumLiteralDeclaration && (literal = ((EnumLiteralDeclaration)replaceObject).getLiteral()) != null) {
                replace = literal.getValue();
            }
        }
        return replace;
    }

    private String getReplaceText(DuallyNamedElement object) {
        String replace = null;
        replace = this.getScriptVariant() == ScriptVariant.RUSSIAN ? object.getNameRu() : object.getName();
        return replace;
    }

    private String getReplaceText(OperatorStyleCreator object) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String replace = null;
        replace = this.getReplaceText((DuallyNamedElement)object.getType());
        return replace;
    }

    private String getReplaceText(StringLiteral object) {
        String replace = null;
        String[] lines = this.stringLiteralCache.get(object);
        if (object != this.currentStringLiteral) {
            this.currentStringLiteral = object;
            this.stringLiteralCacheIndex = 0;
        }
        if (lines == null) {
            this.computeStringLiteralCache(object);
            lines = this.stringLiteralCache.get(object);
        }
        if (lines != null && lines.length > this.stringLiteralCacheIndex) {
            replace = lines[this.stringLiteralCacheIndex];
            if (replace == null && this.stringLiteralCacheIndex > 0 && this.isEndingLinesNull(lines, this.stringLiteralCacheIndex)) {
                int total = object.getLines().size();
                List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
                if (nodes.size() == total && this.stringLiteralCacheIndex < total) {
                    INode prevNode = (INode)nodes.get(this.stringLiteralCacheIndex - 1);
                    INode node = (INode)nodes.get(this.stringLiteralCacheIndex);
                    int offset = prevNode.getEndOffset();
                    int length = node.getEndOffset() - prevNode.getEndOffset();
                    this.multiTextEdit.addChild((TextEdit)new DeleteEdit(offset, length));
                }
            }
            ++this.stringLiteralCacheIndex;
            return replace;
        }
        return replace;
    }

    private boolean isEndingLinesNull(String[] lines, int start) {
        int i = start;
        while (i < lines.length) {
            String line = lines[i];
            if (StringUtils.isNotEmpty((String)line)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void computeStringLiteralCache(StringLiteral literal) {
        String[] lines = (String[])literal.getLines().toArray((Object[])new String[0]);
        this.stringLiteralCache.put(literal, lines);
        Collection types = this.stringLiteralTypeComputer.computeTypes(literal);
        if (!(this.isChangeDefaultLanguage() || this.isChangeScriptVariant() || this.stringLiteralTypeComputer.containsAnyType(types, new String[]{"NStr"}))) {
            return;
        }
        List<TypedStringLiteralContentProcessor> literalProcessors = this.typedStringLiteralRegistry.getContentProcessors(literal, types);
        TypedStringLiteralContentProcessor processor = literalProcessors.isEmpty() ? this.defaultStringLiteralContentProcessor : literalProcessors.get(0);
        List<String> translated = processor.process(literal, types, this.translationProvider, this.getDefaultLanguage(), this.cancelIndicator);
        if (this.cancelIndicator.isCanceled()) {
            return;
        }
        translated = BslUtils.formatAndQuoteForStringLiteral(translated, "");
        String[] newLines = new String[lines.length];
        int i = 0;
        while (i < newLines.length) {
            if (i >= translated.size()) {
                newLines[i] = null;
            } else if (i == newLines.length - 1 && translated.size() >= i) {
                String indentation = BslUtils.getLastLineIdentation(literal, 0);
                StringBuilder sb = new StringBuilder(translated.get(i));
                int index = i + 1;
                while (index < translated.size()) {
                    sb.append(BslUtils.SYSTEM_LINE_SEPARATOR);
                    sb.append(indentation);
                    sb.append(translated.get(index));
                    ++index;
                }
                newLines[i] = sb.toString();
            } else {
                newLines[i] = translated.get(i);
            }
            ++i;
        }
        this.stringLiteralCache.put(literal, newLines);
    }

    /*
     * WARNING - void declaration
     */
    private String getReplaceText(FeatureAccess obj) {
        Environmental environmental;
        FeatureAccess featureAccess = obj;
        String replace = null;
        boolean isMethod = BslUtil.getInvocation((FeatureAccess)featureAccess) != null;
        boolean isDuallyNamedElement = false;
        ModelNameTranslationCache cache = (ModelNameTranslationCache)this.translationProvider.getCache(ModelNameTranslationCache.class);
        if (featureAccess instanceof IBmObject && ((IBmObject)featureAccess).bmGetEngine() != null && this.typeComputationContext != null) {
            featureAccess = (FeatureAccess)this.typeComputationContext.getBmTransaction().getPlatformTransaction().toTransactionObject((EObject)featureAccess);
        }
        if (StringUtils.isNotEmpty((String)(replace = this.getXDTOPropertyName(featureAccess, replace, isMethod, environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)featureAccess, Environmental.class))))) {
            return replace;
        }
        List features = this.dynamicFeatureAccessComputer.resolveObject(featureAccess, environmental.environments());
        for (FeatureEntry feature : features) {
            EObject groupObject = (EObject)feature.eGet((EStructuralFeature)BslPackage.Literals.FEATURE_ENTRY__FEATURE, false);
            if (groupObject instanceof IBmObject && ((IBmObject)groupObject).bmGetEngine() != null && this.typeComputationContext != null) {
                groupObject = this.typeComputationContext.getBmTransaction().getPlatformTransaction().toTransactionObject(groupObject);
            }
            String string = replace = groupObject == null ? null : cache.getTranslation(EcoreUtil.getURI((EObject)groupObject));
            if (StringUtils.isNotEmpty((String)replace)) {
                return replace;
            }
            groupObject = feature.getFeature();
            EObject eObject = groupObject;
            if (eObject instanceof DuallyNamedElement) {
                void duallyNamedElement;
                DuallyNamedElement duallyNamedElement2 = (DuallyNamedElement)eObject;
                DuallyNamedElement cfr_ignored_0 = (DuallyNamedElement)eObject;
                boolean isNamesEquals = duallyNamedElement.getName() != null && duallyNamedElement.getName().equalsIgnoreCase(duallyNamedElement.getNameRu());
                EObject eObject2 = groupObject;
                if (eObject2 instanceof DerivedProperty) {
                    void derivedProperty;
                    DerivedProperty derivedProperty2 = (DerivedProperty)eObject2;
                    DerivedProperty cfr_ignored_1 = (DerivedProperty)eObject2;
                    EObject source = null;
                    source = groupObject instanceof ContainingSourceDerivedProperty ? (EObject)groupObject.eGet((EStructuralFeature)McorePackage.Literals.CONTAINING_SOURCE_DERIVED_PROPERTY__CONTAINING_SOURCE, false) : (EObject)groupObject.eGet((EStructuralFeature)McorePackage.Literals.DERIVED_PROPERTY__SOURCE, false);
                    if (source instanceof IBmObject && ((IBmObject)source).bmGetEngine() != null && this.typeComputationContext != null) {
                        source = this.typeComputationContext.getBmTransaction().getPlatformTransaction().toTransactionObject(source);
                    }
                    if (source != null && isNamesEquals) {
                        replace = cache.getTranslation(EcoreUtil.getURI((EObject)source));
                    }
                    if (StringUtils.isNotEmpty((String)replace)) {
                        return replace;
                    }
                    source = derivedProperty.getSource();
                    if (source instanceof IBmObject && ((IBmObject)source).bmGetEngine() != null && this.typeComputationContext != null) {
                        source = this.typeComputationContext.getBmTransaction().getPlatformTransaction().toTransactionObject(source);
                    }
                    if (source != null && source.eIsProxy()) {
                        source = EcoreUtil.resolve((EObject)source, (EObject)this.module);
                    }
                    if (source instanceof BslDerivedPropertySource) {
                        replace = this.getReplaceText((BslDerivedPropertySource)source, featureAccess.getName());
                        if (!StringUtils.isNotEmpty((String)replace)) break;
                        return replace;
                    }
                    if (source != null) {
                        Pair translation = this.namedEObjectNameProvider.getTranslatedName(source, this.translationProvider);
                        if (translation != null && featureAccess.getName().equalsIgnoreCase((String)translation.getKey())) {
                            replace = (String)translation.getValue();
                            if (!StringUtils.isNotEmpty((String)replace)) break;
                            return replace;
                        }
                        if (translation != null && derivedProperty.getName() != null && derivedProperty.getNameRu() != null && !isNamesEquals && derivedProperty.getName().contains((CharSequence)translation.getKey()) && derivedProperty.getNameRu().contains((CharSequence)translation.getKey())) {
                            replace = this.getReplaceText((DuallyNamedElement)groupObject);
                            if (!StringUtils.isNotEmpty((String)replace)) break;
                            return replace.replace((CharSequence)translation.getKey(), (CharSequence)translation.getValue());
                        }
                        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)source, MdObject.class);
                        if (mdObject == null) break;
                        replace = this.getReplaceText((EObject)mdObject);
                        break;
                    }
                    if (derivedProperty.getName() == null || derivedProperty.getNameRu() == null || isNamesEquals) break;
                    replace = this.getReplaceText((DuallyNamedElement)groupObject);
                    isDuallyNamedElement = true;
                    break;
                }
                if (groupObject instanceof SourceObjectLinkProvider) {
                    replace = this.getReplaceText((SourceObjectLinkProvider)groupObject, featureAccess.getName());
                    break;
                }
                if (groupObject instanceof Property && isNamesEquals) break;
                replace = this.getReplaceText((DuallyNamedElement)groupObject);
                isDuallyNamedElement = true;
                break;
            }
            replace = this.getReplaceText(groupObject);
        }
        boolean featuresisEmpty = BslUtils.isEmptySource(features);
        if (replace != null && featureAccess.getName().equals(replace) && !isDuallyNamedElement) {
            replace = null;
        }
        ContextTranslationKey contextKey = null;
        if (featuresisEmpty && StringUtils.isNullOrEmpty((String)replace) && this.isChangeDefaultLanguage()) {
            contextKey = this.createTranslationKey((EObject)obj, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, obj.getName());
            replace = this.translationProvider.getStoredTranslation(contextKey, this.getDefaultLanguage(), new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT});
        }
        if (featuresisEmpty && StringUtils.isNullOrEmpty((String)replace) && featureAccess instanceof DynamicFeatureAccess && ((DynamicFeatureAccess)featureAccess).getSource() instanceof FeatureAccess) {
            FeatureAccess fa = (FeatureAccess)((DynamicFeatureAccess)featureAccess).getSource();
            List types = this.typesComputer.computeTypes((EObject)fa, environmental.environments());
            for (TypeItem typeItem : types) {
                String typeName = McoreUtil.getTypeName((TypeItem)typeItem);
                if (!"QueryResultSelection".equals(typeName)) continue;
                QueryFieldTranslationCache fieldCache = (QueryFieldTranslationCache)this.translationProvider.getCache(QueryFieldTranslationCache.class);
                replace = fieldCache.getTranslation(obj.eResource().getURI(), environmental, featureAccess.getName());
                break;
            }
        }
        if (StringUtils.isNullOrEmpty((String)replace)) {
            if (contextKey == null) {
                contextKey = this.createTranslationKey((EObject)obj, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, obj.getName());
            }
            replace = this.translationProvider.getTranslation((EObject)featureAccess, contextKey, this.getDefaultLanguage());
        }
        if (featuresisEmpty && StringUtils.isNullOrEmpty((String)replace) && featureAccess instanceof DynamicFeatureAccess && this.isChangeScriptVariant()) {
            replace = this.getSuggestionReplaceText((DynamicFeatureAccess)featureAccess, environmental);
        }
        return replace;
    }

    private String getXDTOPropertyName(FeatureAccess featureAccess, String replace, boolean isMethod, Environmental environmental) {
        if (!isMethod && StringUtils.isNullOrEmpty((String)replace) && featureAccess instanceof DynamicFeatureAccess) {
            FeatureAccess parent = featureAccess;
            List types = new ArrayList();
            while (parent != null && types.isEmpty()) {
                if (parent instanceof DynamicFeatureAccess) {
                    parent = ((DynamicFeatureAccess)parent).getSource();
                } else if (parent instanceof IndexAccess) {
                    parent = ((IndexAccess)parent).getSource();
                } else if (parent instanceof Invocation) {
                    parent = ((Invocation)parent).getMethodAccess();
                } else {
                    types = new ArrayList();
                    parent = null;
                    break;
                }
                types = this.typesComputer.computeTypes((EObject)parent, environmental.environments());
            }
            if (!types.isEmpty() && types.stream().anyMatch(t -> t != null && StringUtils.isNotEmpty((String)McoreUtil.getTypeName((TypeItem)t)) && "XDTODataObject".equals(McoreUtil.getTypeName((TypeItem)t)))) {
                return featureAccess.getName();
            }
        }
        return null;
    }

    private ContextTranslationKey createTranslationKey(EObject obj, FeatureSettings settings, String value) {
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey(obj, settings);
        return new ContextTranslationKeyImpl(this.getResourceFile(), featureKey, settings, value);
    }

    private String getSuggestionReplaceText(DynamicFeatureAccess object, Environmental environmental) {
        String replace = null;
        if (!this.isChangeScriptVariant()) {
            return replace;
        }
        Environments actualEnvs = this.getActualEnvs().intersect(environmental.environments());
        replace = this.getContextDefCache().getMethodOrPropertyName((FeatureAccess)object, actualEnvs);
        if (StringUtils.isNullOrEmpty((String)replace) && this.isChangeScriptVariant() && !(object.eContainer() instanceof FeatureAccess)) {
            boolean isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            replace = this.internalizeDbViewTermsProvider.getInternalizeEnumValue(object.getName(), isRussian);
        }
        return replace;
    }

    private String getReplaceText(RegionPreprocessor object) {
        if (!this.isChangeDefaultLanguage()) {
            return null;
        }
        Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)object, this.translationProvider);
        if (translation != null && object.getName().equalsIgnoreCase((String)translation.getKey())) {
            return (String)translation.getValue();
        }
        return null;
    }

    private String getReplaceText(SourceObjectLinkProvider object, String name) {
        Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)object, this.translationProvider);
        if (translation != null && name.equalsIgnoreCase((String)translation.getKey())) {
            return (String)translation.getValue();
        }
        return null;
    }

    private String getReplaceText(TerminalRule object) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String name = object.getName();
        String replace = null;
        if (this.getScriptVariant() == ScriptVariant.RUSSIAN) {
            if (name.equals("BEGIN_REGION")) {
                replace = "#\u041e\u0431\u043b\u0430\u0441\u0442\u044c";
            } else if (name.equals("END_REGION")) {
                replace = "#\u041a\u043e\u043d\u0435\u0446\u041e\u0431\u043b\u0430\u0441\u0442\u0438";
            } else if (name.equals("BEGIN_IFPREPROCESSOR")) {
                replace = "#\u0415\u0441\u043b\u0438";
            } else if (name.equals("ELSEIF_PREPROCESSOR")) {
                replace = "#\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438";
            } else if (name.equals("ELSE_PREPROCESSOR")) {
                replace = "#Else";
            } else if (name.equals("END_IFPREPROCESSOR")) {
                replace = "#\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438";
            } else if (name.equals("BEGIN_INSERT")) {
                replace = "#\u0412\u0441\u0442\u0430\u0432\u043a\u0430";
            } else if (name.equals("BEGIN_DELETE")) {
                replace = "#\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435";
            } else if (name.equals("END_DELETE")) {
                replace = "#\u041a\u043e\u043d\u0435\u0446\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u044f";
            } else if (name.equals("END_INSERT")) {
                replace = "#\u041a\u043e\u043d\u0435\u0446\u0412\u0441\u0442\u0430\u0432\u043a\u0438";
            }
        } else if (name.equals("BEGIN_REGION")) {
            replace = "#Region";
        } else if (name.equals("END_REGION")) {
            replace = "#EndRegion";
        } else if (name.equals("BEGIN_IFPREPROCESSOR")) {
            replace = "#If";
        } else if (name.equals("ELSEIF_PREPROCESSOR")) {
            replace = "#ElsIf";
        } else if (name.equals("ELSE_PREPROCESSOR")) {
            replace = "#Else";
        } else if (name.equals("END_IFPREPROCESSOR")) {
            replace = "#EndIf";
        } else if (name.equals("BEGIN_DELETE")) {
            replace = "#Delete";
        } else if (name.equals("BEGIN_INSERT")) {
            replace = "#Insert";
        } else if (name.equals("END_DELETE")) {
            replace = "#EndDelete";
        } else if (name.equals("END_INSERT")) {
            replace = "#EndInsert";
        }
        return replace;
    }

    private String getReplaceText(Pragma object) {
        if (!this.isChangeScriptVariant()) {
            return null;
        }
        String symbol = object.getSymbol();
        if (this.getScriptVariant() == ScriptVariant.RUSSIAN) {
            return (String)BslTranslatorConstants.PRAGMA.get((Object)symbol);
        }
        return (String)BslTranslatorConstants.PRAGMA.inverse().get((Object)symbol);
    }

    private void processDocComment(Method method) {
        if (!this.isChangeDefaultLanguage() && !this.isChangeScriptVariant()) {
            return;
        }
        if (this.completedDocComments.contains(method)) {
            return;
        }
        this.completedDocComments.add(method);
        List lines = this.commentProvider.getDocumentationNodes((EObject)method);
        if (!lines.isEmpty()) {
            BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((Method)method, (boolean)this.isOldCommentFormat(), (BslMultiLineCommentDocumentationProvider)this.commentProvider);
            FeatureKey featureKeyPreffix = this.translationKeyProvider.getKey((EObject)method);
            Function<EObject, String> eObjectReplaceProvider = this::getReplaceText;
            lines.forEach(n -> {
                boolean bl = this.processedNode.add(n.getStartLine());
            });
            BslCommentTextProcessor processor = this.createProcessor(method, lines, comment, featureKeyPreffix, eObjectReplaceProvider);
            BslPlugin.getDefault().getInjector().injectMembers((Object)processor);
            processor.process((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private BslCommentTextProcessor createProcessor(Method method, List<INode> lines, BslDocumentationComment comment, FeatureKey featureKeyPreffix, Function<EObject, String> eObjectReplaceProvider) {
        this.translatorProperties = this.getTranslatorProperties();
        if (this.translatorProperties.clearCodeComments()) {
            return new BslCommentClearableTextProcessor(this.getResourceFile(), featureKeyPreffix, comment, lines, this.multiTextEdit, this.translationProvider, eObjectReplaceProvider, this.getTranslatorProperties(), this.problemLogger, method, this.typeComputationContext, this.keyComputer, this.featureKeyProvider, this.resourceLookup, this.v8ProjectManager, this.scopeProvider);
        }
        return new BslCommentTextProcessor(this.getResourceFile(), featureKeyPreffix, comment, lines, this.multiTextEdit, this.translationProvider, eObjectReplaceProvider, this.getTranslatorProperties(), this.problemLogger, method, this.typeComputationContext);
    }

    private String getReplaceText(BslDerivedPropertySource object, String sourceName) {
        if (object.getModuleUri() == null || object.getLocalOffset() == 0) {
            return null;
        }
        BslDerivedPropertyCache cache = (BslDerivedPropertyCache)this.translationProvider.getCache(BslDerivedPropertyCache.class);
        Provider provider = () -> {
            Module current;
            URI uri = EcoreUtil.getURI((EObject)this.module);
            if (object.getModuleUri() == null || uri == null) {
                return null;
            }
            boolean localModule = object.getModuleUri().equalsIgnoreCase(uri.toString());
            if (localModule) {
                current = this.module;
            } else {
                EObject externalModule;
                EObject eObject;
                IFile currentFile = this.resourceLookup.getPlatformResource(URI.createURI((String)object.getModuleUri()));
                if (currentFile != null && (eObject = (externalModule = this.emfObjectProvider.getObjectByFile(currentFile))) instanceof Module) {
                    void module;
                    Module module2 = (Module)eObject;
                    Module cfr_ignored_0 = (Module)eObject;
                    OnChangeEvictingCache.CacheAdapter cacheAdapter = (OnChangeEvictingCache.CacheAdapter)EcoreUtil.getAdapter((List)module.eAdapters(), OnChangeEvictingCache.CacheAdapter.class);
                    if (cacheAdapter != null) {
                        cacheAdapter.ignoreNotifications();
                    }
                }
                current = this.getExternalModule(object);
            }
            String name = object.getMethodName();
            ICompositeNode node = null;
            if (StringUtils.isNotEmpty((String)name)) {
                Optional<Method> method = current.allMethods().stream().filter(m -> m.getName().equalsIgnoreCase(name)).findFirst();
                if (!method.isPresent()) return null;
                node = NodeModelUtils.findActualNodeFor((EObject)((EObject)method.get()));
            } else {
                node = NodeModelUtils.getNode((EObject)current);
            }
            if (node == null) {
                return null;
            }
            ILeafNode propertyNode = NodeModelUtils.findLeafNodeAtOffset((INode)node, (int)(node.getTotalOffset() + object.getLocalOffset()));
            if (propertyNode == null) {
                return null;
            }
            EObject property = NodeModelUtils.findActualSemanticObjectFor((INode)propertyNode);
            if (propertyNode.isHidden()) {
                if (!(property instanceof Method)) return null;
                if (localModule) {
                    if (this.processedNode.contains(node.getStartLine())) return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                    this.processDocComment((Method)property);
                    return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                } else {
                    this.processExternalDocComment((Method)property, object);
                }
                return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
            }
            if (property instanceof StringLiteral) {
                StringLiteral literal = (StringLiteral)property;
                if (localModule && !this.stringLiteralCache.containsKey(literal)) {
                    this.computeStringLiteralCache(literal);
                    return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                } else {
                    if (localModule) return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                    Collection types = this.stringLiteralTypeComputer.computeTypes(literal);
                    if (this.keysContentProcessor.isSupport(literal, types)) {
                        this.keysContentProcessor.process(literal, types, this.translationProvider, this.getDefaultLanguage(), this.cancelIndicator);
                        return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                    } else {
                        if (!this.stringLiteralTypeComputer.containsAnyType(types, new String[]{"Non-NLS"})) return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
                        this.constContentProcessor.process(literal, types, this.translationProvider, this.getDefaultLanguage(), this.cancelIndicator);
                    }
                }
                return cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
            }
            if (!localModule) return null;
            Optional<String> translation = Optional.ofNullable(this.getReplaceText(property));
            return translation.orElse(sourceName);
        };
        String translation = cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset(), (Provider<String>)provider);
        if (translation != null && translation.equalsIgnoreCase(sourceName)) {
            return sourceName;
        }
        return translation;
    }

    private Module getExternalModule(BslDerivedPropertySource object) {
        URI uri = URI.createURI((String)object.getModuleUri());
        return this.moduleCachedLoader.getModule(uri, (EObject)object, this.cancelIndicator);
    }

    private void processExternalDocComment(Method method, BslDerivedPropertySource object) {
        String methodName = object.getMethodName() == null ? "" : object.getMethodName();
        String key = object.getModuleUri() + ":" + methodName + ":" + object.getLocalOffset();
        if (this.externalDocCommentRecursionStack.contains(key)) {
            String message = MessageFormat.format("{0}.processExternalDocComment() Type recursion via documentation comment found while translate module {1}\nReference to exisitng key: {2}\ncall stack: \n -> {3}", ((Object)((Object)this)).getClass().getName(), this.resourceFile, key, String.join((CharSequence)"\n -> ", this.externalDocCommentRecursionStack));
            IStatus status = BslPlugin.createWarningStatus(message);
            BslPlugin.log(status);
            return;
        }
        this.externalDocCommentRecursionStack.add(key);
        URI uri = URI.createURI((String)object.getModuleUri());
        List lines = this.commentProvider.getDocumentationNodes((EObject)method);
        if (!lines.isEmpty()) {
            BslDocumentationComment comment = BslCommentUtils.parseTemplateComment((Method)method, (boolean)this.isOldCommentFormat(), (BslMultiLineCommentDocumentationProvider)this.commentProvider);
            FeatureKey featureKeyPreffix = this.translationKeyProvider.getKey((EObject)method);
            Function<EObject, String> eObjectReplaceProvider = this::getReplaceText;
            Path path = new Path(uri.trimFragment().toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            ExternalDocCommentFieldProcessor processor = new ExternalDocCommentFieldProcessor(file, method, featureKeyPreffix, comment, lines, this.translationProvider, eObjectReplaceProvider, this.typeComputationContext);
            BslPlugin.getDefault().getInjector().injectMembers((Object)processor);
            processor.process((IProgressMonitor)new NullProgressMonitor());
        }
        this.externalDocCommentRecursionStack.remove(key);
    }

    private void processCodeComments(ILeafNode node) {
        BslDocumentationComment comment;
        String keyPreffix;
        Method method;
        List lines;
        if (!node.isHidden() || !this.isChangeDefaultLanguage() && !this.isChangeScriptVariant()) {
            return;
        }
        if (!BslCommentUtils.isCommentNode((ILeafNode)node)) {
            return;
        }
        EObject owner = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        if ((owner instanceof Method || owner instanceof Pragma && ((Pragma)owner).eContainer() instanceof Method) && (lines = this.commentProvider.getDocumentationNodes((EObject)(method = owner instanceof Pragma && ((Pragma)owner).eContainer() instanceof Method ? (Method)((Pragma)owner).eContainer() : (Method)owner))).contains(node)) {
            return;
        }
        if (this.processedNode.contains(node.getStartLine())) {
            return;
        }
        List<INode> lines2 = BslUtils.getUpAndDownCommentNodes((INode)node);
        Object parent = null;
        Variable variable = this.getVariableParent(BslUtils.getCommentNodeVariable(node));
        parent = variable != null ? variable : BslUtils.getOwnerDocNode(lines2);
        boolean isDoc = parent != null;
        FeatureKey featureKeyPreffix = this.bslDocCommentParser.getVariableFeatureKey((EObject)(parent = parent == null ? BslUtils.getOwnerNode(lines2) : parent), (EObject)variable, this.blockVariables, keyPreffix = BslUtils.getFeatrueKeyPreffix(comment = this.bslDocCommentParser.parse(lines2, this.isOldCommentFormat())));
        if (featureKeyPreffix == null) {
            featureKeyPreffix = SegmentFeatureKey.EMPTY;
        }
        if (!(this.processedNode.isEmpty() && parent instanceof Module || isDoc)) {
            featureKeyPreffix = featureKeyPreffix.append("Comment");
            String featrueKeyPreffix = BslUtils.getFeatrueKeyPreffix(comment);
            if (StringUtils.isNotEmpty((String)featrueKeyPreffix)) {
                featureKeyPreffix = featureKeyPreffix.append(featrueKeyPreffix);
            }
        }
        if (parent == null) {
            return;
        }
        Function<EObject, String> eObjectReplaceProvider = this::getReplaceText;
        BslCommentTextProcessor processor = this.createProcessor(lines2, (EObject)parent, featureKeyPreffix, comment, eObjectReplaceProvider);
        BslPlugin.getDefault().getInjector().injectMembers((Object)processor);
        processor.process((IProgressMonitor)new NullProgressMonitor());
        lines2.forEach(n -> {
            boolean bl = this.processedNode.add(n.getStartLine());
        });
    }

    private Variable getVariableParent(Variable object) {
        Variable e = object;
        while (e != null) {
            if (e instanceof ForEachStatement || e instanceof DeclareStatement || e instanceof ForToStatement || e instanceof StaticFeatureAccess || e instanceof SimpleStatement) {
                return object;
            }
            if (e instanceof Method) {
                return null;
            }
            e = e.eContainer();
        }
        return null;
    }

    private BslCommentTextProcessor createProcessor(List<INode> lines, EObject parent, FeatureKey featureKeyPreffix, BslDocumentationComment comment, Function<EObject, String> eObjectReplaceProvider) {
        this.translatorProperties = this.getTranslatorProperties();
        if (this.translatorProperties.clearCodeComments()) {
            return new BslCommentClearableTextProcessor(this.getResourceFile(), parent, featureKeyPreffix, comment, lines, this.multiTextEdit, this.translationProvider, eObjectReplaceProvider, this.getTranslatorProperties(), this.problemLogger, this.typeComputationContext, this.keyComputer, this.featureKeyProvider, this.resourceLookup, this.v8ProjectManager, this.scopeProvider);
        }
        return new BslCommentTextProcessor(this.getResourceFile(), parent, featureKeyPreffix, comment, lines, this.multiTextEdit, this.translationProvider, eObjectReplaceProvider, this.getTranslatorProperties(), this.problemLogger, this.typeComputationContext, (Method)EcoreUtil2.getContainerOfType((EObject)parent, Method.class));
    }

    private boolean isOldCommentFormat() {
        if (this.oldCommentFormat == null) {
            IProject project = this.resourceLookup.getProject((EObject)this.module);
            this.oldCommentFormat = this.bslPreferences.getDocumentCommentProperties(project).oldCommentFormat();
        }
        return this.oldCommentFormat;
    }

    private ContextDefCache getContextDefCache() {
        if (this.contextDefCache == null) {
            boolean isRussian = this.translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            this.contextDefCache = this.contextDefCacheProvider.getContextDefCache((EObject)this.module, isRussian);
        }
        return this.contextDefCache;
    }

    private Environments getActualEnvs() {
        if (this.actualEnvironments == null) {
            this.actualEnvironments = this.bslPreferences.getLoadEnvs((EObject)this.module);
        }
        return this.actualEnvironments;
    }

    private TranslatorProperties getTranslatorProperties() {
        if (this.translatorProperties == null) {
            IProject project = this.resourceLookup.getProject((EObject)this.module);
            this.translatorProperties = this.preferences.getTranslatorProperties(project);
        }
        return this.translatorProperties;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            URI uri = EcoreUtil.getURI((EObject)this.module).trimFragment();
            Path path = new Path(uri.toPlatformString(true));
            this.resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return this.resourceFile;
    }
}

