/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.documentation.comment.TypeSection;
import com._1c.g5.v8.dt.bsl.model.Block;
import com._1c.g5.v8.dt.bsl.model.BslDerivedPropertySource;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureEntry;
import com._1c.g5.v8.dt.bsl.model.SourceObjectLinkProvider;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.typesytem.IExpressionTypeState;
import com._1c.g5.v8.dt.bsl.model.typesytem.TypeSystemMode;
import com._1c.g5.v8.dt.bsl.model.typesytem.VariableTreeTypeState;
import com._1c.g5.v8.dt.bsl.model.typesytem.VariableTypeState;
import com._1c.g5.v8.dt.bsl.resource.BslResource;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.bsl.resource.TypesComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.translator.BslDerivedPropertyCache;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.LineAndColumn;

public class BslTranslationLogger {
    private static final String FILE_EXT = "log";
    private static final String PROPERTY_LOG_PATH = "langtool.v8.dt.bsl.translator.logpath";
    private static final String PROPERTY_LOG_PATTERN = "langtool.v8.dt.bsl.translator.logpattern";
    private static final String PROPERTY_LOG_TRANS_LIST = "langtool.v8.dt.bsl.translator.logtranslist";
    private static final String SPACER = " ";
    private final DynamicFeatureAccessComputer dynamicFeatureAccessComputer;
    private final Path logPath;
    private final String logPattern;
    private final Map<String, Set<String>> logTransList = new ConcurrentSkipListMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
    private IFile moduleFile;
    private IProjectTranslationProvider translationProvider;
    private final IQualifiedNameConverter qualifiedNameConverter;
    private final StringBuffer sb = new StringBuffer();
    private final IScopeProvider scopeProvider;
    private final IStringLiteralTypeComputer stringLiteralTypeComputer;
    private final ITranslationFeatureKeyProvider translationKeyProvider;
    private final TypesComputer typesComputer;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static BslTranslationLogger create(IFile moduleFile, IProjectTranslationProvider translationProvider) {
        BslTranslationLogger logger = (BslTranslationLogger)BslPlugin.getDefault().getInjector().getInstance(BslTranslationLogger.class);
        logger.moduleFile = moduleFile;
        logger.translationProvider = translationProvider;
        return logger;
    }

    public static boolean needLogging() {
        String path = System.getProperty(PROPERTY_LOG_PATH, "");
        String pattern = System.getProperty(PROPERTY_LOG_PATTERN, "");
        String translist = System.getProperty(PROPERTY_LOG_TRANS_LIST, "");
        return !path.isBlank() && (!pattern.isBlank() || !translist.isBlank());
    }

    @Inject
    public BslTranslationLogger(DynamicFeatureAccessComputer dynamicFeatureAccessComputer, TypesComputer typesComputer, IScopeProvider scopeProvider, IStringLiteralTypeComputer stringLiteralTypeComputer, IQualifiedNameConverter qualifiedNameConverter, ITranslationFeatureKeyProvider translationKeyProvider) {
        this.stringLiteralTypeComputer = stringLiteralTypeComputer;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.translationKeyProvider = translationKeyProvider;
        this.dynamicFeatureAccessComputer = dynamicFeatureAccessComputer;
        this.typesComputer = typesComputer;
        this.scopeProvider = scopeProvider;
        String pathText = System.getProperty(PROPERTY_LOG_PATH, "");
        this.logPattern = System.getProperty(PROPERTY_LOG_PATTERN, "");
        String translist = System.getProperty(PROPERTY_LOG_TRANS_LIST, "");
        this.loadTransList(translist);
        this.logPath = !pathText.isBlank() && (!this.logPattern.isBlank() || !this.logTransList.isEmpty()) ? Path.of(pathText, new String[0]) : null;
    }

    private void loadTransList(String translist) {
        if (translist == null || translist.isBlank()) {
            return;
        }
        String[] pairs = translist.split(";");
        int i = 0;
        while (i < pairs.length) {
            String[] translate;
            String pair = pairs[i];
            if (StringUtils.isNotEmpty((String)pair) && (translate = pair.split("=")).length > 0 && StringUtils.isNotEmpty((String)translate[0])) {
                Set translations = this.logTransList.computeIfAbsent(translate[0], k -> new TreeSet(String.CASE_INSENSITIVE_ORDER));
                if (translate.length > 1 && !StringUtils.isBlank((String)translate[1])) {
                    translations.add(translate[1]);
                }
            }
            ++i;
        }
    }

    private void appedDocCommentHeader(int offset, int lenth, INode context) {
        this.sb.append("Date:");
        this.sb.append(SPACER);
        this.sb.append(this.dateFormatter.format(new Date()));
        this.sb.append(System.lineSeparator());
        this.sb.append("Line No:");
        this.sb.append(SPACER);
        if (offset <= 0 || context.getRootNode() == null || context.getRootNode().getOffset() < 0) {
            this.sb.append("-1");
            this.sb.append(System.lineSeparator());
            return;
        }
        LineAndColumn line = NodeModelUtils.getLineAndColumn((INode)context, (int)offset);
        this.sb.append(line.getLine());
        this.sb.append(", ");
        this.sb.append(line.getColumn());
        this.sb.append("-");
        this.sb.append(line.getColumn() + lenth);
        this.sb.append(System.lineSeparator());
        this.sb.append("Line:");
        this.sb.append(SPACER);
        int start = offset - line.getColumn();
        if (start < 0) {
            start = 0;
        }
        String text = context.getRootNode().getText().substring(start, offset + lenth);
        this.sb.append(text.stripLeading());
        this.sb.append(System.lineSeparator());
    }

    private void appedDocCommentSemantic(Object object, INode contex) {
        this.sb.append("Type:");
        this.sb.append(SPACER);
        if (object != null) {
            this.sb.append(object.getClass().getName());
        } else {
            this.sb.append("DocComment <no type object>");
        }
        this.sb.append(System.lineSeparator());
        this.appedDocCommentSemanticType(object, contex);
    }

    private void appedDocCommentSemanticType(TypeSection.FieldDefinition field, INode contex) {
    }

    private void appedDocCommentSemanticType(Object object, INode contex) {
        if (object instanceof TypeSection.TypeDefinition) {
            this.appedDocCommentSemanticType((TypeSection.TypeDefinition)object, contex);
        } else if (object instanceof TypeSection.FieldDefinition) {
            this.appedDocCommentSemanticType((TypeSection.FieldDefinition)object, contex);
        }
    }

    private void appedDocCommentSemanticType(TypeSection.TypeDefinition typeDef, INode contex) {
        this.sb.append("Type definition name:");
        this.sb.append(SPACER);
        EObject method = NodeModelUtils.findActualSemanticObjectFor((INode)contex);
        String typeName = typeDef.getTypeName().trim();
        IScope scope = this.scopeProvider.getScope(method, McorePackage.Literals.TYPE_DESCRIPTION__TYPES);
        QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(typeName);
        IEObjectDescription obj = scope.getSingleElement(fqn);
        if (obj != null) {
            TypeItem type = (TypeItem)obj.getEObjectOrProxy();
            String newTypeName = McoreUtil.getTypeName((TypeItem)type);
            this.sb.append(newTypeName);
        } else {
            this.sb.append("<type not found>");
        }
        this.sb.append(System.lineSeparator());
    }

    private void appedHeader(ILeafNode node) {
        this.sb.append("Date:");
        this.sb.append(SPACER);
        this.sb.append(this.dateFormatter.format(new Date()));
        this.sb.append(System.lineSeparator());
        this.sb.append("Line No:");
        this.sb.append(SPACER);
        LineAndColumn line = NodeModelUtils.getLineAndColumn((INode)node, (int)node.getOffset());
        this.sb.append(line.getLine());
        this.sb.append(", ");
        this.sb.append(line.getColumn());
        this.sb.append("-");
        this.sb.append(line.getColumn() + node.getLength());
        this.sb.append(System.lineSeparator());
        this.sb.append("Line:");
        this.sb.append(SPACER);
        int start = node.getOffset() - line.getColumn();
        if (start < 0) {
            start = 0;
        }
        String text = node.getRootNode().getText().substring(start, node.getEndOffset());
        this.sb.append(text.stripLeading());
        this.sb.append(System.lineSeparator());
    }

    private void appedSemantic(DynamicFeatureAccess object) {
        this.sb.append("Parent types:");
        this.sb.append(SPACER);
        Expression parent = object.getSource();
        Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)parent, Environmental.class);
        List types = this.typesComputer.computeTypes((EObject)parent, envs.environments());
        if (types.isEmpty()) {
            this.sb.append("<no types>");
            if (parent instanceof StaticFeatureAccess && !((StaticFeatureAccess)parent).getFeatureEntries().isEmpty() && ((FeatureEntry)((StaticFeatureAccess)parent).getFeatureEntries().get(0)).getFeature() instanceof Variable) {
                this.sb.append(System.lineSeparator());
                Variable variable = (Variable)((FeatureEntry)((StaticFeatureAccess)parent).getFeatureEntries().get(0)).getFeature();
                this.sb.append("Parent variable [");
                this.sb.append(variable.getName());
                this.sb.append("], ");
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)parent);
                Block block = (Block)EcoreUtil2.getContainerOfType((EObject)parent, Block.class);
                ICompositeNode blockNode = NodeModelUtils.findActualNodeFor((EObject)block);
                this.sb.append("SFA offset: ");
                int offset = node.getOffset() + 1;
                this.sb.append(offset);
                this.sb.append(", block totalOffset: ");
                this.sb.append(blockNode.getTotalOffset());
                this.sb.append(", block totalEndOffset: ");
                this.sb.append(blockNode.getTotalEndOffset());
                this.sb.append(", envs: ");
                this.sb.append(envs);
                this.sb.append(": ");
                this.sb.append(this.variableTypeToString(variable));
                if (variable.getTypeStateProvider() != null) {
                    this.sb.append(System.lineSeparator());
                    List selected = variable.getTypeStateProvider().get(TypeSystemMode.NORMAL).getNearestByOffset(offset);
                    this.sb.append("Selected var type state by offset: ");
                    String content = selected.stream().map(this::variableTypeStateToString).collect(Collectors.joining(" ### "));
                    this.sb.append(content);
                }
                this.sb.append(System.lineSeparator());
                if (object.eResource() instanceof BslResource) {
                    this.sb.append("Bsl Resource Linked batch: ");
                    this.sb.append(((BslResource)object.eResource()).isLinkedBatch());
                } else {
                    this.sb.append("Bsl module loaded into non-BslResource: ");
                    this.sb.append(object.eResource());
                }
            }
        } else {
            this.sb.append(String.join((CharSequence)", ", types.stream().map(McoreUtil::getTypeName).collect(Collectors.toList())));
        }
        this.sb.append(System.lineSeparator());
    }

    private void appedSemantic(EObject object) {
        if (object instanceof FeatureAccess) {
            this.appedSemantic((FeatureAccess)object);
        }
        if (object instanceof DynamicFeatureAccess) {
            this.appedSemantic((DynamicFeatureAccess)object);
        }
        if (object instanceof DerivedProperty) {
            this.appedSemantic((DerivedProperty)object);
        }
        if (object instanceof SourceObjectLinkProvider) {
            this.appedSemantic((SourceObjectLinkProvider)object);
        }
        if (object instanceof BslDerivedPropertySource) {
            this.appedSemantic((BslDerivedPropertySource)object);
        }
        if (object instanceof DuallyNamedElement) {
            this.appedSemantic((DuallyNamedElement)object);
        }
        if (object instanceof StringLiteral) {
            this.appedSemantic((StringLiteral)object);
        }
    }

    private void appedSemantic(FeatureAccess object) {
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        List features = this.dynamicFeatureAccessComputer.resolveObject(object, environmental.environments());
        this.sb.append("Source:");
        this.sb.append(SPACER);
        if (BslUtils.isEmptySource(features)) {
            this.sb.append("<no source>");
        } else {
            int i = 0;
            while (i < features.size()) {
                FeatureEntry feature = (FeatureEntry)features.get(i);
                this.sb.append(SPACER);
                this.sb.append("#");
                this.sb.append(i);
                this.sb.append(":{");
                this.sb.append(SPACER);
                EObject groupObject = feature.getFeature();
                this.sb.append(groupObject.eClass().getInstanceClassName());
                this.sb.append(SPACER);
                this.sb.append("uri:");
                this.sb.append(SPACER);
                this.sb.append(EcoreUtil.getURI((EObject)groupObject));
                this.appedSemantic(groupObject);
                this.sb.append(SPACER);
                this.sb.append("}");
                ++i;
            }
        }
        this.sb.append(System.lineSeparator());
        this.sb.append("Dictionary trans:");
        this.sb.append(SPACER);
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.moduleFile, featureKey, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, object.getName());
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String dictTrans = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.COMMON});
        if (StringUtils.isNullOrEmpty((String)dictTrans)) {
            this.sb.append("<no translation>");
        } else {
            this.sb.append(dictTrans);
        }
        this.sb.append(System.lineSeparator());
    }

    private void appedSemantic(DerivedProperty object) {
        this.sb.append(SPACER);
        EObject source = object.getSource();
        if (source != null) {
            this.sb.append(source.eClass().getInstanceClassName());
            this.sb.append(SPACER);
            this.sb.append("source uri:");
            this.sb.append(SPACER);
            this.sb.append(EcoreUtil.getURI((EObject)source));
            this.sb.append(SPACER);
            this.appedSemantic(source);
        } else {
            this.sb.append("source = null");
            this.sb.append(SPACER);
        }
    }

    private void appedSemantic(SourceObjectLinkProvider object) {
        this.sb.append(SPACER);
        this.sb.append("source-link uri:");
        this.sb.append(SPACER);
        this.sb.append(object.getSourceUri());
    }

    private void appedSemantic(BslDerivedPropertySource object) {
        this.sb.append(SPACER);
        this.sb.append("Module uri:");
        this.sb.append(SPACER);
        this.sb.append(object.getModuleUri());
        this.sb.append(", method:");
        this.sb.append(SPACER);
        this.sb.append(object.getMethodName());
        this.sb.append(", offset:");
        this.sb.append(SPACER);
        this.sb.append(object.getLocalOffset());
        BslDerivedPropertyCache cache = (BslDerivedPropertyCache)this.translationProvider.getCache(BslDerivedPropertyCache.class);
        String translation = cache.getTranslation(object.getModuleUri(), object.getMethodName(), object.getLocalOffset());
        this.sb.append(", cache translation:");
        this.sb.append(SPACER);
        this.sb.append("\"");
        if (translation == null) {
            this.sb.append("<null>");
        } else {
            this.sb.append(translation);
        }
        this.sb.append("\"");
    }

    private void appedSemantic(DuallyNamedElement object) {
        this.sb.append(SPACER);
        this.sb.append("NameRu:");
        this.sb.append(SPACER);
        this.sb.append(object.getNameRu());
        this.sb.append(SPACER);
        this.sb.append("NameEn:");
        this.sb.append(SPACER);
        this.sb.append(object.getName());
    }

    private void appedSemantic(StringLiteral object) {
        this.sb.append("Dictionary trans:");
        this.sb.append(SPACER);
        FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.moduleFile, featureKey, (FeatureSettings)BslFeatureSettings.Literals.STRING_LITERAL__LINES, BslUtils.getString(object).trim());
        TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
        String dictTrans = this.translationProvider.getStoredTranslation((ContextTranslationKey)contextKey, language, new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.COMMON});
        if (StringUtils.isNullOrEmpty((String)dictTrans)) {
            this.sb.append("<no translation>");
        } else {
            this.sb.append(dictTrans);
        }
        this.sb.append(System.lineSeparator());
    }

    private void appedSemantic(ILeafNode node) {
        this.sb.append("Type:");
        this.sb.append(SPACER);
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        if (semanticElement != null) {
            this.sb.append(semanticElement.eClass().getInstanceClassName());
            this.appedSemanticType(semanticElement);
        } else {
            this.sb.append("<no semantic element>");
        }
        this.sb.append(System.lineSeparator());
        if (semanticElement != null) {
            this.appedSemantic(semanticElement);
        }
    }

    private void appedSemanticType(EObject object) {
        if (object instanceof StringLiteral) {
            this.appedSemanticType((StringLiteral)object);
        } else if (object instanceof FeatureAccess) {
            this.appedSemanticType((FeatureAccess)object);
        }
    }

    private void appedSemanticType(FeatureAccess object) {
        this.sb.append(SPACER);
        this.sb.append("@types:");
        this.sb.append(SPACER);
        Environmental envs = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        List types = this.typesComputer.computeTypes((EObject)object, envs.environments());
        if (types.isEmpty()) {
            this.sb.append("<no types>");
        } else {
            this.sb.append(String.join((CharSequence)", ", types.stream().map(McoreUtil::getTypeName).collect(Collectors.toList())));
        }
    }

    private void appedSemanticType(@NonNull StringLiteral object) {
        Collection types = this.stringLiteralTypeComputer.computeTypes(object);
        this.sb.append(SPACER);
        if (types.isEmpty()) {
            this.sb.append("<no types>");
        } else {
            this.sb.append("@types:");
            this.sb.append(SPACER);
            this.sb.append(String.join((CharSequence)", ", types.stream().map(LiteralType::getName).collect(Collectors.toList())));
            types = this.stringLiteralTypeComputer.getAnnotatedTypes(object);
            if (!types.isEmpty()) {
                this.sb.append(SPACER);
                this.sb.append("@annotated:");
                this.sb.append(SPACER);
                this.sb.append(String.join((CharSequence)", ", types.stream().map(LiteralType::getName).collect(Collectors.toList())));
            }
        }
    }

    private void appendTranslation(String replace) {
        this.sb.append("Trans:");
        this.sb.append(SPACER);
        if (replace == null) {
            this.sb.append("<null>");
        } else if (replace.isBlank()) {
            this.sb.append("<blank>");
        } else {
            this.sb.append(replace);
        }
        this.sb.append(System.lineSeparator());
    }

    public void flush() {
        if (this.logPath == null || this.moduleFile == null || this.sb.length() == 0) {
            return;
        }
        IPath path = this.moduleFile.getProjectRelativePath().removeFileExtension().addFileExtension(FILE_EXT);
        File file = this.logPath.resolve(path.toFile().toPath()).toFile();
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            Files.writeString(file.toPath(), (CharSequence)this.sb.toString(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            BslPlugin.logError(e);
        }
    }

    public void log(ILeafNode node, String replace) {
        if (this.logPath == null) {
            return;
        }
        String check = node.getText();
        Set<String> translation = this.logTransList.get(check);
        if (StringUtils.isNotEmpty((String)replace)) {
            check = replace;
        }
        if (check != null && (!StringUtils.isBlank((String)this.logPattern) && check.matches(this.logPattern) || translation != null && (translation.isEmpty() || translation.contains(check)))) {
            this.appedHeader(node);
            this.appedSemantic(node);
            this.appendTranslation(replace);
            this.sb.append(System.lineSeparator());
        }
    }

    public void logDocComment(int offset, String source, String replace, Object docComment, INode context) {
        if (this.logPath == null || context == null) {
            return;
        }
        String check = source;
        Set<String> translation = this.logTransList.get(check);
        if (StringUtils.isNotEmpty((String)replace)) {
            check = replace;
        }
        if (check != null && (!StringUtils.isBlank((String)this.logPattern) && check.matches(this.logPattern) || translation != null && (translation.isEmpty() || translation.contains(check)))) {
            this.appedDocCommentHeader(offset, source.length(), context);
            this.appedDocCommentSemantic(docComment, context);
            this.appendTranslation(replace);
            this.sb.append(System.lineSeparator());
        }
    }

    private String variableTypeToString(Variable variable) {
        if (variable.getTypeStateProvider() == null) {
            return "TypeStateProvider = null;";
        }
        return variable.getTypeStateProvider().get(TypeSystemMode.NORMAL).getAll().stream().map(this::variableTypeStateToString).collect(Collectors.joining(" ### "));
    }

    private String variableTypeStateToString(VariableTypeState state) {
        StringBuilder sb = new StringBuilder();
        sb.append("VariableName: ");
        if (state == null) {
            sb.append("null");
            return sb.toString();
        }
        if (state.getVariable() != null) {
            sb.append(state.getVariable().getName());
        } else {
            sb.append("null");
        }
        sb.append("; TypeSize: ");
        sb.append(state.getTypesSize());
        sb.append("; offset: ");
        sb.append(state.getOffset());
        sb.append("; BlockOffset: ");
        sb.append(state.getBlockOffset());
        sb.append("; Environments: ");
        sb.append(state.getEnvironments());
        sb.append("; ChildVariableName: ");
        if (state.getChildState().iterator().hasNext()) {
            IExpressionTypeState item = (IExpressionTypeState)state.getChildState().iterator().next();
            if (!(item instanceof VariableTypeState)) {
                sb.append(item);
                return sb.toString();
            }
            VariableTypeState childState = (VariableTypeState)item;
            if (childState.getVariable() == null) {
                sb.append("null");
            } else {
                sb.append(childState.getVariable().getName());
            }
            sb.append("; ParentStateTypeSize: ");
            sb.append(childState.getTypesSize());
            sb.append("; ParentTypeNames: ");
            sb.append(this.getTypeNames(childState));
            sb.append("; CycleNumber: ");
            if (state instanceof VariableTreeTypeState && ((VariableTreeTypeState)state).getPrevChildrenNumTypes().containsKey(childState)) {
                sb.append(((VariableTreeTypeState.CurrentNumTypesNumVisiting)((VariableTreeTypeState)state).getPrevChildrenNumTypes().get((Object)childState)).numVisiting);
            } else {
                sb.append(-1);
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    private String getTypeNames(VariableTypeState state) {
        StringBuilder builder = new StringBuilder();
        state.getTypes().forEach(type -> {
            StringBuilder stringBuilder2 = builder.append(McoreUtil.getTypeName((TypeItem)type)).append(';');
        });
        return builder.toString();
    }
}

