/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.v8.dt.ContextDefCacheCleaner;
import com.e1c.langtool.v8.dt.IContextDefCacheProviderCleanable;
import com.e1c.langtool.v8.dt.bsl.translator.ContextDefCache;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class ContextDefBslCacheProvider
implements RemovalListener<Pair<IProject, Boolean>, ContextDefCache>,
IContextDefCacheProviderCleanable {
    private static final long EXPARATION_MINUTES = 10L;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private Provider<ContextDefCache> fContextDefCacheProvider;
    private final Cache<Pair<IProject, Boolean>, ContextDefCache> cache = this.newCache();
    private final ContextDefCacheCleaner cacheCleaner = new ContextDefCacheCleaner();

    public ContextDefCache getContextDefCache(EObject context, boolean isRussian) {
        IProject project = this.resourceLookup.getProject(context);
        if (project == null) {
            return null;
        }
        Pair key = new Pair((Object)project, (Object)isRussian);
        try {
            return (ContextDefCache)this.cache.get((Object)key, () -> {
                ContextDefCache contextDef = (ContextDefCache)this.fContextDefCacheProvider.get();
                contextDef.initialize(context, isRussian);
                this.cacheCleaner.init((IContextDefCacheProviderCleanable)this, project, isRussian);
                return contextDef;
            });
        }
        catch (ExecutionException e) {
            BslPlugin.logError(e);
            return null;
        }
    }

    public void onRemoval(RemovalNotification<Pair<IProject, Boolean>, ContextDefCache> notification) {
        this.cacheCleaner.dispose((IProject)((Pair)notification.getKey()).getKey());
        ((ContextDefCache)notification.getValue()).clear();
    }

    public void clearCache(IProject project, boolean isRussian) {
        Pair key = new Pair((Object)project, (Object)isRussian);
        this.cache.invalidate((Object)key);
    }

    private Cache<Pair<IProject, Boolean>, ContextDefCache> newCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)this).build();
    }
}

