/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Expression;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.ForEachStatement;
import com._1c.g5.v8.dt.bsl.model.IndexAccess;
import com._1c.g5.v8.dt.bsl.model.Invocation;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.util.BslUtil;
import com._1c.g5.v8.dt.bsl.validation.BslPreferences;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.dcs.parameters.DcsAvailableParameter;
import com._1c.g5.v8.dt.dcs.parameters.DcsAvailableParameterCollection;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsOutputParameters;
import com._1c.g5.v8.dt.dcs.path.DcsPathException;
import com._1c.g5.v8.dt.mcore.ContextDef;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.Method;
import com._1c.g5.v8.dt.mcore.Property;
import com._1c.g5.v8.dt.mcore.Type;
import com._1c.g5.v8.dt.mcore.util.Environments;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.IEObjectProvider;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.translator.SessionCache;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public class ContextDefCache
implements SessionCache {
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private BslPreferences bslPreferences;
    @Inject
    private IConfigurationProvider configurationProvider;
    private Map<String, Set<Translation>> properties = null;
    private Map<String, Set<MethodTranslation>> methods = null;
    private volatile boolean initialized = false;
    private final Map<String, Set<Type>> memberToDefiningType = new TreeMap<String, Set<Type>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Type, Map<String, String>> typeToMemberTranslations = new HashMap<Type, Map<String, String>>();

    public void clear() {
        this.properties = null;
        this.methods = null;
        this.initialized = false;
    }

    public String getMethodOrPropertyName(FeatureAccess featureAccess, Environments environments) {
        this.checkAccess();
        String name = featureAccess.getName();
        if (name == null) {
            return null;
        }
        EObject featureAccessContainer = featureAccess.eContainer();
        boolean isMethod = BslUtil.getInvocation((FeatureAccess)featureAccess) != null;
        Supplier<String> ambiguityResolver = () -> {
            SortedSet<String> contextSensitiveTranslations;
            if (featureAccess instanceof DynamicFeatureAccess && (contextSensitiveTranslations = this.findContextSensitiveTranslations((DynamicFeatureAccess)featureAccess)).size() == 1) {
                return contextSensitiveTranslations.first();
            }
            return null;
        };
        if (isMethod) {
            int params = ((Invocation)featureAccessContainer).getParams().size();
            return ContextDefCache.getTranslationForEnvironment(name, this.methods, environments, translation -> translation.getEnvs().containsAny(environments) && ContextDefCache.hasMatchingParamList(translation, params), ambiguityResolver);
        }
        return ContextDefCache.getTranslationForEnvironment(name, this.properties, environments, translation -> translation.getEnvs().containsAny(environments), ambiguityResolver);
    }

    public String getPropertyName(String name, Environments environments, List<String> otherProperties) {
        if (name == null) {
            return null;
        }
        this.checkAccess();
        Supplier<String> ambiguityResolver = () -> {
            SortedSet<String> clarifiedTranslations;
            if (otherProperties.size() > 1 && (clarifiedTranslations = this.getClarifiedTranslations(name, otherProperties, false, false)).size() == 1) {
                return clarifiedTranslations.first();
            }
            return null;
        };
        return ContextDefCache.getTranslationForEnvironment(name, this.properties, environments, translation -> translation.getEnvs().containsAny(environments), ambiguityResolver);
    }

    public Set<String> getPropertyTranslations(String name, Environments environments) {
        if (name == null) {
            return Collections.emptySet();
        }
        this.checkAccess();
        Set<Translation> translations = this.properties.get(name);
        if (translations != null) {
            return translations.stream().filter(translation -> translation.getEnvs().containsAny(environments)).map(Translation::getValue).collect(Collectors.toCollection(TreeSet::new));
        }
        return Collections.emptySet();
    }

    public Set<String> getMethodTranslations(String name, Environments environments) {
        if (name == null) {
            return Collections.emptySet();
        }
        this.checkAccess();
        Set<MethodTranslation> translations = this.methods.get(name);
        if (translations != null) {
            return translations.stream().filter(translation -> translation.getEnvs().containsAny(environments)).map(Translation::getValue).collect(Collectors.toCollection(TreeSet::new));
        }
        return Collections.emptySet();
    }

    public SortedSet<String> getClarifiedTranslations(String memberName, List<String> accessedMembers, boolean requiredToBeIterable, boolean requiredToBeIndexable) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Set<Type> ambiguousFeatureDefiningTypes = this.getDefiningTypes(memberName);
        ContextDefCache.filterIterableIndexableTypes(ambiguousFeatureDefiningTypes, requiredToBeIterable, requiredToBeIndexable);
        HashSet<Type> definingTypes = null;
        for (String accessedMemberName : accessedMembers) {
            HashSet<Type> memberDefiningTypes = new HashSet<Type>(this.getDefiningTypes(accessedMemberName));
            memberDefiningTypes.retainAll(ambiguousFeatureDefiningTypes);
            if (memberDefiningTypes.isEmpty()) continue;
            if (definingTypes == null) {
                definingTypes = memberDefiningTypes;
                continue;
            }
            definingTypes.retainAll(memberDefiningTypes);
        }
        if (definingTypes != null && !definingTypes.isEmpty()) {
            for (Type type : definingTypes) {
                String translation = this.getTranslation(type, memberName);
                if (!StringUtils.isNotEmpty((String)translation)) continue;
                result.add(translation);
            }
        }
        return result;
    }

    public SortedSet<String> findContextSensitiveTranslations(DynamicFeatureAccess featureAccess) {
        com._1c.g5.v8.dt.bsl.model.Method method = (com._1c.g5.v8.dt.bsl.model.Method)EcoreUtil2.getContainerOfType((EObject)featureAccess, com._1c.g5.v8.dt.bsl.model.Method.class);
        if (method != null) {
            boolean shouldBeIterable = false;
            boolean shouldBeIndexable = false;
            String memberName = ContextDefCache.getMemberName(featureAccess);
            Expression featureSource = featureAccess.getSource();
            ArrayList<String> accessedMembers = new ArrayList<String>();
            TreeIterator iterator = method.eAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (object instanceof DynamicFeatureAccess) {
                    DynamicFeatureAccess anotherDynamicFeature = (DynamicFeatureAccess)object;
                    if (!ContextDefCache.expressionsEqual(featureSource, anotherDynamicFeature.getSource()) || anotherDynamicFeature.getName() == null) continue;
                    accessedMembers.add(ContextDefCache.getMemberName(anotherDynamicFeature));
                    continue;
                }
                if (object instanceof ForEachStatement) {
                    if (!ContextDefCache.expressionsEqual(featureSource, ((ForEachStatement)object).getCollection())) continue;
                    shouldBeIterable = true;
                    continue;
                }
                if (!(object instanceof IndexAccess) || !ContextDefCache.expressionsEqual(featureSource, ((IndexAccess)object).getSource())) continue;
                shouldBeIndexable = true;
            }
            return this.getClarifiedTranslations(memberName, accessedMembers, shouldBeIterable, shouldBeIndexable);
        }
        return Collections.emptySortedSet();
    }

    private static boolean expressionsEqual(Expression firstExpression, Expression secondExpression) {
        String firstExpresssionString = ContextDefCache.expressionToString(firstExpression);
        String secondExpresssionString = ContextDefCache.expressionToString(secondExpression);
        return firstExpresssionString != null && secondExpresssionString != null && firstExpresssionString.equals(secondExpresssionString);
    }

    private static String expressionToString(Expression expression) {
        if (expression instanceof StaticFeatureAccess) {
            return ((StaticFeatureAccess)expression).getName();
        }
        if (expression instanceof DynamicFeatureAccess || expression instanceof IndexAccess) {
            StringBuilder builder = new StringBuilder();
            Object current = expression;
            while (current instanceof FeatureAccess || current instanceof IndexAccess) {
                if (builder.length() > 0) {
                    builder.insert(0, ".");
                }
                if (current instanceof IndexAccess) {
                    builder.insert(0, "[]");
                    current = ((IndexAccess)current).getSource();
                    continue;
                }
                if (current.eContainer() instanceof Invocation) {
                    builder.insert(0, "()");
                }
                builder.insert(0, ((FeatureAccess)current).getName());
                current = current instanceof DynamicFeatureAccess ? ((DynamicFeatureAccess)current).getSource() : null;
            }
            return builder.toString();
        }
        return null;
    }

    private static void filterIterableIndexableTypes(Set<Type> types, boolean shouldBeIterable, boolean shouldBeIndexable) {
        if (shouldBeIterable || shouldBeIndexable) {
            Iterator<Type> iterator = types.iterator();
            while (iterator.hasNext()) {
                Type type = iterator.next();
                if ((!shouldBeIterable || type.isIterable()) && (!shouldBeIndexable || type.isIndexAccessible())) continue;
                iterator.remove();
            }
        }
    }

    public Set<Type> getDefiningTypes(String memberName) {
        this.checkAccess();
        HashSet<Type> result = new HashSet<Type>();
        Set<Type> definingTypes = this.memberToDefiningType.get(memberName);
        if (definingTypes != null) {
            result.addAll(definingTypes);
        }
        return result;
    }

    public String getTranslation(Type type, String memberName) {
        this.checkAccess();
        Map<String, String> typeMembers = this.typeToMemberTranslations.get(type);
        if (typeMembers != null) {
            return typeMembers.get(memberName);
        }
        return null;
    }

    private static String getMemberName(DynamicFeatureAccess featureAccess) {
        String memberName = featureAccess.getName();
        boolean isMethod = featureAccess.eContainer() instanceof Invocation && ((Invocation)featureAccess.eContainer()).getMethodAccess().equals(featureAccess);
        return isMethod ? memberName + "()" : memberName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(EObject context, boolean isRussian) throws DcsPathException {
        if (!this.initialized) {
            ContextDefCache contextDefCache = this;
            synchronized (contextDefCache) {
                this.init(context, isRussian);
                this.initialized = true;
            }
        }
    }

    private static <T extends Translation> String getTranslationForEnvironment(String name, Map<String, Set<T>> translationMap, Environments environments, Predicate<T> filter, Supplier<String> ambiguityResolver) {
        Set<T> translationSet = translationMap.get(name);
        if (translationSet != null) {
            String proposedTranslation;
            Map<Boolean, List<Translation>> groupedTranslations = translationSet.stream().filter(filter).collect(Collectors.groupingBy(translation -> translation.getEnvs().containsAll(environments)));
            List<Translation> translations = groupedTranslations.get(true);
            if (translations == null) {
                translations = groupedTranslations.get(false);
            }
            if ((proposedTranslation = translations == null || translations.size() != 1 ? ambiguityResolver.get() : null) != null) {
                return proposedTranslation;
            }
            if (translations != null) {
                return translations.stream().max(Comparator.comparing(Translation::getUseCount)).map(Translation::getValue).orElse(null);
            }
        }
        return null;
    }

    private void checkAccess() {
        if (!this.initialized) {
            throw new IllegalAccessError("Cache is not initialized yet.");
        }
    }

    private void init(EObject context, boolean isRussian) throws DcsPathException {
        Object translation;
        if (this.initialized) {
            return;
        }
        Version version = this.runtimeVersionSupport.getRuntimeVersionOrDefault(context, Version.LATEST);
        IEObjectProvider provider = IEObjectProvider.Registry.INSTANCE.get(McorePackage.Literals.TYPE_ITEM, version);
        Iterable items = provider.getEObjectDescriptions(o -> true);
        TreeMap<String, Map<Environments, Map<String, AtomicInteger>>> propertiesData = new TreeMap<String, Map<Environments, Map<String, AtomicInteger>>>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, Map> methodsData = new TreeMap<String, Map>(String.CASE_INSENSITIVE_ORDER);
        this.addDcsOutputParameters(context, propertiesData, version);
        for (IEObjectDescription item : items) {
            Type typeObject;
            ContextDef contextDef;
            EObject eObject = EcoreUtil.resolve((EObject)item.getEObjectOrProxy(), (EObject)context);
            if (!(eObject instanceof Type) || (contextDef = (typeObject = (Type)eObject).getContextDef()) == null) continue;
            Map<String, Pair<String, Environments>> uniqueProperties = this.getUniqueProperties(contextDef, isRussian);
            for (Map.Entry<String, Pair<String, Environments>> entry : uniqueProperties.entrySet()) {
                Pair<String, Environments> value = entry.getValue();
                String source = entry.getKey();
                translation = (String)value.getKey();
                Environments environments = (Environments)value.getValue();
                this.memberToDefiningType.computeIfAbsent(source, unusedKey -> new HashSet()).add(typeObject);
                this.typeToMemberTranslations.computeIfAbsent(typeObject, unusedKey -> new TreeMap(String.CASE_INSENSITIVE_ORDER)).put(source, translation);
                if (source.equalsIgnoreCase((String)translation)) continue;
                Map environmentsMap = propertiesData.computeIfAbsent(source, unusedName -> new HashMap());
                Map translationsMap = environmentsMap.computeIfAbsent(environments, unusedEnvironments -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
                AtomicInteger translationCounter = translationsMap.computeIfAbsent(translation, unusedTranslation -> new AtomicInteger(0));
                translationCounter.incrementAndGet();
            }
            Map<String, Triple<Method, String, Environments>> uniqueMethods = this.getUniqueMethods(contextDef, isRussian);
            for (Map.Entry<String, Triple<Method, String, Environments>> entry : uniqueMethods.entrySet()) {
                Triple<Method, String, Environments> value = entry.getValue();
                String source = entry.getKey();
                Method method = (Method)value.getFirst();
                String translation2 = (String)value.getSecond();
                Environments environments = (Environments)value.getThird();
                this.memberToDefiningType.computeIfAbsent(source + "()", unusedKey -> new HashSet()).add(typeObject);
                this.typeToMemberTranslations.computeIfAbsent(typeObject, unusedKey -> new TreeMap(String.CASE_INSENSITIVE_ORDER)).put(source + "()", translation2);
                if (source.equalsIgnoreCase(translation2)) continue;
                Map environmentsMap = methodsData.computeIfAbsent(source, unusedName -> new HashMap());
                Map translationsMap = environmentsMap.computeIfAbsent(environments, unusedEnvironments -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
                Pair translationMethodCounterPair = translationsMap.computeIfAbsent(translation2, unusedTranslation -> new Pair((Object)method, (Object)new AtomicInteger(0)));
                ((AtomicInteger)translationMethodCounterPair.getValue()).incrementAndGet();
            }
        }
        TreeMap<String, Set<Translation>> propertiesBuilder = new TreeMap<String, Set<Translation>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : propertiesData.entrySet()) {
            HashSet<Translation> translationSet = new HashSet<Translation>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry translationEntry : ((Map)entry2.getValue()).entrySet()) {
                    translationSet.add(new Translation((String)translationEntry.getKey(), (Environments)entry2.getKey(), ((AtomicInteger)translationEntry.getValue()).get()));
                }
            }
            propertiesBuilder.put((String)entry.getKey(), Set.copyOf(translationSet));
        }
        TreeMap<String, Set<MethodTranslation>> treeMap = new TreeMap<String, Set<MethodTranslation>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : methodsData.entrySet()) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Map.Entry environmentEntry : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry<String, Object> entry3 : ((Map)environmentEntry.getValue()).entrySet()) {
                    Pair methodPair = (Pair)entry3.getValue();
                    translation = new MethodTranslation(entry3.getKey(), (Environments)environmentEntry.getKey(), (Method)methodPair.getKey(), ((AtomicInteger)methodPair.getValue()).get());
                    hashSet.add(translation);
                }
            }
            treeMap.put((String)entry.getKey(), Set.copyOf(hashSet));
        }
        this.properties = propertiesBuilder;
        this.methods = treeMap;
        if (BslPlugin.getDefault().isDebugging()) {
            System.out.println(MessageFormat.format("Properties Count {0} ", this.properties.size()));
            System.out.println(MessageFormat.format("Methods Count {0} ", this.methods.size()));
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                System.out.println(MessageFormat.format("Property Key {0} has multiple translations: {1} ", entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<Object, Object> entry : this.methods.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                System.out.println(MessageFormat.format("Method Key {0} has multiple translations: {1} ", entry.getKey(), entry.getValue()));
            }
        }
    }

    private void addDcsOutputParameters(EObject context, Map<String, Map<Environments, Map<String, AtomicInteger>>> propertiesData, Version version) throws DcsPathException {
        int translationScript;
        int sourceScript;
        String languageCode;
        boolean isRu;
        Configuration configuration = this.configurationProvider.getConfiguration(context);
        boolean bl = isRu = configuration != null && configuration.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        if (isRu) {
            languageCode = "ru";
            sourceScript = 1;
            translationScript = 0;
        } else {
            languageCode = "en";
            sourceScript = 0;
            translationScript = 1;
        }
        DcsAvailableParameterCollection params = new DcsOutputParameters(version, languageCode).getAvailableParameters().getParameters();
        Environments environments = this.bslPreferences.getLoadEnvs(context);
        int count = params.itemsCount();
        int i = 0;
        while (i < count) {
            DcsAvailableParameterCollection subs = params.getItemAt(i).getSubParameters();
            int subsCount = subs.itemsCount();
            if (subsCount > 0) {
                int j = 0;
                while (j < subsCount) {
                    String translation;
                    DcsAvailableParameter sub = subs.getItemAt(j);
                    String source = sub.getName(sourceScript).getDataPath().getChildPath().toString();
                    if (!source.equalsIgnoreCase(translation = sub.getName(translationScript).getDataPath().getChildPath().toString())) {
                        Map environmentsMap = propertiesData.computeIfAbsent(source, unusedName -> new HashMap());
                        Map translationsMap = environmentsMap.computeIfAbsent(environments, unusedEnvironments -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
                        AtomicInteger translationCounter = translationsMap.computeIfAbsent(translation, unusedTranslation -> new AtomicInteger(0));
                        translationCounter.incrementAndGet();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private Map<String, Pair<String, Environments>> getUniqueProperties(ContextDef contextDef, boolean isRussian) {
        TreeMap<String, List> rawProperties = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (Property property : contextDef.allProperties()) {
            String translation;
            String source = isRussian ? property.getName() : property.getNameRu();
            String string = translation = isRussian ? property.getNameRu() : property.getName();
            if (StringUtils.isNullOrEmpty((String)source) || StringUtils.isNullOrEmpty((String)translation)) continue;
            Environments environments = property.getEnvironments();
            source = source.trim();
            translation = translation.trim();
            boolean deprecated = property.getDeprecatedSince() != null;
            rawProperties.computeIfAbsent(source, k -> new ArrayList()).add(Tuples.create((Object)deprecated, (Object)translation, (Object)environments));
        }
        rawProperties.forEach((k, v) -> Collections.sort(v, (o1, o2) -> {
            int result = ((Boolean)o1.getFirst()).compareTo((Boolean)o2.getFirst());
            return result == 0 ? ((String)o1.getSecond()).compareTo((String)o2.getSecond()) : result;
        }));
        return rawProperties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            Triple first = (Triple)((List)e.getValue()).get(0);
            return new Pair((Object)((String)first.getSecond()), (Object)((Environments)first.getThird()));
        }));
    }

    private Map<String, Triple<Method, String, Environments>> getUniqueMethods(ContextDef contextDef, boolean isRussian) {
        TreeMap<String, List> rawProperties = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (Method method : contextDef.allMethods()) {
            String translation;
            String source = isRussian ? method.getName() : method.getNameRu();
            String string = translation = isRussian ? method.getNameRu() : method.getName();
            if (StringUtils.isNullOrEmpty((String)source) || StringUtils.isNullOrEmpty((String)translation)) continue;
            Environments environments = method.getEnvironments();
            source = source.trim();
            translation = translation.trim();
            boolean deprecated = method.getDeprecatedSince() != null;
            rawProperties.computeIfAbsent(source, k -> new ArrayList()).add(new Pair((Object)deprecated, (Object)Tuples.create((Object)method, (Object)translation, (Object)environments)));
        }
        rawProperties.forEach((k, v) -> Collections.sort(v, (o1, o2) -> {
            int result = ((Boolean)o2.getKey()).compareTo((Boolean)o1.getKey());
            return result == 0 ? ((String)((Triple)o1.getValue()).getSecond()).compareTo((String)((Triple)o2.getValue()).getSecond()) : result;
        }));
        return rawProperties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            Pair first = (Pair)((List)e.getValue()).get(0);
            return Tuples.create((Object)((Method)((Triple)first.getValue()).getFirst()), (Object)((String)((Triple)first.getValue()).getSecond()), (Object)((Environments)((Triple)first.getValue()).getThird()));
        }));
    }

    private static boolean hasMatchingParamList(MethodTranslation methodTranslation, int paramCount) {
        Method method = methodTranslation.getMethod();
        boolean paramSetIsEmpty = method.getParamSet().isEmpty();
        return paramCount == 0 && paramSetIsEmpty || !paramSetIsEmpty && method.actualParamSet(paramCount) != null;
    }

    private static class MethodTranslation
    extends Translation {
        private final Method method;

        public MethodTranslation(String value, Environments envs, Method method, int useCount) {
            super(value, envs, useCount);
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    private static class Translation {
        private final String value;
        private final Environments envs;
        private final int useCount;

        public Translation(String value, Environments envs, int useCount) {
            this.value = value;
            this.envs = envs;
            this.useCount = useCount;
        }

        public String getValue() {
            return this.value;
        }

        public Environments getEnvs() {
            return this.envs;
        }

        public int getUseCount() {
            return this.useCount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.envs == null ? 0 : this.envs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Translation other = (Translation)obj;
            if (this.value == null) {
                if (other.value != null) {
                    return false;
                }
            } else {
                if (!this.value.equals(other.value)) {
                    return false;
                }
                if (!this.envs.equals((Object)other.envs)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "Translation [value=" + this.value + ", envs=" + String.valueOf(this.envs) + "]";
        }
    }
}

