/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com._1c.g5.v8.dt.bsl.model.BslContextDef;
import com._1c.g5.v8.dt.bsl.model.BslContextDefFactory;
import com._1c.g5.v8.dt.bsl.model.BslIndexPackage;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleContextDefIndex;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.ContextDef;
import com.e1c.g5.dt.core.api.naming.INamingService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Singleton
public class ModuleContextDefProvider {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private INamingService namingService;

    public ContextDef getContextDef(EObject object) {
        Assert.isNotNull((Object)object);
        return this.getContextDef(object.eResource());
    }

    public ContextDef getContextDef(Resource resource) {
        Assert.isNotNull((Object)resource);
        ContextDefAdapter adapter = (ContextDefAdapter)EcoreUtil.getExistingAdapter((Notifier)resource, ContextDefAdapter.class);
        if (adapter == null) {
            BslContextDef contextDef = null;
            if (resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Module) {
                Module module = (Module)resource.getContents().get(0);
                contextDef = this.getContextDef(module);
            }
            if (contextDef == null) {
                contextDef = BslContextDefFactory.eINSTANCE.createBslContextDef();
            }
            adapter = new ContextDefAdapter((ContextDef)contextDef);
            resource.eAdapters().add((Object)adapter);
        }
        return adapter.getContextDef();
    }

    public void clearCache(Resource resource) {
        Assert.isNotNull((Object)resource);
        ContextDefAdapter adapter = (ContextDefAdapter)EcoreUtil.getExistingAdapter((Notifier)resource, ContextDefAdapter.class);
        if (adapter != null) {
            resource.eAdapters().remove((Object)adapter);
        }
    }

    protected ContextDef getContextDef(Module module) {
        IProject project = this.resourceLookup.getProject((EObject)module);
        ContextDef contextDef = null;
        URI moduleUri = EcoreUtil.getURI((EObject)module);
        EObject proxyContextDef = (EObject)this.modelManager.executeReadOnlyTask(project, transaction -> {
            ModuleContextDefIndex index = (ModuleContextDefIndex)transaction.getTopObjectByFqn(this.namingService.getDependentObjectFqnAsString(moduleUri, BslIndexPackage.Literals.MODULE_CONTEXT_DEF_INDEX));
            if (index == null) {
                return null;
            }
            return index.getContextDef();
        });
        contextDef = proxyContextDef instanceof BslContextDef && !proxyContextDef.eIsProxy() ? (ContextDef)proxyContextDef : module.getContextDef();
        return contextDef;
    }

    private final class ContextDefAdapter
    extends AdapterImpl {
        private final ContextDef contextDef;

        public ContextDefAdapter(ContextDef contextDef) {
            this.contextDef = contextDef;
        }

        public ContextDef getContextDef() {
            return this.contextDef;
        }

        public boolean isAdapterForType(Object type) {
            return type != null && type == ((Object)((Object)this)).getClass();
        }
    }
}

