/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.translator;

import com.e1c.langtool.v8.dt.bsl.translator.VariableDuplicatesResolveLevel;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TranslatorProperties {
    public static final String MASK_IMPLICIT_VARIABLES = "maskImplicitVariables";
    public static final String CLEAR_CODE_COMMENTS = "clearCodeComments";
    public static final String CLEAR_METHOD_DESCRIPTIONS = "clearMethodDescriptions";
    public static final String CHECK_VARIABLE_DUPLICATES_RESOLVE_LEVEL = "checkVariableDuplicatesResolveLevel";
    public static final String STRING_LITERAL_LINES_FULL_TRANSLATION_STORED_PRIORITY = "stringLiteralLinesFullTranslationStoredPriority";
    public static final String COMPUTE_QUERY_RESULT = "computeQueryResult";
    public static final String ENABLE_EXTENDED_NSTR_FEATURE_KEYS = "enableExtendedNStrFeatureKeys";
    public static final String ENABLE_TAGPART_IN_DOC_COMMENT = "enableTagsInDocComment";
    public static final String ALPHABETICAL_LANGUAGE_ORDER_IN_NSTR = "alphabeticalLanguageOrderInNStr";
    private final IProject project;
    private boolean maskImplicitVariables;
    private boolean clearCodeComments;
    private boolean clearMethodDescriptions = true;
    private VariableDuplicatesResolveLevel checkVariableDuplicatesResolveLevel;
    private boolean stringLiteralLinesFullTranslationStoredPriority;
    private boolean computeQueryResult;
    private boolean enableExtendedNStrFeatureKeys;
    private boolean enableTagPartInDocComment;
    private boolean alphabeticalLanguageOrderInNStr;

    public TranslatorProperties(IProject project) {
        this.project = project;
    }

    public boolean maskImplicitVariables() {
        return this.maskImplicitVariables;
    }

    public boolean clearCodeComments() {
        return this.clearCodeComments;
    }

    public boolean clearMethodDescriptions() {
        return this.clearMethodDescriptions;
    }

    public VariableDuplicatesResolveLevel getCheckVariableDuplicatesResolveLevel() {
        return this.checkVariableDuplicatesResolveLevel;
    }

    public void setMaskImplicitVariables(boolean maskImplicitVariables) {
        if (this.maskImplicitVariables == maskImplicitVariables) {
            return;
        }
        this.maskImplicitVariables = maskImplicitVariables;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(MASK_IMPLICIT_VARIABLES, maskImplicitVariables);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setClearCodeComments(boolean clearCodeComments) {
        if (this.clearCodeComments == clearCodeComments) {
            return;
        }
        this.clearCodeComments = clearCodeComments;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(CLEAR_CODE_COMMENTS, clearCodeComments);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setClearMethodDescriptions(boolean clearMethodDescriptions) {
        if (this.clearMethodDescriptions == clearMethodDescriptions) {
            return;
        }
        this.clearMethodDescriptions = clearMethodDescriptions;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(CLEAR_METHOD_DESCRIPTIONS, clearMethodDescriptions);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setCheckVariableDuplicatesResolveLevel(VariableDuplicatesResolveLevel value) {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.put(CHECK_VARIABLE_DUPLICATES_RESOLVE_LEVEL, value.getLevelName());
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public boolean isStringLiteralLinesFullTranslationStoredPriority() {
        return this.stringLiteralLinesFullTranslationStoredPriority;
    }

    public boolean isEnableExtendedNStrFeatureKeys() {
        return this.enableExtendedNStrFeatureKeys;
    }

    public void setEnableExtendedNStrFeatureKeys(boolean enableExtendedNStrFeatureKeys) {
        if (this.enableExtendedNStrFeatureKeys == enableExtendedNStrFeatureKeys) {
            return;
        }
        this.enableExtendedNStrFeatureKeys = enableExtendedNStrFeatureKeys;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(ENABLE_EXTENDED_NSTR_FEATURE_KEYS, enableExtendedNStrFeatureKeys);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            BslPlugin.logError(e);
        }
    }

    public void setStringLiteralLinesFullTranslationStoredPriority(boolean stringLiteralLinesFullTranslationStoredPriority) {
        if (this.stringLiteralLinesFullTranslationStoredPriority == stringLiteralLinesFullTranslationStoredPriority) {
            return;
        }
        this.stringLiteralLinesFullTranslationStoredPriority = stringLiteralLinesFullTranslationStoredPriority;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(STRING_LITERAL_LINES_FULL_TRANSLATION_STORED_PRIORITY, stringLiteralLinesFullTranslationStoredPriority);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public boolean isComputeQueryResult() {
        return this.computeQueryResult;
    }

    public void setComputeQueryResult(boolean computeQueryResult) {
        if (this.computeQueryResult == computeQueryResult) {
            return;
        }
        this.computeQueryResult = computeQueryResult;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(COMPUTE_QUERY_RESULT, computeQueryResult);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public boolean isEnableTagPartInDocComment() {
        return this.enableTagPartInDocComment;
    }

    public void setEnableTagPartInDocComment(boolean enableTagPartInDocComment) {
        if (this.enableTagPartInDocComment == enableTagPartInDocComment) {
            return;
        }
        this.enableTagPartInDocComment = enableTagPartInDocComment;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translatorProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(ENABLE_TAGPART_IN_DOC_COMMENT, enableTagPartInDocComment);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            BslPlugin.logError(e);
        }
    }

    public boolean isAlphabeticalLanguageOrderInNStr() {
        return this.alphabeticalLanguageOrderInNStr;
    }

    public void setAlphabeticalLanguageOrderInNStr(boolean alphabeticalLanguageOrderInNStr) {
        if (this.alphabeticalLanguageOrderInNStr == alphabeticalLanguageOrderInNStr) {
            return;
        }
        this.alphabeticalLanguageOrderInNStr = alphabeticalLanguageOrderInNStr;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences pluginPreferences = projectScope.getNode("com.e1c.langtool.v8.dt.bsl");
        if (pluginPreferences == null) {
            return;
        }
        Preferences translatorPreferences = pluginPreferences.node("translatorProperties");
        if (translatorPreferences == null) {
            return;
        }
        translatorPreferences.putBoolean(ALPHABETICAL_LANGUAGE_ORDER_IN_NSTR, alphabeticalLanguageOrderInNStr);
        try {
            translatorPreferences.flush();
        }
        catch (BackingStoreException e) {
            BslPlugin.logError(e);
        }
    }

    public void read(Preferences preferences) {
        this.maskImplicitVariables = preferences.getBoolean(MASK_IMPLICIT_VARIABLES, false);
        this.clearCodeComments = preferences.getBoolean(CLEAR_CODE_COMMENTS, false);
        this.clearMethodDescriptions = preferences.getBoolean(CLEAR_METHOD_DESCRIPTIONS, false);
        this.checkVariableDuplicatesResolveLevel = this.getVariableDuplicatesResolveLevel(preferences, CHECK_VARIABLE_DUPLICATES_RESOLVE_LEVEL, VariableDuplicatesResolveLevel.CHECK_KEYWORDS);
        this.stringLiteralLinesFullTranslationStoredPriority = preferences.getBoolean(STRING_LITERAL_LINES_FULL_TRANSLATION_STORED_PRIORITY, false);
        this.computeQueryResult = preferences.getBoolean(COMPUTE_QUERY_RESULT, false);
        this.enableExtendedNStrFeatureKeys = preferences.getBoolean(ENABLE_EXTENDED_NSTR_FEATURE_KEYS, false);
        this.enableTagPartInDocComment = preferences.getBoolean(ENABLE_TAGPART_IN_DOC_COMMENT, false);
        this.alphabeticalLanguageOrderInNStr = preferences.getBoolean(ALPHABETICAL_LANGUAGE_ORDER_IN_NSTR, false);
    }

    private VariableDuplicatesResolveLevel getVariableDuplicatesResolveLevel(Preferences preferences, String key, VariableDuplicatesResolveLevel defaultValue) {
        return VariableDuplicatesResolveLevel.parseValidationLevel(preferences.get(key, defaultValue.getLevelName()));
    }
}

