/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.DynamicFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.resource.DynamicFeatureAccessComputer;
import com._1c.g5.v8.dt.mcore.Environmental;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class DynamicFeatureAccessTranslationCheck
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "dynamic-feature-access-translation";
    private static final String EXCLUDE_NAME_PATTERN_PARAMETERN_NAME = "excludeFeatureNamePattern";
    @Inject
    private DynamicFeatureAccessComputer dynamicFeatureAccessComputer;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.DynamicFeatureAccessTranslationCheck_title).description(Messages.DynamicFeatureAccessTranslationCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.DYNAMIC_FEATURE_ACCESS}).parameter(EXCLUDE_NAME_PATTERN_PARAMETERN_NAME, String.class, "", Messages.DynamicFeatureAccessTranslationCheck_Exclude_feature_name_pattern);
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        DynamicFeatureAccess featureAccess = (DynamicFeatureAccess)object;
        String excludeNamePattern = parameters.getString(EXCLUDE_NAME_PATTERN_PARAMETERN_NAME);
        if (featureAccess.getName() == null || StringUtils.isNotEmpty((String)excludeNamePattern) && Pattern.compile(excludeNamePattern, 256).matcher(featureAccess.getName()).matches()) {
            return;
        }
        this.checkTranslation((EObject)featureAccess, resultAcceptor, parameters, monitor);
    }

    protected ICollectingParameters getParameters(IProject project, ICheckParameters parameters) {
        return CollectingParameters.builder().collectModel().collectInterface().collectComputedStrings().enableCache().build();
    }

    protected String getTranslation(IProject project, FeatureValue featureValue, TranslateLanguage language, EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters) {
        Environmental environmental;
        DynamicFeatureAccess featureAccess;
        List features;
        if (object instanceof DynamicFeatureAccess && featureValue.getContextKey().getFeatureSettings() == BslFeatureSettings.Literals.FEATURE_ACCESS__NAME && !BslUtils.isEmptySource(features = this.dynamicFeatureAccessComputer.resolveObject((FeatureAccess)(featureAccess = (DynamicFeatureAccess)object), (environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class)).environments(), true))) {
            return featureAccess.getName();
        }
        return super.getTranslation(project, featureValue, language, object, resultAcceptor, parameters);
    }
}

