/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslFactory;
import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.RegionPreprocessor;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.bsl.model.VariablesScopeSpec;
import com._1c.g5.v8.dt.mcore.DerivedProperty;
import com._1c.g5.v8.dt.mcore.Environmental;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.bsl.BslGrammarTokens;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class NotAllowedTranslationCheck
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "module-not-allowed-translation";
    @Inject
    private IScopeProvider bslScope;
    @Inject
    private BslGrammarTokens grammarTokens;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.NotAllowedTranslationCheck_title).description(Messages.NotAllowedTranslationCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.VARIABLE, BslPackage.Literals.SIMPLE_STATEMENT, BslPackage.Literals.METHOD, BslPackage.Literals.REGION_PREPROCESSOR});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, AbstractTranslationValidator.TranslationValidatorContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof Method) {
            this.checkTranslation((NamedElement)((Method)object), resultAcceptor, context, monitor);
        } else if (object instanceof RegionPreprocessor) {
            this.checkTranslation((NamedElement)((RegionPreprocessor)object), resultAcceptor, context, monitor);
        }
        Variable variable = null;
        if (object instanceof Variable) {
            variable = (Variable)object;
        }
        if (variable == null || monitor.isCanceled()) {
            return;
        }
        this.checkTranslation((NamedElement)variable, resultAcceptor, context, monitor);
    }

    private EStructuralFeature getMessageFeature() {
        return McorePackage.Literals.NAMED_ELEMENT__NAME;
    }

    private void checkTranslation(NamedElement object, BasicCheck.ResultAcceptor resultAcceptor, AbstractTranslationValidator.TranslationValidatorContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = context.getProject();
        if (project == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        if (!translatingProject.isTranslating() || translatingProject.getModelLanguages().isEmpty()) {
            return;
        }
        IFile file = context.getResourceLookup().getPlatformResource((EObject)object);
        String name = object.getName();
        if (file == null || StringUtils.isNullOrEmpty((String)name)) {
            return;
        }
        List modelLanguages = translatingProject.getModelLanguages();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME);
        for (TranslateLanguage language : modelLanguages) {
            if (monitor.isCanceled()) {
                return;
            }
            ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, name);
            String translation = this.getReader(project).getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
            if (!StringUtils.isNotEmpty((String)translation)) continue;
            if (object instanceof Method) {
                this.checkTranslation((Method)object, translation, language, resultAcceptor, monitor);
                continue;
            }
            if (object instanceof Variable) {
                this.checkTranslation((Variable)object, translation, language, resultAcceptor, context, monitor);
                continue;
            }
            if (!(object instanceof RegionPreprocessor)) continue;
            this.checkTranslation((RegionPreprocessor)object, translation, language, resultAcceptor, monitor);
        }
    }

    private void checkTranslation(Variable object, String translation, TranslateLanguage language, BasicCheck.ResultAcceptor resultAcceptor, AbstractTranslationValidator.TranslationValidatorContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.grammarTokens.getKeyword(translation, true) != null || this.grammarTokens.getKeyword(translation, false) != null) {
            this.addNotAllowedTranslationAsKeyword(object, resultAcceptor, translation, language);
            return;
        }
        VariablesScopeSpec spec = BslFactory.eINSTANCE.createVariablesScopeSpec();
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        Method method = (Method)EcoreUtil2.getContainerOfType((EObject)object, Method.class);
        spec.setModule(module);
        spec.setMethod(method);
        Environmental environmental = (Environmental)EcoreUtil2.getContainerOfType((EObject)object, Environmental.class);
        spec.setEnvironments(environmental.environments());
        URI objectsUri = EcoreUtil.getURI((EObject)object);
        IScope scope = this.bslScope.getScope((EObject)spec, BslPackage.Literals.VARIABLES_SCOPE_SPEC__VARIABLE_REF);
        for (IEObjectDescription item : scope.getAllElements()) {
            if (monitor.isCanceled()) {
                return;
            }
            URI uri = item.getEObjectURI();
            if (uri.equals(objectsUri)) continue;
            EObject property = item.getEObjectOrProxy();
            if (property.eIsProxy()) {
                property = EcoreUtil.resolve((EObject)property, (EObject)object);
            }
            if (property instanceof DerivedProperty) {
                property = ((DerivedProperty)property).getSource();
            }
            if (property == null || !(property instanceof NamedElement) && !(property instanceof MdObject)) continue;
            ArrayList<TranslateLanguage> collection = new ArrayList<TranslateLanguage>();
            collection.add(language);
            DictionaryTranslationKey key = null;
            if (property instanceof NamedElement) {
                IFile iFile = file = context != null ? context.getResourceLookup().getPlatformResource(property) : this.resourceLookup.getPlatformResource(property);
                if (file == null) {
                    key = new DictionaryTranslationKey((FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, ((NamedElement)property).getName());
                } else {
                    featureKey = this.featureKeyProvider.getFeatureKey(property, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME);
                    key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, ((NamedElement)property).getName());
                }
            } else {
                IFile iFile = file = context != null ? context.getResourceLookup().getPlatformResource(property) : this.resourceLookup.getPlatformResource(property);
                if (file == null) {
                    key = new DictionaryTranslationKey((FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, ((MdObject)property).getName());
                } else {
                    featureKey = this.featureKeyProvider.getFeatureKey(property, (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__NAME);
                    key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)MdFeatureSettings.Literals.MD_OBJECT__NAME, ((MdObject)property).getName());
                }
            }
            IProject project = context != null ? context.getProject() : this.resourceLookup.getProject((EObject)object);
            String itemTranslation = this.getReader(project).getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
            if (!translation.equalsIgnoreCase(itemTranslation)) continue;
            this.addNotAllowedTranslationMessage(object, resultAcceptor, translation, language, item.getName().toString());
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        IEObjectDescription elem = scope.getSingleElement(QualifiedName.create((String)translation));
        if (elem != null) {
            this.addNotAllowedTranslationMessage(object, resultAcceptor, translation, language, elem.getName().toString());
        }
    }

    private void checkTranslation(Method object, String translation, TranslateLanguage language, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.grammarTokens.getKeyword(translation, true) != null || this.grammarTokens.getKeyword(translation, false) != null) {
            this.addNotAllowedTranslationAsKeyword(object, resultAcceptor, translation, language);
        } else if (this.grammarTokens.getBuiltInFunction(translation, true) != null || this.grammarTokens.getBuiltInFunction(translation, false) != null) {
            this.addNotAllowedTranslationAsBuiltIn(object, resultAcceptor, translation, language);
        }
    }

    private void checkTranslation(RegionPreprocessor object, String translation, TranslateLanguage language, BasicCheck.ResultAcceptor resultAcceptor, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (this.grammarTokens.getKeyword(translation, true) != null || this.grammarTokens.getKeyword(translation, false) != null) {
            this.addNotAllowedTranslationAsKeyword(object, resultAcceptor, translation, language);
        }
    }

    private void addNotAllowedTranslationMessage(Variable object, BasicCheck.ResultAcceptor resultAcceptor, String translation, TranslateLanguage language, String property) {
        String message = MessageFormat.format(Messages.VariableTranslationValidator_Variable_has_not_allowed_translation_onto_language_equals_system_property, translation, language.getName(), property);
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }

    private void addNotAllowedTranslationAsKeyword(Variable object, BasicCheck.ResultAcceptor resultAcceptor, String translation, TranslateLanguage language) {
        String message = MessageFormat.format(Messages.VariableTranslationValidator_Variable_has_not_allowed_translation__V__onto__L__equals_bsl_keyword, translation, language.getName());
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }

    private void addNotAllowedTranslationAsKeyword(Method object, BasicCheck.ResultAcceptor resultAcceptor, String translation, TranslateLanguage language) {
        String message = MessageFormat.format(Messages.MethodTranslationValidator_Method_has_not_allowed_translation__V__onto__L__equals_bsl_keyword, translation, language.getName());
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }

    private void addNotAllowedTranslationAsBuiltIn(Method object, BasicCheck.ResultAcceptor resultAcceptor, String translation, TranslateLanguage language) {
        String message = MessageFormat.format(Messages.MethodTranslationValidator_Method_has_not_allowed_translation__V__onto__L__equals_bsl_built_in_function, translation, language.getName());
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }

    private void addNotAllowedTranslationAsKeyword(RegionPreprocessor object, BasicCheck.ResultAcceptor resultAcceptor, String translation, TranslateLanguage language) {
        String message = MessageFormat.format(Messages.RegionTranslationValidator_Region_has_not_allowed_translation__V__onto__L__equals_bsl_keyword, translation, language.getName());
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature());
    }
}

