/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class NstrLiteralPramTranslationCheck
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "nstr-param-translation";
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.NstrLiteralPramTranslationCheck_title).description(Messages.NstrLiteralPramTranslationCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"NStr"}) || !this.typeComputer.containsAnyType(literal, new String[]{"Replace-params"})) {
            return;
        }
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        IV8Project project = this.v8ProjectManager.getProject((EObject)literal);
        if (file == null || project == null || project.getDefaultLanguage() == null || project.getProject() == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project.getProject());
        if (!translatingProject.isTranslating() || translatingProject.getModelLanguages().isEmpty()) {
            return;
        }
        List modelLanguages = translatingProject.getModelLanguages();
        Map<String, String> nstr = BslUtils.getNlsLocalStrings(literal);
        String value = nstr.get(project.getDefaultLanguage().getLanguageCode());
        if (StringUtils.isNullOrEmpty((String)value)) {
            return;
        }
        Map sourceParams = Utils.getParamsMapFromNls((String)value);
        FeatureKey featureKey = this.featureKeyProvider.getKey((EObject)literal).skipLast(1);
        for (Map.Entry entry : sourceParams.entrySet()) {
            String param = (String)entry.getKey();
            ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey.append(param).append("Param"), BslFeatureSettings.Literals.STRING_LITERAL__PARAM, param);
            HashSet languagesWithoutTranslation = Sets.newHashSet();
            for (TranslateLanguage language : modelLanguages) {
                String translation = this.getReader(project.getProject()).getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
                if (!StringUtils.isNullOrEmpty((String)translation)) continue;
                languagesWithoutTranslation.add(language.getName());
            }
            if (languagesWithoutTranslation.isEmpty()) continue;
            this.addParamNoTranslationMessage((EObject)literal, param, resultAcceptor, languagesWithoutTranslation);
        }
    }

    private EStructuralFeature getMessageFeature() {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }

    private void addParamNoTranslationMessage(EObject object, String param, BasicCheck.ResultAcceptor resultAcceptor, Collection<String> languages) {
        String message = MessageFormat.format(Messages.NstrLiteralPramTranslationCheck_Replace_parameter__0__in_NStr_has_no_translation_into__1, param, String.join((CharSequence)", ", languages));
        BslCheckIssue issue = new BslCheckIssue(message, this.getMessageFeature(), -1, languages.toArray(new String[0]));
        resultAcceptor.addIssue((Issue)issue);
    }
}

