/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QueryReplaceParamValidator
extends BasicCheck {
    public static final String CHECK_ID = "module-query-replace-param";
    private static final String KEYWORD_LIKE_RU = "\u041f\u041e\u0414\u041e\u0411\u041d\u041e";
    private static final String KEYWORD_LIKE = "LIKE";
    private static final String SKIP_PARAMETER_NAME_PATTERN_PARAMETER_NAME = "skipParameterNamePattern";
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.QueryReplaceParamValidator_title).description(Messages.QueryReplaceParamValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.CODE_STYLE).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL}).parameter(SKIP_PARAMETER_NAME_PATTERN_PARAMETER_NAME, String.class, "", Messages.QueryReplaceParamValidator_Pattern_to_skip_replace_parameter_name__without__X__symbols);
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (this.typeComputer.containsAnyType(literal, LangToolDefaults.QUERY) && this.typeComputer.containsAnyType(literal, new String[]{"Replace-params"}) && !monitor.isCanceled()) {
            EList lines = literal.lines(false);
            String skipPatternString = parameters.getString(SKIP_PARAMETER_NAME_PATTERN_PARAMETER_NAME);
            Pattern skipPattern = null;
            if (StringUtils.isNotEmpty((String)skipPatternString)) {
                try {
                    skipPattern = Pattern.compile(skipPatternString, 256);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            int i = 0;
            while (i < lines.size() - 1) {
                String line = (String)lines.get(i);
                Map params = Utils.getParamsMapFromNls((String)line);
                Set<String> keys = QueryReplaceParamValidator.getKeysBeforeComment(line, params);
                if (!((keys = this.skipKeysByPattern(keys, skipPattern)).isEmpty() || QueryReplaceParamValidator.isLikeKeyword(line, params) || QueryReplaceParamValidator.isParameterInStringLiteral(line, params))) {
                    String message = QueryReplaceParamValidator.formatMessage(keys);
                    resultAcceptor.addIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, i);
                }
                ++i;
            }
        }
    }

    private Set<String> skipKeysByPattern(Set<String> keys, Pattern skipPattern) {
        if (skipPattern == null) {
            return keys;
        }
        HashSet<String> result = new HashSet<String>();
        for (String key : keys) {
            if (skipPattern.matcher(key).find()) continue;
            result.add(key);
        }
        return result;
    }

    public static boolean isLikeKeyword(String line, Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue().startsWith("%") && entry.getValue().endsWith("%")) continue;
            return false;
        }
        return line.contains(KEYWORD_LIKE_RU) || line.contains(KEYWORD_LIKE);
    }

    public static boolean isParameterInStringLiteral(String line, Map<String, String> params) {
        if (params.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            int position = line.indexOf(entry.getValue());
            if (position == -1 || position == 0 || line.length() < position + entry.getValue().length()) {
                return false;
            }
            int start = line.indexOf("\"");
            if (start <= position && line.indexOf("\"", position + entry.getValue().length()) != -1) continue;
            return false;
        }
        return true;
    }

    public static String formatMessage(Set<String> keys) {
        ArrayList<String> sorted = new ArrayList<String>(keys);
        Collections.sort(sorted);
        String message = MessageFormat.format(Messages.QueryReplaceParamValidator_Query_string_literal_cannot_contain_replace_params, String.join((CharSequence)", ", sorted));
        return message;
    }

    public static Set<String> getKeysBeforeComment(String line, Map<String, String> params) {
        int commentIndex = line.indexOf("//");
        if (commentIndex > -1) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (line.indexOf(entry.getValue()) >= commentIndex) continue;
                result.add(entry.getKey());
            }
            return result;
        }
        return params.keySet();
    }
}

