/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.bsl.validation.QueryReplaceParamValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.internal.bsl.BslPlugin;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.xtext.MonitorBasedCancelIndicator;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.CancelIndicator;

public class QuerySyntaxValidator
extends BasicCheck {
    private static final String CHECK_ID = "module-query-syntax";
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    private IStringLiteralTypeComputer typeComputer;
    @Inject
    private IDependentQuerySchemaProvider dependentModelProvider;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.QuerySyntaxValidator_title).description(Messages.QuerySyntaxValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.CRITICAL).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.ERROR).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, LangToolDefaults.QUERY) || monitor.isCanceled()) {
            return;
        }
        if (this.typeComputer.containsAnyType(literal, new String[]{"Replace-params"}) && !this.isValidReplaceParams(literal)) {
            return;
        }
        QuerySchema query = this.getQuerySchema(literal, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        if (query == null) {
            String message = Messages.QuerySyntaxValidator_Query_load_from_strinng_literal_lines_return_no_QL_object;
            resultAcceptor.addIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES);
            return;
        }
        Resource resource = query.eResource();
        if (resource == null) {
            return;
        }
        int lineShift = this.getLineShift(literal, query);
        try {
            this.addResourceDiagnostics(resultAcceptor, resource, lineShift);
        }
        finally {
            QlUtil.cleanUpQueryCache((QuerySchema)query);
        }
    }

    protected boolean isValidReplaceParams(StringLiteral literal) {
        EList lines = literal.lines(false);
        int i = 0;
        while (i < lines.size() - 1) {
            Map params;
            String line = (String)lines.get(i);
            Set<String> keys = QueryReplaceParamValidator.getKeysBeforeComment(line, params = Utils.getParamsMapFromNls((String)line));
            if (!(keys.isEmpty() || QueryReplaceParamValidator.isLikeKeyword(line, params) || QueryReplaceParamValidator.isParameterInStringLiteral(line, params))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void addResourceDiagnostics(BasicCheck.ResultAcceptor resultAcceptor, Resource resource, int lineShift) {
        String message;
        int i;
        for (Resource.Diagnostic error : resource.getErrors()) {
            i = error.getLine() - 1 + lineShift;
            message = this.getErrorMessage(error);
            resultAcceptor.addIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, i);
        }
        for (Resource.Diagnostic warning : resource.getWarnings()) {
            i = warning.getLine() - 1 + lineShift;
            message = this.getErrorMessage(warning);
            resultAcceptor.addIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, i);
        }
    }

    protected QuerySchema getQuerySchema(StringLiteral literal, IProgressMonitor monitor) {
        IFile file = this.resourceLookup.getPlatformResource((EObject)literal);
        if (file == null) {
            return null;
        }
        try {
            return this.dependentModelProvider.getQuerySchema((EObject)literal, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, this::getQueryText, (CancelIndicator)new MonitorBasedCancelIndicator(monitor));
        }
        catch (OperationCanceledException | OperationCanceledError e) {
            if (!monitor.isCanceled()) {
                BslPlugin.logError(e);
            }
            return null;
        }
    }

    protected String getErrorMessage(Resource.Diagnostic error) {
        return MessageFormat.format(Messages.QuerySyntaxValidator_Query_in_string_literal___E, error.getMessage());
    }

    protected int getLineShift(StringLiteral literal, QuerySchema query) {
        int end;
        int lineShift = 0;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)query);
        if (node != null && (end = node.getRootNode().getTotalEndLine()) < literal.getLines().size()) {
            lineShift = literal.getLines().size() - end;
        }
        return lineShift;
    }

    private String getQueryText(EObject object, EStructuralFeature feautre) {
        return BslUtils.getQueryText((StringLiteral)object);
    }
}

