/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralContentProcessor;
import com.e1c.langtool.v8.dt.bsl.stringliteral.TypedStringLiteralRegistry;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;

public class StringLiteralTypeAmbiguityValidator
extends BasicCheck {
    public static final String CHECK_ID = "string-literal-types";
    @Inject
    private IStringLiteralTypeComputer literalTypeComputer;
    @Inject
    private TypedStringLiteralRegistry typedStringLiteralRegistry;
    @Inject
    protected IV8ProjectManager v8ProjectManager;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.title(Messages.StringLiteralTypeAmbiguityValidator_title).description(Messages.StringLiteralTypeAmbiguityValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        @NonNull Collection types = this.literalTypeComputer.getAnnotatedTypes(literal);
        List<TypedStringLiteralContentProcessor> processors = this.typedStringLiteralRegistry.getContentProcessors(literal, types);
        if (processors.size() > 1) {
            this.addMessage(literal, resultAcceptor, types);
        } else {
            types = this.literalTypeComputer.computeTypes(literal);
            processors = this.typedStringLiteralRegistry.getContentProcessors(literal, types);
            if (processors.size() > 1) {
                this.addMessage(literal, resultAcceptor, types);
            }
        }
    }

    private void addMessage(StringLiteral literal, BasicCheck.ResultAcceptor resultAcceptor, Collection<LiteralType> types) {
        IV8Project v8project = this.v8ProjectManager.getProject((EObject)literal);
        boolean isRu = v8project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
        List<String> names = types.stream().map(t -> isRu ? t.getNameRu() : t.getName()).collect(Collectors.toList());
        String message = MessageFormat.format(Messages.StringLiteralTypeAmbiguityValidator_String_literal_has_incompatible_types, String.join((CharSequence)", ", names));
        BslCheckIssue issue = new BslCheckIssue(message, (EStructuralFeature)BslPackage.Literals.STRING_LITERAL__LINES, -1, names.toArray(new String[0]));
        resultAcceptor.addIssue((Issue)issue);
    }
}

