/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.stringliteral.LangToolDefaults;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringLiteralValidator
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "string-literal-translation";
    private static final String CHECK_LINES_COUNT_PARAMETER_NAME = "checkLinesCount";
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.StringLiteralValidator_title).description(Messages.StringLiteralValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).parameter(CHECK_LINES_COUNT_PARAMETER_NAME, Boolean.class, Boolean.TRUE.toString(), Messages.StringLiteralValidator_Check_lines_count_equals_translated_lines_count).module().checkedObjectType(new EClass[]{BslPackage.Literals.STRING_LITERAL});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        StringLiteral literal = (StringLiteral)object;
        if (!this.typeComputer.containsAnyType(literal, new String[]{"NStr"})) {
            return;
        }
        if (!this.typeComputer.containsAnyType(literal, new String[]{"NStr", "Standard"}) && !this.typeComputer.containsAnyType(literal, LangToolDefaults.QUERY)) {
            this.checkTranslation((EObject)literal, resultAcceptor, parameters, monitor);
        }
    }

    protected EStructuralFeature getMessageFeature(FeatureSettings featureSettings) {
        return BslPackage.Literals.STRING_LITERAL__LINES;
    }

    protected String getTranslation(IProject project, FeatureValue featureValue, TranslateLanguage language, EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters) {
        int total;
        int lines;
        String translation = super.getTranslation(project, featureValue, language, object, resultAcceptor, parameters);
        if (StringUtils.isNotEmpty((String)translation) && parameters.getBoolean(CHECK_LINES_COUNT_PARAMETER_NAME) && (lines = ((StringLiteral)object).getLines().size()) > 1 && (total = translation.split("\n", -1).length) != lines) {
            this.addNotEqualMultiLinesMessage(object, resultAcceptor, language, lines, total);
        }
        return translation;
    }

    private void addNotEqualMultiLinesMessage(EObject object, BasicCheck.ResultAcceptor resultAcceptor, TranslateLanguage language, int sourceLines, int total) {
        String message = MessageFormat.format(Messages.StringLiteralValidator_Translation_into_language_has_lines_instead_of_for_multiline_string_literal, language.getName(), total, sourceLines);
        resultAcceptor.addIssue(message, (Object)object, this.getMessageFeature(null));
    }
}

