/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.validation;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.model.SimpleStatement;
import com._1c.g5.v8.dt.bsl.model.StaticFeatureAccess;
import com._1c.g5.v8.dt.bsl.model.Variable;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.components.ModuleTopObjectNameFilterExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.bsl.validation.Messages;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class VariableTranslationValidator
extends AbstractTranslationValidator {
    public static final String CHECK_ID = "variable-translation";

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.VariableTranslationValidator_title).description(Messages.VariableTranslationValidator_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).extension((IBasicCheckExtension)new ModuleTopObjectNameFilterExtension()).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).issueType(IssueType.WARNING).module().checkedObjectType(new EClass[]{BslPackage.Literals.VARIABLE});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Variable variable = null;
        if (object instanceof Variable) {
            variable = (Variable)object;
        } else if (object instanceof SimpleStatement && ((SimpleStatement)object).getLeft() instanceof StaticFeatureAccess && ((StaticFeatureAccess)((SimpleStatement)object).getLeft()).getImplicitVariable() != null) {
            variable = ((StaticFeatureAccess)((SimpleStatement)object).getLeft()).getImplicitVariable();
        }
        if (variable == null || monitor.isCanceled()) {
            return;
        }
        this.checkTranslation((EObject)variable, resultAcceptor, parameters, monitor);
    }

    protected void addNoTranslationMessage(EObject object, BasicCheck.ResultAcceptor resultAcceptor, String value, FeatureKey key, FeatureSettings featureSettings, Collection<String> languages) {
        if (object instanceof Variable && object.eContainer() instanceof StaticFeatureAccess && object.eContainer().eContainer() instanceof SimpleStatement) {
            String message = MessageFormat.format(Messages.VariableTranslationValidator_No_translation_for_value_in_key_into_languages, value, key, String.join((CharSequence)", ", languages));
            BslCheckIssue issue = new BslCheckIssue(message, (EStructuralFeature)McorePackage.Literals.NAMED_ELEMENT__NAME, -1, languages.toArray(new String[0]));
            resultAcceptor.addIssue((Issue)issue);
        } else {
            super.addNoTranslationMessage(object, resultAcceptor, value, key, featureSettings, languages);
        }
    }
}

