/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl;

import com._1c.g5.v8.dt.bsl.model.BslPackage;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.TypeUtil;
import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.internal.bsl.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.internal.bsl.ServiceModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class BslPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.bsl";
    private static BslPlugin plugin;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;
    private static BundleContext context;

    public static BslPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        BslPlugin.log(BslPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static void logError(String message, Throwable throwable) {
        BslPlugin.log(BslPlugin.createErrorStatus(message, throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
        BslPackage.eINSTANCE.eClass();
        this.registrator = new InjectorAwareServiceRegistrator(bundleContext, this::getInjector);
        ServiceInitialization.schedule(() -> {
            this.registrator.managedService(BslPreferences.class).activateBeforeRegistration().registerInjected();
            TypeUtil.setStringLiteralContentTypesEnabled((boolean)true);
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registrator.deactivateManagedServices((Plugin)this);
        this.registrator.unregisterServices();
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<BslPlugin> clazz = BslPlugin.class;
        synchronized (BslPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            BslPlugin.log(BslPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return preferences;
    }
}

